#
# TABLE STRUCTURE FOR: account
#

DROP TABLE IF EXISTS `account`;

CREATE TABLE `account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_name` varchar(50) NOT NULL,
  `account_type` varchar(100) NOT NULL,
  `account_no` varchar(15) NOT NULL,
  `bank_name` varchar(100) NOT NULL,
  `opening_balance` int(11) NOT NULL,
  `bank_address` varchar(200) NOT NULL,
  `default_account` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `delete_status` tinyint(4) DEFAULT 0,
  `delete_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `account` (`id`, `account_name`, `account_type`, `account_no`, `bank_name`, `opening_balance`, `bank_address`, `default_account`, `created_at`, `delete_status`, `delete_date`) VALUES ('1', 'CASH DEPOSITS', 'Cash', '071810200000620', 'IDBI BANK', '716427', 'PERIAYNAGAR', '1', '2017-09-29 16:06:16', '0', NULL);
INSERT INTO `account` (`id`, `account_name`, `account_type`, `account_no`, `bank_name`, `opening_balance`, `bank_address`, `default_account`, `created_at`, `delete_status`, `delete_date`) VALUES ('2', 'DEVASENA ENTERPRISES', 'Chequing', '071810200000620', 'IDBI BANK', '5582010', 'PERIAYNAGAR', '1', '2017-09-29 16:07:09', '0', NULL);
INSERT INTO `account` (`id`, `account_name`, `account_type`, `account_no`, `bank_name`, `opening_balance`, `bank_address`, `default_account`, `created_at`, `delete_status`, `delete_date`) VALUES ('3', 'ONLINE', 'Cash', '071810200000620', 'IDBI BANK', '475507', 'PERIAYNAGAR', 'yes', '2017-09-29 16:09:09', '0', NULL);


#
# TABLE STRUCTURE FOR: active_gateway
#

DROP TABLE IF EXISTS `active_gateway`;

CREATE TABLE `active_gateway` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active_gateway` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `active_gateway` (`id`, `active_gateway`) VALUES ('1', 'easebuzz');


#
# TABLE STRUCTURE FOR: assessment_years
#

DROP TABLE IF EXISTS `assessment_years`;

CREATE TABLE `assessment_years` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ass_year` varchar(50) DEFAULT NULL,
  `validity_from` varchar(50) DEFAULT NULL,
  `validity_to` varchar(50) DEFAULT NULL,
  `po` varchar(50) DEFAULT NULL,
  `dc` varchar(50) DEFAULT NULL,
  `quotation` varchar(50) DEFAULT NULL,
  `invoice` varchar(50) DEFAULT NULL,
  `created_date` varchar(50) DEFAULT NULL,
  `defaults` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 COMMENT='Assessment Year';

INSERT INTO `assessment_years` (`id`, `ass_year`, `validity_from`, `validity_to`, `po`, `dc`, `quotation`, `invoice`, `created_date`, `defaults`) VALUES ('9', '2017-18', '01-04-2017', '31-03-2018', '1', '1', '1', '1', NULL, '0');
INSERT INTO `assessment_years` (`id`, `ass_year`, `validity_from`, `validity_to`, `po`, `dc`, `quotation`, `invoice`, `created_date`, `defaults`) VALUES ('11', '2018-19', '1-04-2018', '31-03-2019', '', '', '', '', NULL, '0');
INSERT INTO `assessment_years` (`id`, `ass_year`, `validity_from`, `validity_to`, `po`, `dc`, `quotation`, `invoice`, `created_date`, `defaults`) VALUES ('12', '2019-20', '01-04-2019', '31-03-2020', NULL, NULL, NULL, NULL, NULL, '0');
INSERT INTO `assessment_years` (`id`, `ass_year`, `validity_from`, `validity_to`, `po`, `dc`, `quotation`, `invoice`, `created_date`, `defaults`) VALUES ('13', '2020-21', '01-04-2020', '31-03-2021', NULL, NULL, NULL, NULL, NULL, '0');
INSERT INTO `assessment_years` (`id`, `ass_year`, `validity_from`, `validity_to`, `po`, `dc`, `quotation`, `invoice`, `created_date`, `defaults`) VALUES ('14', '2021-22', '01-04-2021', '31-03-2022', '001', '001', '001', '001', NULL, '0');
INSERT INTO `assessment_years` (`id`, `ass_year`, `validity_from`, `validity_to`, `po`, `dc`, `quotation`, `invoice`, `created_date`, `defaults`) VALUES ('15', '2022-23', '01-04-2022', '31-03-2023', '001', '001', '001', '001', NULL, '1');


#
# TABLE STRUCTURE FOR: backup
#

DROP TABLE IF EXISTS `backup`;

CREATE TABLE `backup` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `delete_status` tinyint(4) DEFAULT 0,
  `delete_date` date DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `backup` (`id`, `name`, `date`, `delete_status`, `delete_date`, `user_id`) VALUES ('1', 'dbbackup_29_09_2017_16_19_53.zip', '2017-09-29 16:19:53', '1', '2017-09-29', NULL);
INSERT INTO `backup` (`id`, `name`, `date`, `delete_status`, `delete_date`, `user_id`) VALUES ('2', 'dbbackup_29_09_2017_16_32_30.zip', '2017-09-29 16:32:30', '0', NULL, NULL);
INSERT INTO `backup` (`id`, `name`, `date`, `delete_status`, `delete_date`, `user_id`) VALUES ('3', 'dbbackup_03_10_2017_11_03_31.zip', '2017-10-03 11:03:31', '0', NULL, '1');
INSERT INTO `backup` (`id`, `name`, `date`, `delete_status`, `delete_date`, `user_id`) VALUES ('4', 'dbbackup_05_10_2017_18_44_06.zip', '2017-10-05 18:44:06', '0', NULL, '1');
INSERT INTO `backup` (`id`, `name`, `date`, `delete_status`, `delete_date`, `user_id`) VALUES ('5', 'dbbackup_20_11_2017_13_50_31.zip', '2017-11-20 13:50:31', '0', NULL, '1');
INSERT INTO `backup` (`id`, `name`, `date`, `delete_status`, `delete_date`, `user_id`) VALUES ('6', 'dbbackup_20_11_2017_18_52_04.zip', '2017-11-20 18:52:04', '0', NULL, '1');
INSERT INTO `backup` (`id`, `name`, `date`, `delete_status`, `delete_date`, `user_id`) VALUES ('7', 'dbbackup_10_04_2023_10_26_16.zip', '2023-04-10 10:26:16', '0', NULL, '1');


#
# TABLE STRUCTURE FOR: bank_account_deposit
#

DROP TABLE IF EXISTS `bank_account_deposit`;

CREATE TABLE `bank_account_deposit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `amount` double(10,2) NOT NULL,
  `category_id` int(11) NOT NULL,
  `payment_method_id` int(11) NOT NULL,
  `bank_name` varchar(150) DEFAULT NULL,
  `cheque_no` varchar(50) DEFAULT NULL,
  `reference_no` varchar(15) DEFAULT NULL,
  `file` varchar(50) DEFAULT NULL,
  `delete_status` tinyint(4) DEFAULT 0,
  `delete_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: bank_account_transfer
#

DROP TABLE IF EXISTS `bank_account_transfer`;

CREATE TABLE `bank_account_transfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_account_id` int(11) NOT NULL,
  `to_account_id` int(11) NOT NULL,
  `date` varchar(15) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `amount` double NOT NULL,
  `payment_method_id` int(11) DEFAULT NULL,
  `bank_name` varchar(150) DEFAULT NULL,
  `cheque_no` varchar(100) DEFAULT NULL,
  `reference_no` varchar(15) DEFAULT NULL,
  `delete_status` tinyint(4) DEFAULT 0,
  `delete_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: blog
#

DROP TABLE IF EXISTS `blog`;

CREATE TABLE `blog` (
  `blog_id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `blog_description` text DEFAULT NULL,
  PRIMARY KEY (`blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bom
#

DROP TABLE IF EXISTS `bom`;

CREATE TABLE `bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bom_main_item_id` int(11) DEFAULT NULL,
  `date` varchar(50) NOT NULL,
  `reference_no` varchar(50) NOT NULL,
  `total_tax` double(10,2) NOT NULL,
  `shipping_charges` double DEFAULT NULL,
  `total_amount` double(10,2) NOT NULL,
  `notes` varchar(200) DEFAULT NULL,
  `delete_status` tinyint(4) DEFAULT 0,
  `delete_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `bom` (`id`, `bom_main_item_id`, `date`, `reference_no`, `total_tax`, `shipping_charges`, `total_amount`, `notes`, `delete_status`, `delete_date`) VALUES ('5', '3', '26-08-2019', 'BOMNo-0001/2019-20', '11900.00', NULL, '56900.00', '', '0', NULL);


#
# TABLE STRUCTURE FOR: bom_items
#

DROP TABLE IF EXISTS `bom_items`;

CREATE TABLE `bom_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bom_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `item_description` varchar(200) DEFAULT NULL,
  `qty` float DEFAULT NULL,
  `rate` double NOT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax` double NOT NULL,
  `discount` double NOT NULL,
  `amount` double NOT NULL,
  `sub_invoice_no` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO `bom_items` (`id`, `bom_id`, `item_id`, `item_description`, `qty`, `rate`, `tax_id`, `tax`, `discount`, `amount`, `sub_invoice_no`) VALUES ('11', '5', '5', NULL, '1', '5000', '4', '1400', '0', '6400', 'BOMNo-0001/2019-20-4');
INSERT INTO `bom_items` (`id`, `bom_id`, `item_id`, `item_description`, `qty`, `rate`, `tax_id`, `tax`, `discount`, `amount`, `sub_invoice_no`) VALUES ('12', '5', '2', NULL, '3', '11000', '4', '9240', '0', '42240', 'BOMNo-0001/2019-20-4');
INSERT INTO `bom_items` (`id`, `bom_id`, `item_id`, `item_description`, `qty`, `rate`, `tax_id`, `tax`, `discount`, `amount`, `sub_invoice_no`) VALUES ('13', '5', '18', NULL, '1', '7000', '3', '1260', '0', '8260', 'BOMNo-0001/2019-20-3');


#
# TABLE STRUCTURE FOR: c_dc
#

DROP TABLE IF EXISTS `c_dc`;

CREATE TABLE `c_dc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `no` varchar(255) DEFAULT NULL,
  `serial` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `c_dc` (`id`, `no`, `serial`) VALUES ('1', '1', NULL);
INSERT INTO `c_dc` (`id`, `no`, `serial`) VALUES ('2', '2', '2018-19');
INSERT INTO `c_dc` (`id`, `no`, `serial`) VALUES ('3', '2', '2021-22');
INSERT INTO `c_dc` (`id`, `no`, `serial`) VALUES ('4', '3', '2021-22');
INSERT INTO `c_dc` (`id`, `no`, `serial`) VALUES ('5', '2', '2022-23');
INSERT INTO `c_dc` (`id`, `no`, `serial`) VALUES ('6', '3', '2022-23');
INSERT INTO `c_dc` (`id`, `no`, `serial`) VALUES ('7', '4', '2022-23');


#
# TABLE STRUCTURE FOR: c_po
#

DROP TABLE IF EXISTS `c_po`;

CREATE TABLE `c_po` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `no` varchar(255) DEFAULT NULL,
  `serial` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `c_po` (`id`, `no`, `serial`) VALUES ('1', '1', NULL);
INSERT INTO `c_po` (`id`, `no`, `serial`) VALUES ('2', '2', '2018-19');
INSERT INTO `c_po` (`id`, `no`, `serial`) VALUES ('3', '3', '2019-20');
INSERT INTO `c_po` (`id`, `no`, `serial`) VALUES ('4', '4', '2019-20');


#
# TABLE STRUCTURE FOR: catalogs
#

DROP TABLE IF EXISTS `catalogs`;

CREATE TABLE `catalogs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO `catalogs` (`id`, `name`, `content`) VALUES ('1', 'MYPROFILE', '<p><img src=\"/assets/ckfinder/userfiles/images/c0e5ef38-04cb-4885-af5d-7436e8870a35.jpg\" style=\"height:700px; width:700px\" /><img src=\"/assets/ckfinder/userfiles/images/13e6497c-38f6-4837-9d5f-76edef61dcd7.jpg\" style=\"height:772px; width:1160px\" /><img src=\"/assets/ckfinder/userfiles/images/aacbc013-c15d-464d-a75f-84242b589579.jpg\" style=\"height:720px; width:1280px\" /></p>');
INSERT INTO `catalogs` (`id`, `name`, `content`) VALUES ('2', 'ro banner', '<p><a href=\"rowaterpurifierinchennai.com\"><img alt=\"\" src=\"/assets/ckfinder/userfiles/images/WhatsApp%20Image%202021-03-17%20at%2012_39_00%20PM(1).jpeg\" style=\"height:592px; width:1000px\" /></a></p><p><img src=\"/assets/ckfinder/userfiles/images/WhatsApp%20Image%202022-03-06%20at%204_39_13%20PM(1).jpeg\" style=\"height:1280px; width:905px\" /></p>');
INSERT INTO `catalogs` (`id`, `name`, `content`) VALUES ('3', 'WHATSAPP', '<p><a href=\"http://www.devasena.net/whatsapp.html\" target=\"_blank\"><img src=\"/assets/ckfinder/userfiles/images/WhatsApp%20Image%202020-12-15%20at%2011_22_32%20PM.jpeg\" style=\"height:554px; width:969px\" /></a></p>');
INSERT INTO `catalogs` (`id`, `name`, `content`) VALUES ('4', 'GOOGLE LOCATION', '<p><img src=\"/assets/ckfinder/userfiles/images/WhatsApp%20Image%202022-01-31%20at%206_18_30%20PM.jpeg\" style=\"height:1204px; width:820px\" /></p>');
INSERT INTO `catalogs` (`id`, `name`, `content`) VALUES ('6', 'Main Catalog All', '<p><a href=\"http://devasena.net/\"><img src=\"/assets/ckfinder/userfiles/images/14257595_1181121525291348_3734904858318524879_o.jpg\" style=\"height:389px; width:960px\" /></a></p><p><a href=\"http://devasena.net/\"><img src=\"/assets/ckfinder/userfiles/images/14310438_1183331428403691_1900869877521253198_o.jpg\" style=\"height:389px; width:960px\" /></a></p><p><a href=\"http://devasena.net/\"><img src=\"/assets/ckfinder/userfiles/images/14711542_1221957494541084_8897789737774412152_o.jpg\" style=\"height:540px; width:960px\" /></a></p><p><a href=\"https://myprofile.devasena.biz/\"><img src=\"/assets/ckfinder/userfiles/images/aacbc013-c15d-464d-a75f-84242b589579(1).jpg\" style=\"height:720px; width:1280px\" /></a></p><p><a href=\"https://myprofile.devasena.biz/\"><img src=\"/assets/ckfinder/userfiles/images/bc09c5df-ae88-44c2-90d0-9b6065838a7a.jpg\" style=\"height:469px; width:1000px\" /></a></p><p>&nbsp;</p><p><a href=\"https://devasena.in/\"><img src=\"/assets/ckfinder/userfiles/images/INVERTER-1.jpg\" style=\"height:800px; width:1200px\" /></a></p><p><a href=\"http://www.devasena.net/whatsapp.html\"><img src=\"/assets/ckfinder/userfiles/images/WhatsApp%20Image%202020-12-15%20at%2011_22_32%20PM(1).jpeg\" style=\"height:554px; width:969px\" /></a></p><p><a href=\"http://www.devasena.net/\"><img src=\"/assets/ckfinder/userfiles/images/WhatsApp%20Image%202022-01-31%20at%206_18_30%20PM(1).jpeg\" style=\"height:1204px; width:820px\" /></a></p><p><a href=\"https://www.rowaterpurifierinchennai.com/\"><img src=\"/assets/ckfinder/userfiles/images/WhatsApp%20Image%202022-03-06%20at%204_39_13%20PM.jpeg\" style=\"height:1280px; width:905px\" /></a></p><p><a href=\"https://www.rowaterpurifierinchennai.com/content/products/55-Bike-Tyre-punchure-pro.php\"><img src=\"/assets/ckfinder/userfiles/images/1_6dc3ab3c22.jpeg\" style=\"height:776px; width:600px\" /></a></p>');


#
# TABLE STRUCTURE FOR: category
#

DROP TABLE IF EXISTS `category`;

CREATE TABLE `category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) DEFAULT NULL,
  `unit` int(11) DEFAULT NULL,
  `delete_status` tinyint(4) NOT NULL DEFAULT 0,
  `delete_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=latin1;

INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('1', 'INVERTER', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('2', 'DOMAIN', '5', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('3', 'DOMAIN', '5', '1', '2017-09-10');
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('4', 'BATTERY', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('5', 'WEB DESIGN', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('6', 'DIGITAL PRODUCTS', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('7', 'SSL', '5', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('8', 'UPS', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('9', 'ADVERTISING', '5', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('10', 'HOSTING AND INFORMATION TECHNOLOGY', '5', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('11', 'TELEPHONE SETS', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('12', 'JEWELS', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('13', 'HOME APPLIANCE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('14', 'RO SPARES', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('15', 'RO SYSTEM', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('16', 'VISA SERVICE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('17', 'ICE CREAM', '3', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('18', 'OLD BALANCE', '5', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('19', 'WIRELESS PHONE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('20', 'STABILIZER', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('21', 'CELLING FAN', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('22', 'TRAINING FEES', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('23', 'Fees', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('24', 'Fees', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('25', 'WATER PURIFIER', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('26', 'SPARES', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('27', 'HANDLE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('28', 'CABINET', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('29', 'MUSTARD SMALL', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('30', 'FOOD ITEMS', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('31', 'ULTIMATE SECURITY', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('32', 'FITTINGS', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('33', 'PULSE CHECKER', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('34', 'THERMOMETER', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('35', 'ADHESIVE GLUE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('36', 'INJECTOR', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('37', 'INFLATOR', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('38', 'BULB', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('39', 'BULB', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('40', 'COMPONENTS', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('41', 'SOLDERING IRON', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('42', 'SOLDERING LEAD', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('43', 'REXNORD', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('44', 'CONTAINER', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('45', 'SLEEVE SEPARATORS', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('46', 'MACHINE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('47', 'TABLE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('48', 'TOOL', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('49', 'PLATES', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('50', 'MOLDS', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('51', 'JIG', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('52', 'PIPES', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('53', 'LEAD', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('54', 'RESIN', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('55', 'STRAND MAT', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('56', 'CATALYST', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('57', 'ACCELERATOR', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('58', 'PIGMENT', '2', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('59', 'BRUSH', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('60', 'PLASTIC BAG', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('61', 'ORBIT CORE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('62', '3 PIN TOP', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('63', 'ANCHOR', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('64', 'HOLDER', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('65', 'FRAME', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('66', 'PAPER', '1', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('67', 'TAPE', '4', '0', NULL);
INSERT INTO `category` (`id`, `category_name`, `unit`, `delete_status`, `delete_date`) VALUES ('68', 'SCOOTY', '4', '0', NULL);


#
# TABLE STRUCTURE FOR: cities
#

DROP TABLE IF EXISTS `cities`;

CREATE TABLE `cities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `state_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48316 DEFAULT CHARSET=latin1;

INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1', 'Bombuflat', '1');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2', 'Garacharma', '1');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3', 'Port Blair', '1');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4', 'Rangat', '1');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5', 'Addanki', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6', 'Adivivaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7', 'Adoni', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8', 'Aganampudi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9', 'Ajjaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10', 'Akividu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11', 'Akkarampalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('12', 'Akkayapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('13', 'Akkireddipalem', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('14', 'Alampur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('15', 'Amalapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('16', 'Amudalavalasa', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('17', 'Amur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('18', 'Anakapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('19', 'Anantapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('20', 'Andole', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('21', 'Atmakur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('22', 'Attili', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('23', 'Avanigadda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('24', 'Badepalli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('25', 'Badvel', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('26', 'Balapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('27', 'Bandarulanka', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('28', 'Banganapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('29', 'Bapatla', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('30', 'Bapulapadu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('31', 'Belampalli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('32', 'Bestavaripeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('33', 'Betamcherla', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('34', 'Bhattiprolu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('35', 'Bhimavaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('36', 'Bhimunipatnam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('37', 'Bobbili', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('38', 'Bombuflat', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('39', 'Bommuru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('40', 'Bugganipalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('41', 'Challapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('42', 'Chandur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('43', 'Chatakonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('44', 'Chemmumiahpet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('45', 'Chidiga', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('46', 'Chilakaluripet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('47', 'Chimakurthy', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('48', 'Chinagadila', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('49', 'Chinagantyada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('50', 'Chinnachawk', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('51', 'Chintalavalasa', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('52', 'Chipurupalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('53', 'Chirala', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('54', 'Chittoor', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('55', 'Chodavaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('56', 'Choutuppal', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('57', 'Chunchupalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('58', 'Cuddapah', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('59', 'Cumbum', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('60', 'Darnakal', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('61', 'Dasnapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('62', 'Dauleshwaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('63', 'Dharmavaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('64', 'Dhone', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('65', 'Dommara Nandyal', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('66', 'Dowlaiswaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('67', 'East Godavari Dist.', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('68', 'Eddumailaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('69', 'Edulapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('70', 'Ekambara kuppam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('71', 'Eluru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('72', 'Enikapadu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('73', 'Fakirtakya', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('74', 'Farrukhnagar', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('75', 'Gaddiannaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('76', 'Gajapathinagaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('77', 'Gajularega', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('78', 'Gajuvaka', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('79', 'Gannavaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('80', 'Garacharma', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('81', 'Garimellapadu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('82', 'Giddalur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('83', 'Godavarikhani', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('84', 'Gopalapatnam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('85', 'Gopalur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('86', 'Gorrekunta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('87', 'Gudivada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('88', 'Gudur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('89', 'Guntakal', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('90', 'Guntur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('91', 'Guti', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('92', 'Hindupur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('93', 'Hukumpeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('94', 'Ichchapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('95', 'Isnapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('96', 'Jaggayyapeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('97', 'Jallaram Kamanpur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('98', 'Jammalamadugu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('99', 'Jangampalli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('100', 'Jarjapupeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('101', 'Kadiri', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('102', 'Kaikalur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('103', 'Kakinada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('104', 'Kallur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('105', 'Kalyandurg', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('106', 'Kamalapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('107', 'Kamareddi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('108', 'Kanapaka', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('109', 'Kanigiri', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('110', 'Kanithi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('111', 'Kankipadu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('112', 'Kantabamsuguda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('113', 'Kanuru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('114', 'Karnul', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('115', 'Katheru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('116', 'Kavali', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('117', 'Kazipet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('118', 'Khanapuram Haveli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('119', 'Kodar', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('120', 'Kollapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('121', 'Kondapalem', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('122', 'Kondapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('123', 'Kondukur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('124', 'Kosgi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('125', 'Kothavalasa', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('126', 'Kottapalli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('127', 'Kovur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('128', 'Kovurpalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('129', 'Kovvur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('130', 'Krishna', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('131', 'Kuppam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('132', 'Kurmannapalem', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('133', 'Kurnool', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('134', 'Lakshettipet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('135', 'Lalbahadur Nagar', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('136', 'Machavaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('137', 'Macherla', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('138', 'Machilipatnam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('139', 'Madanapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('140', 'Madaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('141', 'Madhuravada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('142', 'Madikonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('143', 'Madugule', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('144', 'Mahabubnagar', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('145', 'Mahbubabad', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('146', 'Malkajgiri', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('147', 'Mamilapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('148', 'Mancheral', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('149', 'Mandapeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('150', 'Mandasa', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('151', 'Mangalagiri', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('152', 'Manthani', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('153', 'Markapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('154', 'Marturu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('155', 'Metpalli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('156', 'Mindi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('157', 'Mirpet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('158', 'Moragudi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('159', 'Mothugudam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('160', 'Nagari', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('161', 'Nagireddipalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('162', 'Nandigama', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('163', 'Nandikotkur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('164', 'Nandyal', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('165', 'Narasannapeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('166', 'Narasapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('167', 'Narasaraopet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('168', 'Narayanavanam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('169', 'Narsapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('170', 'Narsingi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('171', 'Narsipatnam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('172', 'Naspur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('173', 'Nathayyapalem', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('174', 'Nayudupeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('175', 'Nelimaria', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('176', 'Nellore', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('177', 'Nidadavole', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('178', 'Nuzvid', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('179', 'Omerkhan daira', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('180', 'Ongole', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('181', 'Osmania University', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('182', 'Pakala', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('183', 'Palakole', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('184', 'Palakurthi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('185', 'Palasa', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('186', 'Palempalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('187', 'Palkonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('188', 'Palmaner', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('189', 'Pamur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('190', 'Panjim', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('191', 'Papampeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('192', 'Parasamba', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('193', 'Parvatipuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('194', 'Patancheru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('195', 'Payakaraopet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('196', 'Pedagantyada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('197', 'Pedana', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('198', 'Peddapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('199', 'Pendurthi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('200', 'Penugonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('201', 'Penukonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('202', 'Phirangipuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('203', 'Pithapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('204', 'Ponnur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('205', 'Port Blair', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('206', 'Pothinamallayyapalem', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('207', 'Prakasam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('208', 'Prasadampadu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('209', 'Prasantinilayam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('210', 'Proddatur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('211', 'Pulivendla', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('212', 'Punganuru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('213', 'Puttur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('214', 'Qutubullapur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('215', 'Rajahmundry', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('216', 'Rajamahendri', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('217', 'Rajampet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('218', 'Rajendranagar', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('219', 'Rajoli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('220', 'Ramachandrapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('221', 'Ramanayyapeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('222', 'Ramapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('223', 'Ramarajupalli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('224', 'Ramavarappadu', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('225', 'Rameswaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('226', 'Rampachodavaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('227', 'Ravulapalam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('228', 'Rayachoti', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('229', 'Rayadrug', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('230', 'Razam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('231', 'Razole', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('232', 'Renigunta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('233', 'Repalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('234', 'Rishikonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('235', 'Salur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('236', 'Samalkot', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('237', 'Sattenapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('238', 'Seetharampuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('239', 'Serilungampalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('240', 'Shankarampet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('241', 'Shar', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('242', 'Singarayakonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('243', 'Sirpur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('244', 'Sirsilla', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('245', 'Sompeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('246', 'Sriharikota', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('247', 'Srikakulam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('248', 'Srikalahasti', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('249', 'Sriramnagar', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('250', 'Sriramsagar', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('251', 'Srisailam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('252', 'Srisailamgudem Devasthanam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('253', 'Sulurpeta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('254', 'Suriapet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('255', 'Suryaraopet', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('256', 'Tadepalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('257', 'Tadepalligudem', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('258', 'Tadpatri', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('259', 'Tallapalle', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('260', 'Tanuku', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('261', 'Tekkali', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('262', 'Tenali', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('263', 'Tigalapahad', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('264', 'Tiruchanur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('265', 'Tirumala', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('266', 'Tirupati', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('267', 'Tirvuru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('268', 'Trimulgherry', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('269', 'Tuni', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('270', 'Turangi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('271', 'Ukkayapalli', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('272', 'Ukkunagaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('273', 'Uppal Kalan', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('274', 'Upper Sileru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('275', 'Uravakonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('276', 'Vadlapudi', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('277', 'Vaparala', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('278', 'Vemalwada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('279', 'Venkatagiri', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('280', 'Venkatapuram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('281', 'Vepagunta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('282', 'Vetapalem', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('283', 'Vijayapuri', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('284', 'Vijayapuri South', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('285', 'Vijayawada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('286', 'Vinukonda', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('287', 'Visakhapatnam', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('288', 'Vizianagaram', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('289', 'Vuyyuru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('290', 'Wanparti', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('291', 'West Godavari Dist.', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('292', 'Yadagirigutta', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('293', 'Yarada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('294', 'Yellamanchili', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('295', 'Yemmiganur', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('296', 'Yenamalakudru', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('297', 'Yendada', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('298', 'Yerraguntla', '2');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('299', 'Along', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('300', 'Basar', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('301', 'Bondila', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('302', 'Changlang', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('303', 'Daporijo', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('304', 'Deomali', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('305', 'Itanagar', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('306', 'Jairampur', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('307', 'Khonsa', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('308', 'Naharlagun', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('309', 'Namsai', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('310', 'Pasighat', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('311', 'Roing', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('312', 'Seppa', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('313', 'Tawang', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('314', 'Tezu', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('315', 'Ziro', '3');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('316', 'Abhayapuri', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('317', 'Ambikapur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('318', 'Amguri', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('319', 'Anand Nagar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('320', 'Badarpur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('321', 'Badarpur Railway Town', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('322', 'Bahbari Gaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('323', 'Bamun Sualkuchi', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('324', 'Barbari', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('325', 'Barpathar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('326', 'Barpeta', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('327', 'Barpeta Road', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('328', 'Basugaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('329', 'Bihpuria', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('330', 'Bijni', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('331', 'Bilasipara', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('332', 'Biswanath Chariali', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('333', 'Bohori', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('334', 'Bokajan', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('335', 'Bokokhat', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('336', 'Bongaigaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('337', 'Bongaigaon Petro-chemical Town', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('338', 'Borgolai', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('339', 'Chabua', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('340', 'Chandrapur Bagicha', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('341', 'Chapar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('342', 'Chekonidhara', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('343', 'Choto Haibor', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('344', 'Dergaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('345', 'Dharapur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('346', 'Dhekiajuli', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('347', 'Dhemaji', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('348', 'Dhing', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('349', 'Dhubri', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('350', 'Dhuburi', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('351', 'Dibrugarh', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('352', 'Digboi', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('353', 'Digboi Oil Town', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('354', 'Dimaruguri', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('355', 'Diphu', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('356', 'Dispur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('357', 'Doboka', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('358', 'Dokmoka', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('359', 'Donkamokan', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('360', 'Duliagaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('361', 'Duliajan', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('362', 'Duliajan No.1', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('363', 'Dum Duma', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('364', 'Durga Nagar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('365', 'Gauripur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('366', 'Goalpara', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('367', 'Gohpur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('368', 'Golaghat', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('369', 'Golakganj', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('370', 'Gossaigaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('371', 'Guwahati', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('372', 'Haflong', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('373', 'Hailakandi', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('374', 'Hamren', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('375', 'Hauli', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('376', 'Hauraghat', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('377', 'Hojai', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('378', 'Jagiroad', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('379', 'Jagiroad Paper Mill', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('380', 'Jogighopa', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('381', 'Jonai Bazar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('382', 'Jorhat', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('383', 'Kampur Town', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('384', 'Kamrup', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('385', 'Kanakpur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('386', 'Karimganj', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('387', 'Kharijapikon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('388', 'Kharupetia', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('389', 'Kochpara', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('390', 'Kokrajhar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('391', 'Kumar Kaibarta Gaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('392', 'Lakhimpur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('393', 'Lakhipur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('394', 'Lala', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('395', 'Lanka', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('396', 'Lido Tikok', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('397', 'Lido Town', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('398', 'Lumding', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('399', 'Lumding Railway Colony', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('400', 'Mahur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('401', 'Maibong', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('402', 'Majgaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('403', 'Makum', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('404', 'Mangaldai', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('405', 'Mankachar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('406', 'Margherita', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('407', 'Mariani', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('408', 'Marigaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('409', 'Moran', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('410', 'Moranhat', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('411', 'Nagaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('412', 'Naharkatia', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('413', 'Nalbari', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('414', 'Namrup', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('415', 'Naubaisa Gaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('416', 'Nazira', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('417', 'New Bongaigaon Railway Colony', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('418', 'Niz-Hajo', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('419', 'North Guwahati', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('420', 'Numaligarh', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('421', 'Palasbari', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('422', 'Panchgram', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('423', 'Pathsala', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('424', 'Raha', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('425', 'Rangapara', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('426', 'Rangia', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('427', 'Salakati', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('428', 'Sapatgram', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('429', 'Sarthebari', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('430', 'Sarupathar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('431', 'Sarupathar Bengali', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('432', 'Senchoagaon', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('433', 'Sibsagar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('434', 'Silapathar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('435', 'Silchar', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('436', 'Silchar Part-X', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('437', 'Sonari', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('438', 'Sorbhog', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('439', 'Sualkuchi', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('440', 'Tangla', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('441', 'Tezpur', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('442', 'Tihu', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('443', 'Tinsukia', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('444', 'Titabor', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('445', 'Udalguri', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('446', 'Umrangso', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('447', 'Uttar Krishnapur Part-I', '4');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('448', 'Amarpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('449', 'Ara', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('450', 'Araria', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('451', 'Areraj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('452', 'Asarganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('453', 'Aurangabad', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('454', 'Bagaha', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('455', 'Bahadurganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('456', 'Bairgania', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('457', 'Bakhtiyarpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('458', 'Banka', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('459', 'Banmankhi', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('460', 'Bar Bigha', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('461', 'Barauli', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('462', 'Barauni Oil Township', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('463', 'Barh', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('464', 'Barhiya', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('465', 'Bariapur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('466', 'Baruni', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('467', 'Begusarai', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('468', 'Behea', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('469', 'Belsand', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('470', 'Bettiah', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('471', 'Bhabua', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('472', 'Bhagalpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('473', 'Bhimnagar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('474', 'Bhojpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('475', 'Bihar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('476', 'Bihar Sharif', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('477', 'Bihariganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('478', 'Bikramganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('479', 'Birpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('480', 'Bodh Gaya', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('481', 'Buxar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('482', 'Chakia', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('483', 'Chanpatia', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('484', 'Chhapra', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('485', 'Chhatapur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('486', 'Colgong', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('487', 'Dalsingh Sarai', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('488', 'Darbhanga', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('489', 'Daudnagar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('490', 'Dehri', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('491', 'Dhaka', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('492', 'Dighwara', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('493', 'Dinapur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('494', 'Dinapur Cantonment', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('495', 'Dumra', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('496', 'Dumraon', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('497', 'Fatwa', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('498', 'Forbesganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('499', 'Gaya', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('500', 'Gazipur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('501', 'Ghoghardiha', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('502', 'Gogri Jamalpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('503', 'Gopalganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('504', 'Habibpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('505', 'Hajipur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('506', 'Hasanpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('507', 'Hazaribagh', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('508', 'Hilsa', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('509', 'Hisua', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('510', 'Islampur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('511', 'Jagdispur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('512', 'Jahanabad', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('513', 'Jamalpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('514', 'Jamhaur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('515', 'Jamui', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('516', 'Janakpur Road', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('517', 'Janpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('518', 'Jaynagar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('519', 'Jha Jha', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('520', 'Jhanjharpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('521', 'Jogbani', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('522', 'Kanti', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('523', 'Kasba', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('524', 'Kataiya', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('525', 'Katihar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('526', 'Khagaria', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('527', 'Khagaul', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('528', 'Kharagpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('529', 'Khusrupur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('530', 'Kishanganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('531', 'Koath', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('532', 'Koilwar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('533', 'Lakhisarai', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('534', 'Lalganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('535', 'Lauthaha', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('536', 'Madhepura', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('537', 'Madhubani', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('538', 'Maharajganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('539', 'Mahnar Bazar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('540', 'Mairwa', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('541', 'Makhdumpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('542', 'Maner', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('543', 'Manihari', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('544', 'Marhaura', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('545', 'Masaurhi', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('546', 'Mirganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('547', 'Mohiuddinagar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('548', 'Mokama', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('549', 'Motihari', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('550', 'Motipur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('551', 'Munger', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('552', 'Murliganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('553', 'Muzaffarpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('554', 'Nabinagar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('555', 'Narkatiaganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('556', 'Nasriganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('557', 'Natwar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('558', 'Naugachhia', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('559', 'Nawada', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('560', 'Nirmali', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('561', 'Nokha', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('562', 'Paharpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('563', 'Patna', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('564', 'Phulwari', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('565', 'Piro', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('566', 'Purnia', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('567', 'Pusa', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('568', 'Rafiganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('569', 'Raghunathpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('570', 'Rajgir', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('571', 'Ramnagar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('572', 'Raxaul', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('573', 'Revelganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('574', 'Rusera', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('575', 'Sagauli', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('576', 'Saharsa', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('577', 'Samastipur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('578', 'Sasaram', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('579', 'Shahpur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('580', 'Shaikhpura', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('581', 'Sherghati', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('582', 'Shivhar', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('583', 'Silao', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('584', 'Sitamarhi', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('585', 'Siwan', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('586', 'Sonepur', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('587', 'Sultanganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('588', 'Supaul', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('589', 'Teghra', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('590', 'Tekari', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('591', 'Thakurganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('592', 'Vaishali', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('593', 'Waris Aliganj', '5');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('594', 'Chandigarh', '6');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('595', 'Ahiwara', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('596', 'Akaltara', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('597', 'Ambagarh Chauki', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('598', 'Ambikapur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('599', 'Arang', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('600', 'Bade Bacheli', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('601', 'Bagbahara', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('602', 'Baikunthpur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('603', 'Balod', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('604', 'Baloda', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('605', 'Baloda Bazar', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('606', 'Banarsi', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('607', 'Basna', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('608', 'Bemetra', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('609', 'Bhanpuri', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('610', 'Bhatapara', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('611', 'Bhatgaon', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('612', 'Bhilai', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('613', 'Bilaspur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('614', 'Bilha', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('615', 'Birgaon', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('616', 'Bodri', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('617', 'Champa', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('618', 'Charcha', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('619', 'Charoda', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('620', 'Chhuikhadan', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('621', 'Chirmiri', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('622', 'Dantewada', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('623', 'Deori', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('624', 'Dhamdha', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('625', 'Dhamtari', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('626', 'Dharamjaigarh', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('627', 'Dipka', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('628', 'Doman Hill Colliery', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('629', 'Dongargaon', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('630', 'Dongragarh', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('631', 'Durg', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('632', 'Frezarpur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('633', 'Gandai', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('634', 'Gariaband', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('635', 'Gaurela', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('636', 'Gelhapani', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('637', 'Gharghoda', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('638', 'Gidam', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('639', 'Gobra Nawapara', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('640', 'Gogaon', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('641', 'Hatkachora', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('642', 'Jagdalpur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('643', 'Jamui', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('644', 'Jashpurnagar', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('645', 'Jhagrakhand', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('646', 'Kanker', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('647', 'Katghora', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('648', 'Kawardha', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('649', 'Khairagarh', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('650', 'Khamhria', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('651', 'Kharod', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('652', 'Kharsia', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('653', 'Khonga Pani', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('654', 'Kirandu', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('655', 'Kirandul', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('656', 'Kohka', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('657', 'Kondagaon', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('658', 'Korba', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('659', 'Korea', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('660', 'Koria Block', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('661', 'Kota', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('662', 'Kumhari', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('663', 'Kumud Katta', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('664', 'Kurasia', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('665', 'Kurud', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('666', 'Lingiyadih', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('667', 'Lormi', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('668', 'Mahasamund', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('669', 'Mahendragarh', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('670', 'Mehmand', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('671', 'Mongra', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('672', 'Mowa', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('673', 'Mungeli', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('674', 'Nailajanjgir', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('675', 'Namna Kalan', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('676', 'Naya Baradwar', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('677', 'Pandariya', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('678', 'Patan', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('679', 'Pathalgaon', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('680', 'Pendra', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('681', 'Phunderdihari', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('682', 'Pithora', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('683', 'Raigarh', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('684', 'Raipur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('685', 'Rajgamar', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('686', 'Rajhara', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('687', 'Rajnandgaon', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('688', 'Ramanuj Ganj', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('689', 'Ratanpur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('690', 'Sakti', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('691', 'Saraipali', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('692', 'Sarajpur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('693', 'Sarangarh', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('694', 'Shivrinarayan', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('695', 'Simga', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('696', 'Sirgiti', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('697', 'Takhatpur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('698', 'Telgaon', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('699', 'Tildanewra', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('700', 'Urla', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('701', 'Vishrampur', '7');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('702', 'Amli', '8');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('703', 'Silvassa', '8');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('704', 'Daman', '9');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('705', 'Diu', '9');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('706', 'Delhi', '10');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('707', 'New Delhi', '10');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('708', 'Aldona', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('709', 'Altinho', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('710', 'Aquem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('711', 'Arpora', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('712', 'Bambolim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('713', 'Bandora', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('714', 'Bardez', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('715', 'Benaulim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('716', 'Betora', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('717', 'Bicholim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('718', 'Calapor', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('719', 'Candolim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('720', 'Caranzalem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('721', 'Carapur', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('722', 'Chicalim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('723', 'Chimbel', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('724', 'Chinchinim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('725', 'Colvale', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('726', 'Corlim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('727', 'Cortalim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('728', 'Cuncolim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('729', 'Curchorem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('730', 'Curti', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('731', 'Davorlim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('732', 'Dona Paula', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('733', 'Goa', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('734', 'Guirim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('735', 'Jua', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('736', 'Kalangat', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('737', 'Kankon', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('738', 'Kundaim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('739', 'Loutulim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('740', 'Madgaon', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('741', 'Mapusa', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('742', 'Margao', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('743', 'Margaon', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('744', 'Miramar', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('745', 'Morjim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('746', 'Mormugao', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('747', 'Navelim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('748', 'Pale', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('749', 'Panaji', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('750', 'Parcem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('751', 'Parra', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('752', 'Penha de Franca', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('753', 'Pernem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('754', 'Pilerne', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('755', 'Pissurlem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('756', 'Ponda', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('757', 'Porvorim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('758', 'Quepem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('759', 'Queula', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('760', 'Raia', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('761', 'Reis Magos', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('762', 'Salcette', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('763', 'Saligao', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('764', 'Sancoale', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('765', 'Sanguem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('766', 'Sanquelim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('767', 'Sanvordem', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('768', 'Sao Jose-de-Areal', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('769', 'Sattari', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('770', 'Serula', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('771', 'Sinquerim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('772', 'Siolim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('773', 'Taleigao', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('774', 'Tivim', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('775', 'Valpoi', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('776', 'Varca', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('777', 'Vasco', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('778', 'Verna', '11');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('779', 'Abrama', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('780', 'Adalaj', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('781', 'Adityana', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('782', 'Advana', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('783', 'Ahmedabad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('784', 'Ahwa', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('785', 'Alang', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('786', 'Ambaji', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('787', 'Ambaliyasan', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('788', 'Amod', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('789', 'Amreli', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('790', 'Amroli', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('791', 'Anand', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('792', 'Andada', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('793', 'Anjar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('794', 'Anklav', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('795', 'Ankleshwar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('796', 'Anklesvar INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('797', 'Antaliya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('798', 'Arambhada', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('799', 'Asarma', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('800', 'Atul', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('801', 'Babra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('802', 'Bag-e-Firdosh', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('803', 'Bagasara', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('804', 'Bahadarpar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('805', 'Bajipura', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('806', 'Bajva', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('807', 'Balasinor', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('808', 'Banaskantha', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('809', 'Bansda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('810', 'Bantva', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('811', 'Bardoli', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('812', 'Barwala', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('813', 'Bayad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('814', 'Bechar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('815', 'Bedi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('816', 'Beyt', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('817', 'Bhachau', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('818', 'Bhanvad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('819', 'Bharuch', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('820', 'Bharuch INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('821', 'Bhavnagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('822', 'Bhayavadar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('823', 'Bhestan', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('824', 'Bhuj', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('825', 'Bilimora', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('826', 'Bilkha', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('827', 'Billimora', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('828', 'Bodakdev', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('829', 'Bodeli', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('830', 'Bopal', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('831', 'Boria', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('832', 'Boriavi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('833', 'Borsad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('834', 'Botad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('835', 'Cambay', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('836', 'Chaklasi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('837', 'Chala', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('838', 'Chalala', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('839', 'Chalthan', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('840', 'Chanasma', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('841', 'Chandisar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('842', 'Chandkheda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('843', 'Chanod', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('844', 'Chaya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('845', 'Chenpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('846', 'Chhapi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('847', 'Chhaprabhatha', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('848', 'Chhatral', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('849', 'Chhota Udepur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('850', 'Chikhli', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('851', 'Chiloda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('852', 'Chorvad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('853', 'Chotila', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('854', 'Dabhoi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('855', 'Dadara', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('856', 'Dahod', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('857', 'Dakor', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('858', 'Damnagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('859', 'Deesa', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('860', 'Delvada', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('861', 'Devgadh Baria', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('862', 'Devsar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('863', 'Dhandhuka', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('864', 'Dhanera', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('865', 'Dhangdhra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('866', 'Dhansura', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('867', 'Dharampur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('868', 'Dhari', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('869', 'Dhola', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('870', 'Dholka', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('871', 'Dholka Rural', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('872', 'Dhoraji', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('873', 'Dhrangadhra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('874', 'Dhrol', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('875', 'Dhuva', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('876', 'Dhuwaran', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('877', 'Digvijaygram', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('878', 'Disa', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('879', 'Dungar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('880', 'Dungarpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('881', 'Dungra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('882', 'Dwarka', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('883', 'Flelanganj', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('884', 'GSFC Complex', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('885', 'Gadhda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('886', 'Gandevi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('887', 'Gandhidham', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('888', 'Gandhinagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('889', 'Gariadhar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('890', 'Ghogha', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('891', 'Godhra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('892', 'Gondal', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('893', 'Hajira INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('894', 'Halol', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('895', 'Halvad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('896', 'Hansot', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('897', 'Harij', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('898', 'Himatnagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('899', 'Ichchhapor', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('900', 'Idar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('901', 'Jafrabad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('902', 'Jalalpore', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('903', 'Jambusar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('904', 'Jamjodhpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('905', 'Jamnagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('906', 'Jasdan', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('907', 'Jawaharnagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('908', 'Jetalsar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('909', 'Jetpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('910', 'Jodiya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('911', 'Joshipura', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('912', 'Junagadh', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('913', 'Kadi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('914', 'Kadodara', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('915', 'Kalavad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('916', 'Kali', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('917', 'Kaliawadi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('918', 'Kalol', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('919', 'Kalol INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('920', 'Kandla', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('921', 'Kanjari', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('922', 'Kanodar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('923', 'Kapadwanj', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('924', 'Karachiya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('925', 'Karamsad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('926', 'Karjan', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('927', 'Kathial', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('928', 'Kathor', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('929', 'Katpar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('930', 'Kavant', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('931', 'Keshod', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('932', 'Kevadiya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('933', 'Khambhaliya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('934', 'Khambhat', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('935', 'Kharaghoda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('936', 'Khed Brahma', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('937', 'Kheda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('938', 'Kheralu', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('939', 'Kodinar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('940', 'Kosamba', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('941', 'Kundla', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('942', 'Kutch', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('943', 'Kutiyana', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('944', 'Lakhtar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('945', 'Lalpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('946', 'Lambha', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('947', 'Lathi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('948', 'Limbdi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('949', 'Limla', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('950', 'Lunavada', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('951', 'Madhapar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('952', 'Maflipur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('953', 'Mahemdavad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('954', 'Mahudha', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('955', 'Mahuva', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('956', 'Mahuvar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('957', 'Makarba', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('958', 'Makarpura', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('959', 'Makassar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('960', 'Maktampur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('961', 'Malia', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('962', 'Malpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('963', 'Manavadar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('964', 'Mandal', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('965', 'Mandvi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('966', 'Mangrol', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('967', 'Mansa', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('968', 'Meghraj', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('969', 'Mehsana', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('970', 'Mendarla', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('971', 'Mithapur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('972', 'Modasa', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('973', 'Mogravadi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('974', 'Morbi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('975', 'Morvi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('976', 'Mundra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('977', 'Nadiad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('978', 'Naliya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('979', 'Nanakvada', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('980', 'Nandej', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('981', 'Nandesari', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('982', 'Nandesari INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('983', 'Naroda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('984', 'Navagadh', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('985', 'Navagam Ghed', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('986', 'Navsari', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('987', 'Ode', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('988', 'Okaf', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('989', 'Okha', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('990', 'Olpad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('991', 'Paddhari', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('992', 'Padra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('993', 'Palanpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('994', 'Palej', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('995', 'Pali', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('996', 'Palitana', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('997', 'Paliyad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('998', 'Pandesara', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('999', 'Panoli', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1000', 'Pardi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1001', 'Parnera', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1002', 'Parvat', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1003', 'Patan', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1004', 'Patdi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1005', 'Petlad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1006', 'Petrochemical Complex', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1007', 'Porbandar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1008', 'Prantij', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1009', 'Radhanpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1010', 'Raiya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1011', 'Rajkot', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1012', 'Rajpipla', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1013', 'Rajula', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1014', 'Ramod', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1015', 'Ranavav', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1016', 'Ranoli', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1017', 'Rapar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1018', 'Sahij', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1019', 'Salaya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1020', 'Sanand', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1021', 'Sankheda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1022', 'Santrampur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1023', 'Saribujrang', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1024', 'Sarigam INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1025', 'Sayan', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1026', 'Sayla', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1027', 'Shahpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1028', 'Shahwadi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1029', 'Shapar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1030', 'Shivrajpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1031', 'Siddhapur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1032', 'Sidhpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1033', 'Sihor', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1034', 'Sika', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1035', 'Singarva', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1036', 'Sinor', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1037', 'Sojitra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1038', 'Sola', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1039', 'Songadh', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1040', 'Suraj Karadi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1041', 'Surat', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1042', 'Surendranagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1043', 'Talaja', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1044', 'Talala', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1045', 'Talod', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1046', 'Tankara', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1047', 'Tarsali', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1048', 'Thangadh', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1049', 'Tharad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1050', 'Thasra', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1051', 'Udyognagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1052', 'Ukai', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1053', 'Umbergaon', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1054', 'Umbergaon INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1055', 'Umrala', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1056', 'Umreth', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1057', 'Un', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1058', 'Una', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1059', 'Unjha', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1060', 'Upleta', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1061', 'Utran', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1062', 'Uttarsanda', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1063', 'V.U. Nagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1064', 'V.V. Nagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1065', 'Vadia', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1066', 'Vadla', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1067', 'Vadnagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1068', 'Vadodara', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1069', 'Vaghodia INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1070', 'Valbhipur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1071', 'Vallabh Vidyanagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1072', 'Valsad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1073', 'Valsad INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1074', 'Vanthali', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1075', 'Vapi', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1076', 'Vapi INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1077', 'Vartej', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1078', 'Vasad', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1079', 'Vasna Borsad INA', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1080', 'Vaso', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1081', 'Veraval', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1082', 'Vidyanagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1083', 'Vijalpor', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1084', 'Vijapur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1085', 'Vinchhiya', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1086', 'Vinzol', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1087', 'Virpur', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1088', 'Visavadar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1089', 'Visnagar', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1090', 'Vyara', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1091', 'Wadhwan', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1092', 'Waghai', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1093', 'Waghodia', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1094', 'Wankaner', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1095', 'Zalod', '12');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1096', 'Ambala', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1097', 'Ambala Cantt', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1098', 'Asan Khurd', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1099', 'Asandh', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1100', 'Ateli', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1101', 'Babiyal', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1102', 'Bahadurgarh', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1103', 'Ballabgarh', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1104', 'Barwala', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1105', 'Bawal', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1106', 'Bawani Khera', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1107', 'Beri', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1108', 'Bhiwani', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1109', 'Bilaspur', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1110', 'Buria', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1111', 'Charkhi Dadri', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1112', 'Chhachhrauli', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1113', 'Chita', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1114', 'Dabwali', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1115', 'Dharuhera', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1116', 'Dundahera', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1117', 'Ellenabad', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1118', 'Farakhpur', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1119', 'Faridabad', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1120', 'Farrukhnagar', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1121', 'Fatehabad', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1122', 'Firozpur Jhirka', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1123', 'Gannaur', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1124', 'Ghraunda', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1125', 'Gohana', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1126', 'Gurgaon', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1127', 'Haileymandi', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1128', 'Hansi', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1129', 'Hasanpur', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1130', 'Hathin', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1131', 'Hisar', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1132', 'Hissar', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1133', 'Hodal', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1134', 'Indri', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1135', 'Jagadhri', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1136', 'Jakhal Mandi', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1137', 'Jhajjar', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1138', 'Jind', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1139', 'Julana', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1140', 'Kaithal', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1141', 'Kalanur', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1142', 'Kalanwali', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1143', 'Kalayat', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1144', 'Kalka', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1145', 'Kanina', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1146', 'Kansepur', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1147', 'Kardhan', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1148', 'Karnal', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1149', 'Kharkhoda', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1150', 'Kheri Sampla', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1151', 'Kundli', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1152', 'Kurukshetra', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1153', 'Ladrawan', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1154', 'Ladwa', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1155', 'Loharu', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1156', 'Maham', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1157', 'Mahendragarh', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1158', 'Mustafabad', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1159', 'Nagai Chaudhry', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1160', 'Narayangarh', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1161', 'Narnaul', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1162', 'Narnaund', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1163', 'Narwana', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1164', 'Nilokheri', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1165', 'Nuh', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1166', 'Palwal', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1167', 'Panchkula', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1168', 'Panipat', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1169', 'Panipat Taraf Ansar', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1170', 'Panipat Taraf Makhdum Zadgan', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1171', 'Panipat Taraf Rajputan', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1172', 'Pehowa', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1173', 'Pinjaur', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1174', 'Punahana', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1175', 'Pundri', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1176', 'Radaur', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1177', 'Raipur Rani', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1178', 'Rania', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1179', 'Ratiya', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1180', 'Rewari', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1181', 'Rohtak', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1182', 'Ropar', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1183', 'Sadauri', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1184', 'Safidon', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1185', 'Samalkha', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1186', 'Sankhol', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1187', 'Sasauli', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1188', 'Shahabad', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1189', 'Sirsa', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1190', 'Siwani', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1191', 'Sohna', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1192', 'Sonipat', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1193', 'Sukhrali', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1194', 'Taoru', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1195', 'Taraori', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1196', 'Tauru', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1197', 'Thanesar', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1198', 'Tilpat', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1199', 'Tohana', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1200', 'Tosham', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1201', 'Uchana', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1202', 'Uklana Mandi', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1203', 'Uncha Siwana', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1204', 'Yamunanagar', '13');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1205', 'Arki', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1206', 'Baddi', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1207', 'Bakloh', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1208', 'Banjar', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1209', 'Bhota', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1210', 'Bhuntar', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1211', 'Bilaspur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1212', 'Chamba', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1213', 'Chaupal', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1214', 'Chuari Khas', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1215', 'Dagshai', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1216', 'Dalhousie', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1217', 'Dalhousie Cantonment', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1218', 'Damtal', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1219', 'Daulatpur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1220', 'Dera Gopipur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1221', 'Dhalli', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1222', 'Dharamshala', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1223', 'Gagret', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1224', 'Ghamarwin', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1225', 'Hamirpur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1226', 'Jawala Mukhi', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1227', 'Jogindarnagar', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1228', 'Jubbal', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1229', 'Jutogh', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1230', 'Kala Amb', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1231', 'Kalpa', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1232', 'Kangra', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1233', 'Kasauli', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1234', 'Kot Khai', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1235', 'Kullu', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1236', 'Kulu', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1237', 'Manali', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1238', 'Mandi', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1239', 'Mant Khas', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1240', 'Mehatpur Basdehra', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1241', 'Nadaun', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1242', 'Nagrota', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1243', 'Nahan', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1244', 'Naina Devi', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1245', 'Nalagarh', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1246', 'Narkanda', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1247', 'Nurpur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1248', 'Palampur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1249', 'Pandoh', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1250', 'Paonta Sahib', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1251', 'Parwanoo', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1252', 'Parwanu', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1253', 'Rajgarh', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1254', 'Rampur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1255', 'Rawalsar', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1256', 'Rohru', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1257', 'Sabathu', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1258', 'Santokhgarh', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1259', 'Sarahan', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1260', 'Sarka Ghat', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1261', 'Seoni', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1262', 'Shimla', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1263', 'Sirmaur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1264', 'Solan', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1265', 'Solon', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1266', 'Sundarnagar', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1267', 'Sundernagar', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1268', 'Talai', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1269', 'Theog', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1270', 'Tira Sujanpur', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1271', 'Una', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1272', 'Yol', '14');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1273', 'Achabal', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1274', 'Akhnur', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1275', 'Anantnag', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1276', 'Arnia', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1277', 'Awantipora', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1278', 'Badami Bagh', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1279', 'Bandipur', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1280', 'Banihal', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1281', 'Baramula', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1282', 'Baramulla', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1283', 'Bari Brahmana', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1284', 'Bashohli', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1285', 'Batote', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1286', 'Bhaderwah', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1287', 'Bijbiara', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1288', 'Billawar', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1289', 'Birwah', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1290', 'Bishna', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1291', 'Budgam', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1292', 'Charari Sharief', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1293', 'Chenani', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1294', 'Doda', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1295', 'Duru-Verinag', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1296', 'Gandarbat', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1297', 'Gho Manhasan', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1298', 'Gorah Salathian', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1299', 'Gulmarg', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1300', 'Hajan', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1301', 'Handwara', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1302', 'Hiranagar', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1303', 'Jammu', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1304', 'Jammu Cantonment', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1305', 'Jammu Tawi', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1306', 'Jourian', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1307', 'Kargil', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1308', 'Kathua', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1309', 'Katra', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1310', 'Khan Sahib', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1311', 'Khour', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1312', 'Khrew', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1313', 'Kishtwar', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1314', 'Kud', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1315', 'Kukernag', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1316', 'Kulgam', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1317', 'Kunzer', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1318', 'Kupwara', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1319', 'Lakhenpur', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1320', 'Leh', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1321', 'Magam', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1322', 'Mattan', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1323', 'Naushehra', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1324', 'Pahalgam', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1325', 'Pampore', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1326', 'Parole', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1327', 'Pattan', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1328', 'Pulwama', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1329', 'Punch', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1330', 'Qazigund', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1331', 'Rajauri', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1332', 'Ramban', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1333', 'Ramgarh', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1334', 'Ramnagar', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1335', 'Ranbirsingh Pora', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1336', 'Reasi', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1337', 'Rehambal', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1338', 'Samba', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1339', 'Shupiyan', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1340', 'Sopur', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1341', 'Srinagar', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1342', 'Sumbal', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1343', 'Sunderbani', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1344', 'Talwara', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1345', 'Thanamandi', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1346', 'Tral', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1347', 'Udhampur', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1348', 'Uri', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1349', 'Vijaypur', '15');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1350', 'Adityapur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1351', 'Amlabad', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1352', 'Angarpathar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1353', 'Ara', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1354', 'Babua Kalan', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1355', 'Bagbahra', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1356', 'Baliapur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1357', 'Baliari', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1358', 'Balkundra', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1359', 'Bandhgora', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1360', 'Barajamda', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1361', 'Barhi', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1362', 'Barka Kana', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1363', 'Barki Saraiya', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1364', 'Barughutu', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1365', 'Barwadih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1366', 'Basaria', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1367', 'Basukinath', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1368', 'Bermo', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1369', 'Bhagatdih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1370', 'Bhaurah', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1371', 'Bhojudih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1372', 'Bhuli', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1373', 'Bokaro', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1374', 'Borio Bazar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1375', 'Bundu', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1376', 'Chaibasa', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1377', 'Chaitudih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1378', 'Chakradharpur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1379', 'Chakulia', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1380', 'Chandaur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1381', 'Chandil', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1382', 'Chandrapura', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1383', 'Chas', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1384', 'Chatra', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1385', 'Chhatatanr', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1386', 'Chhotaputki', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1387', 'Chiria', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1388', 'Chirkunda', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1389', 'Churi', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1390', 'Daltenganj', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1391', 'Danguwapasi', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1392', 'Dari', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1393', 'Deoghar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1394', 'Deorikalan', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1395', 'Devghar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1396', 'Dhanbad', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1397', 'Dhanwar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1398', 'Dhaunsar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1399', 'Dugda', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1400', 'Dumarkunda', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1401', 'Dumka', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1402', 'Egarkunr', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1403', 'Gadhra', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1404', 'Garwa', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1405', 'Ghatsila', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1406', 'Ghorabandha', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1407', 'Gidi', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1408', 'Giridih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1409', 'Gobindpur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1410', 'Godda', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1411', 'Godhar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1412', 'Golphalbari', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1413', 'Gomoh', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1414', 'Gua', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1415', 'Gumia', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1416', 'Gumla', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1417', 'Haludbani', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1418', 'Hazaribag', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1419', 'Hesla', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1420', 'Husainabad', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1421', 'Isri', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1422', 'Jadugora', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1423', 'Jagannathpur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1424', 'Jamadoba', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1425', 'Jamshedpur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1426', 'Jamtara', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1427', 'Jarangdih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1428', 'Jaridih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1429', 'Jasidih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1430', 'Jena', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1431', 'Jharia', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1432', 'Jharia Khas', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1433', 'Jhinkpani', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1434', 'Jhumri Tilaiya', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1435', 'Jorapokhar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1436', 'Jugsalai', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1437', 'Kailudih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1438', 'Kalikapur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1439', 'Kandra', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1440', 'Kanke', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1441', 'Katras', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1442', 'Kedla', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1443', 'Kenduadih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1444', 'Kharkhari', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1445', 'Kharsawan', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1446', 'Khelari', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1447', 'Khunti', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1448', 'Kiri Buru', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1449', 'Kiriburu', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1450', 'Kodarma', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1451', 'Kuju', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1452', 'Kurpania', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1453', 'Kustai', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1454', 'Lakarka', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1455', 'Lapanga', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1456', 'Latehar', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1457', 'Lohardaga', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1458', 'Loiya', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1459', 'Loyabad', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1460', 'Madhupur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1461', 'Mahesh Mundi', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1462', 'Maithon', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1463', 'Malkera', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1464', 'Mango', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1465', 'Manoharpur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1466', 'Marma', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1467', 'Meghahatuburu Forest village', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1468', 'Mera', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1469', 'Meru', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1470', 'Mihijam', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1471', 'Mugma', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1472', 'Muri', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1473', 'Mushabani', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1474', 'Nagri Kalan', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1475', 'Netarhat', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1476', 'Nirsa', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1477', 'Noamundi', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1478', 'Okni', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1479', 'Orla', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1480', 'Pakaur', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1481', 'Palamau', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1482', 'Palawa', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1483', 'Panchet', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1484', 'Panrra', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1485', 'Paratdih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1486', 'Pathardih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1487', 'Patratu', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1488', 'Phusro', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1489', 'Pondar Kanali', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1490', 'Rajmahal', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1491', 'Ramgarh', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1492', 'Ranchi', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1493', 'Ray', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1494', 'Rehla', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1495', 'Religara', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1496', 'Rohraband', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1497', 'Sahibganj', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1498', 'Sahnidih', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1499', 'Saraidhela', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1500', 'Saraikela', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1501', 'Sarjamda', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1502', 'Saunda', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1503', 'Sewai', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1504', 'Sijhua', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1505', 'Sijua', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1506', 'Simdega', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1507', 'Sindari', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1508', 'Sinduria', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1509', 'Sini', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1510', 'Sirka', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1511', 'Siuliban', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1512', 'Surubera', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1513', 'Tati', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1514', 'Tenudam', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1515', 'Tisra', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1516', 'Topa', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1517', 'Topchanchi', '16');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1518', 'Adityanagar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1519', 'Adityapatna', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1520', 'Afzalpur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1521', 'Ajjampur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1522', 'Aland', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1523', 'Almatti Sitimani', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1524', 'Alnavar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1525', 'Alur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1526', 'Ambikanagara', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1527', 'Anekal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1528', 'Ankola', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1529', 'Annigeri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1530', 'Arkalgud', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1531', 'Arsikere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1532', 'Athni', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1533', 'Aurad', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1534', 'Badagavettu', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1535', 'Badami', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1536', 'Bagalkot', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1537', 'Bagepalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1538', 'Bailhongal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1539', 'Baindur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1540', 'Bajala', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1541', 'Bajpe', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1542', 'Banavar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1543', 'Bangarapet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1544', 'Bankapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1545', 'Bannur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1546', 'Bantwal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1547', 'Basavakalyan', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1548', 'Basavana Bagevadi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1549', 'Belagula', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1550', 'Belakavadiq', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1551', 'Belgaum', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1552', 'Belgaum Cantonment', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1553', 'Bellary', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1554', 'Belluru', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1555', 'Beltangadi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1556', 'Belur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1557', 'Belvata', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1558', 'Bengaluru', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1559', 'Bhadravati', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1560', 'Bhalki', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1561', 'Bhatkal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1562', 'Bhimarayanagudi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1563', 'Bhogadi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1564', 'Bidar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1565', 'Bijapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1566', 'Bilgi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1567', 'Birur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1568', 'Bommanahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1569', 'Bommasandra', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1570', 'Byadgi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1571', 'Byatarayanapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1572', 'Chakranagar Colony', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1573', 'Challakere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1574', 'Chamrajnagar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1575', 'Chamundi Betta', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1576', 'Channagiri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1577', 'Channapatna', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1578', 'Channarayapatna', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1579', 'Chickballapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1580', 'Chik Ballapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1581', 'Chikkaballapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1582', 'Chikmagalur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1583', 'Chiknayakanhalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1584', 'Chikodi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1585', 'Chincholi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1586', 'Chintamani', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1587', 'Chitaguppa', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1588', 'Chitapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1589', 'Chitradurga', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1590', 'Coorg', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1591', 'Dandeli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1592', 'Dargajogihalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1593', 'Dasarahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1594', 'Davangere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1595', 'Devadurga', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1596', 'Devagiri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1597', 'Devanhalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1598', 'Dharwar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1599', 'Dhupdal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1600', 'Dod Ballapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1601', 'Donimalai', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1602', 'Gadag', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1603', 'Gajendragarh', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1604', 'Ganeshgudi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1605', 'Gangawati', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1606', 'Gangoli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1607', 'Gauribidanur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1608', 'Gokak', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1609', 'Gokak Falls', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1610', 'Gonikoppal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1611', 'Gorur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1612', 'Gottikere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1613', 'Gubbi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1614', 'Gudibanda', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1615', 'Gulbarga', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1616', 'Guledgudda', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1617', 'Gundlupet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1618', 'Gurmatkal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1619', 'Haliyal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1620', 'Hangal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1621', 'Harihar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1622', 'Harpanahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1623', 'Hassan', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1624', 'Hatti', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1625', 'Hatti Gold Mines', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1626', 'Haveri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1627', 'Hebbagodi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1628', 'Hebbalu', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1629', 'Hebri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1630', 'Heggadadevanakote', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1631', 'Herohalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1632', 'Hidkal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1633', 'Hindalgi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1634', 'Hirekerur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1635', 'Hiriyur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1636', 'Holalkere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1637', 'Hole Narsipur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1638', 'Homnabad', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1639', 'Honavar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1640', 'Honnali', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1641', 'Hosakote', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1642', 'Hosanagara', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1643', 'Hosangadi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1644', 'Hosdurga', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1645', 'Hoskote', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1646', 'Hospet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1647', 'Hubli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1648', 'Hukeri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1649', 'Hunasagi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1650', 'Hunasamaranahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1651', 'Hungund', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1652', 'Hunsur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1653', 'Huvina Hadagalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1654', 'Ilkal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1655', 'Indi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1656', 'Jagalur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1657', 'Jamkhandi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1658', 'Jevargi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1659', 'Jog Falls', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1660', 'Kabini Colony', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1661', 'Kadur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1662', 'Kalghatgi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1663', 'Kamalapuram', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1664', 'Kampli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1665', 'Kanakapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1666', 'Kangrali BK', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1667', 'Kangrali KH', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1668', 'Kannur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1669', 'Karkala', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1670', 'Karwar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1671', 'Kemminja', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1672', 'Kengeri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1673', 'Kerur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1674', 'Khanapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1675', 'Kodigenahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1676', 'Kodiyal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1677', 'Kodlipet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1678', 'Kolar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1679', 'Kollegal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1680', 'Konanakunte', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1681', 'Konanur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1682', 'Konnur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1683', 'Koppa', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1684', 'Koppal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1685', 'Koratagere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1686', 'Kotekara', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1687', 'Kothnur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1688', 'Kotturu', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1689', 'Krishnapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1690', 'Krishnarajanagar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1691', 'Krishnarajapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1692', 'Krishnarajasagara', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1693', 'Krishnarajpet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1694', 'Kudchi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1695', 'Kudligi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1696', 'Kudremukh', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1697', 'Kumsi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1698', 'Kumta', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1699', 'Kundapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1700', 'Kundgol', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1701', 'Kunigal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1702', 'Kurgunta', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1703', 'Kushalnagar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1704', 'Kushtagi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1705', 'Kyathanahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1706', 'Lakshmeshwar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1707', 'Lingsugur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1708', 'Londa', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1709', 'Maddur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1710', 'Madhugiri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1711', 'Madikeri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1712', 'Magadi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1713', 'Magod Falls', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1714', 'Mahadeswara Hills', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1715', 'Mahadevapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1716', 'Mahalingpur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1717', 'Maisuru', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1718', 'Maisuru Cantonment', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1719', 'Malavalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1720', 'Mallar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1721', 'Malpe', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1722', 'Malur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1723', 'Manchenahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1724', 'Mandya', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1725', 'Mangalore', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1726', 'Mangaluru', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1727', 'Manipal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1728', 'Manvi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1729', 'Maski', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1730', 'Mastikatte Colony', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1731', 'Mayakonda', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1732', 'Melukote', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1733', 'Molakalmuru', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1734', 'Mudalgi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1735', 'Mudbidri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1736', 'Muddebihal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1737', 'Mudgal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1738', 'Mudhol', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1739', 'Mudigere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1740', 'Mudushedde', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1741', 'Mulbagal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1742', 'Mulgund', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1743', 'Mulki', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1744', 'Mulur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1745', 'Mundargi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1746', 'Mundgod', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1747', 'Munirabad', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1748', 'Munnur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1749', 'Murudeshwara', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1750', 'Mysore', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1751', 'Nagamangala', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1752', 'Nanjangud', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1753', 'Naragund', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1754', 'Narasimharajapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1755', 'Naravi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1756', 'Narayanpur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1757', 'Naregal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1758', 'Navalgund', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1759', 'Nelmangala', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1760', 'Nipani', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1761', 'Nitte', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1762', 'Nyamati', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1763', 'Padu', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1764', 'Pandavapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1765', 'Pattanagere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1766', 'Pavagada', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1767', 'Piriyapatna', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1768', 'Ponnampet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1769', 'Puttur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1770', 'Rabkavi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1771', 'Raichur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1772', 'Ramanagaram', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1773', 'Ramdurg', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1774', 'Ranibennur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1775', 'Raybag', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1776', 'Robertsonpet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1777', 'Ron', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1778', 'Sadalgi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1779', 'Sagar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1780', 'Sakleshpur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1781', 'Saligram', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1782', 'Sandur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1783', 'Sanivarsante', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1784', 'Sankeshwar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1785', 'Sargur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1786', 'Sathyamangala', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1787', 'Saundatti Yellamma', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1788', 'Savanur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1789', 'Sedam', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1790', 'Shahabad', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1791', 'Shahabad A.C.C.', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1792', 'Shahapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1793', 'Shahpur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1794', 'Shaktinagar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1795', 'Shiggaon', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1796', 'Shikarpur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1797', 'Shimoga', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1798', 'Shirhatti', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1799', 'Shorapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1800', 'Shravanabelagola', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1801', 'Shrirangapattana', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1802', 'Siddapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1803', 'Sidlaghatta', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1804', 'Sindgi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1805', 'Sindhnur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1806', 'Sira', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1807', 'Sirakoppa', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1808', 'Sirsi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1809', 'Siruguppa', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1810', 'Someshwar', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1811', 'Somvarpet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1812', 'Sorab', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1813', 'Sringeri', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1814', 'Srinivaspur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1815', 'Sulya', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1816', 'Suntikopa', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1817', 'Talikota', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1818', 'Tarikera', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1819', 'Tekkalakota', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1820', 'Terdal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1821', 'Thokur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1822', 'Thumbe', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1823', 'Tiptur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1824', 'Tirthahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1825', 'Tirumakudal Narsipur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1826', 'Tonse', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1827', 'Tumkur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1828', 'Turuvekere', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1829', 'Udupi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1830', 'Ullal', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1831', 'Uttarahalli', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1832', 'Venkatapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1833', 'Vijayapura', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1834', 'Virarajendrapet', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1835', 'Wadi', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1836', 'Wadi A.C.C.', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1837', 'Yadgir', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1838', 'Yelahanka', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1839', 'Yelandur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1840', 'Yelbarga', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1841', 'Yellapur', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1842', 'Yenagudde', '17');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1843', 'Adimaly', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1844', 'Adoor', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1845', 'Adur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1846', 'Akathiyur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1847', 'Alangad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1848', 'Alappuzha', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1849', 'Aluva', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1850', 'Ancharakandy', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1851', 'Angamaly', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1852', 'Aroor', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1853', 'Arukutti', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1854', 'Attingal', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1855', 'Avinissery', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1856', 'Azhikode North', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1857', 'Azhikode South', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1858', 'Azhiyur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1859', 'Balussery', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1860', 'Bangramanjeshwar', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1861', 'Beypur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1862', 'Brahmakulam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1863', 'Chala', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1864', 'Chalakudi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1865', 'Changanacheri', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1866', 'Chauwara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1867', 'Chavakkad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1868', 'Chelakkara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1869', 'Chelora', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1870', 'Chendamangalam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1871', 'Chengamanad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1872', 'Chengannur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1873', 'Cheranallur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1874', 'Cheriyakadavu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1875', 'Cherthala', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1876', 'Cherukunnu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1877', 'Cheruthazham', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1878', 'Cheruvannur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1879', 'Cheruvattur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1880', 'Chevvur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1881', 'Chirakkal', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1882', 'Chittur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1883', 'Chockli', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1884', 'Churnikkara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1885', 'Dharmadam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1886', 'Edappal', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1887', 'Edathala', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1888', 'Elayavur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1889', 'Elur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1890', 'Eranholi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1891', 'Erattupetta', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1892', 'Ernakulam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1893', 'Eruvatti', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1894', 'Ettumanoor', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1895', 'Feroke', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1896', 'Guruvayur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1897', 'Haripad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1898', 'Hosabettu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1899', 'Idukki', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1900', 'Iringaprom', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1901', 'Irinjalakuda', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1902', 'Iriveri', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1903', 'Kadachira', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1904', 'Kadalundi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1905', 'Kadamakkudy', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1906', 'Kadirur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1907', 'Kadungallur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1908', 'Kakkodi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1909', 'Kalady', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1910', 'Kalamassery', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1911', 'Kalliasseri', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1912', 'Kalpetta', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1913', 'Kanhangad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1914', 'Kanhirode', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1915', 'Kanjikkuzhi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1916', 'Kanjikode', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1917', 'Kanjirappalli', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1918', 'Kannadiparamba', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1919', 'Kannangad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1920', 'Kannapuram', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1921', 'Kannur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1922', 'Kannur Cantonment', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1923', 'Karunagappally', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1924', 'Karuvamyhuruthy', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1925', 'Kasaragod', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1926', 'Kasargod', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1927', 'Kattappana', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1928', 'Kayamkulam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1929', 'Kedamangalam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1930', 'Kochi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1931', 'Kodamthuruthu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1932', 'Kodungallur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1933', 'Koduvally', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1934', 'Koduvayur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1935', 'Kokkothamangalam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1936', 'Kolazhy', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1937', 'Kollam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1938', 'Komalapuram', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1939', 'Koothattukulam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1940', 'Koratty', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1941', 'Kothamangalam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1942', 'Kottarakkara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1943', 'Kottayam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1944', 'Kottayam Malabar', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1945', 'Kottuvally', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1946', 'Koyilandi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1947', 'Kozhikode', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1948', 'Kudappanakunnu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1949', 'Kudlu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1950', 'Kumarakom', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1951', 'Kumily', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1952', 'Kunnamangalam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1953', 'Kunnamkulam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1954', 'Kurikkad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1955', 'Kurkkanchery', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1956', 'Kuthuparamba', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1957', 'Kuttakulam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1958', 'Kuttikkattur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1959', 'Kuttur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1960', 'Malappuram', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1961', 'Mallappally', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1962', 'Manjeri', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1963', 'Manjeshwar', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1964', 'Mannancherry', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1965', 'Mannar', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1966', 'Mannarakkat', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1967', 'Maradu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1968', 'Marathakkara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1969', 'Marutharod', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1970', 'Mattannur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1971', 'Mavelikara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1972', 'Mavilayi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1973', 'Mavur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1974', 'Methala', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1975', 'Muhamma', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1976', 'Mulavukad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1977', 'Mundakayam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1978', 'Munderi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1979', 'Munnar', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1980', 'Muthakunnam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1981', 'Muvattupuzha', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1982', 'Muzhappilangad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1983', 'Nadapuram', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1984', 'Nadathara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1985', 'Narath', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1986', 'Nattakam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1987', 'Nedumangad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1988', 'Nenmenikkara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1989', 'New Mahe', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1990', 'Neyyattinkara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1991', 'Nileshwar', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1992', 'Olavanna', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1993', 'Ottapalam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1994', 'Ottappalam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1995', 'Paduvilayi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1996', 'Palai', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1997', 'Palakkad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1998', 'Palayad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('1999', 'Palissery', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2000', 'Pallikkunnu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2001', 'Paluvai', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2002', 'Panniyannur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2003', 'Pantalam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2004', 'Panthiramkavu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2005', 'Panur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2006', 'Pappinisseri', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2007', 'Parassala', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2008', 'Paravur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2009', 'Pathanamthitta', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2010', 'Pathanapuram', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2011', 'Pathiriyad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2012', 'Pattambi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2013', 'Pattiom', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2014', 'Pavaratty', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2015', 'Payyannur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2016', 'Peermade', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2017', 'Perakam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2018', 'Peralasseri', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2019', 'Peringathur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2020', 'Perinthalmanna', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2021', 'Perole', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2022', 'Perumanna', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2023', 'Perumbaikadu', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2024', 'Perumbavoor', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2025', 'Pinarayi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2026', 'Piravam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2027', 'Ponnani', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2028', 'Pottore', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2029', 'Pudukad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2030', 'Punalur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2031', 'Puranattukara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2032', 'Puthunagaram', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2033', 'Puthuppariyaram', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2034', 'Puzhathi', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2035', 'Ramanattukara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2036', 'Shoranur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2037', 'Sultans Battery', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2038', 'Sulthan Bathery', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2039', 'Talipparamba', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2040', 'Thaikkad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2041', 'Thalassery', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2042', 'Thannirmukkam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2043', 'Theyyalingal', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2044', 'Thiruvalla', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2045', 'Thiruvananthapuram', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2046', 'Thiruvankulam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2047', 'Thodupuzha', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2048', 'Thottada', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2049', 'Thrippunithura', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2050', 'Thrissur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2051', 'Tirur', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2052', 'Udma', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2053', 'Vadakara', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2054', 'Vaikam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2055', 'Valapattam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2056', 'Vallachira', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2057', 'Varam', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2058', 'Varappuzha', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2059', 'Varkala', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2060', 'Vayalar', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2061', 'Vazhakkala', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2062', 'Venmanad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2063', 'Villiappally', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2064', 'Wayanad', '19');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2065', 'Agethi', '20');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2066', 'Amini', '20');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2067', 'Androth Island', '20');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2068', 'Kavaratti', '20');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2069', 'Minicoy', '20');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2070', 'Agar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2071', 'Ajaigarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2072', 'Akoda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2073', 'Akodia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2074', 'Alampur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2075', 'Alirajpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2076', 'Alot', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2077', 'Amanganj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2078', 'Amarkantak', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2079', 'Amarpatan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2080', 'Amarwara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2081', 'Ambada', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2082', 'Ambah', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2083', 'Amla', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2084', 'Amlai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2085', 'Anjad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2086', 'Antri', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2087', 'Anuppur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2088', 'Aron', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2089', 'Ashoknagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2090', 'Ashta', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2091', 'Babai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2092', 'Bada Malhera', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2093', 'Badagaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2094', 'Badagoan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2095', 'Badarwas', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2096', 'Badawada', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2097', 'Badi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2098', 'Badkuhi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2099', 'Badnagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2100', 'Badnawar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2101', 'Badod', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2102', 'Badoda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2103', 'Badra', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2104', 'Bagh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2105', 'Bagli', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2106', 'Baihar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2107', 'Baikunthpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2108', 'Bakswaha', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2109', 'Balaghat', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2110', 'Baldeogarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2111', 'Bamaniya', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2112', 'Bamhani', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2113', 'Bamor', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2114', 'Bamora', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2115', 'Banda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2116', 'Bangawan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2117', 'Bansatar Kheda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2118', 'Baraily', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2119', 'Barela', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2120', 'Barghat', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2121', 'Bargi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2122', 'Barhi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2123', 'Barigarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2124', 'Barwaha', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2125', 'Barwani', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2126', 'Basoda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2127', 'Begamganj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2128', 'Beohari', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2129', 'Berasia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2130', 'Betma', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2131', 'Betul', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2132', 'Betul Bazar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2133', 'Bhainsdehi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2134', 'Bhamodi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2135', 'Bhander', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2136', 'Bhanpura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2137', 'Bharveli', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2138', 'Bhaurasa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2139', 'Bhavra', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2140', 'Bhedaghat', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2141', 'Bhikangaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2142', 'Bhilakhedi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2143', 'Bhind', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2144', 'Bhitarwar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2145', 'Bhopal', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2146', 'Bhuibandh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2147', 'Biaora', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2148', 'Bijawar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2149', 'Bijeypur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2150', 'Bijrauni', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2151', 'Bijuri', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2152', 'Bilaua', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2153', 'Bilpura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2154', 'Bina Railway Colony', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2155', 'Bina-Etawa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2156', 'Birsinghpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2157', 'Boda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2158', 'Budhni', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2159', 'Burhanpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2160', 'Burhar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2161', 'Chachaura Binaganj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2162', 'Chakghat', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2163', 'Chandameta Butar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2164', 'Chanderi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2165', 'Chandia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2166', 'Chandla', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2167', 'Chaurai Khas', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2168', 'Chhatarpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2169', 'Chhindwara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2170', 'Chhota Chhindwara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2171', 'Chichli', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2172', 'Chitrakut', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2173', 'Churhat', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2174', 'Daboh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2175', 'Dabra', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2176', 'Damoh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2177', 'Damua', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2178', 'Datia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2179', 'Deodara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2180', 'Deori', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2181', 'Deori Khas', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2182', 'Depalpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2183', 'Devendranagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2184', 'Devhara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2185', 'Dewas', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2186', 'Dhamnod', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2187', 'Dhana', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2188', 'Dhanpuri', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2189', 'Dhar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2190', 'Dharampuri', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2191', 'Dighawani', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2192', 'Diken', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2193', 'Dindori', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2194', 'Dola', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2195', 'Dumar Kachhar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2196', 'Dungariya Chhapara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2197', 'Gadarwara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2198', 'Gairatganj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2199', 'Gandhi Sagar Hydel Colony', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2200', 'Ganjbasoda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2201', 'Garhakota', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2202', 'Garhi Malhara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2203', 'Garoth', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2204', 'Gautapura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2205', 'Ghansor', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2206', 'Ghuwara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2207', 'Gogaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2208', 'Gogapur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2209', 'Gohad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2210', 'Gormi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2211', 'Govindgarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2212', 'Guna', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2213', 'Gurh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2214', 'Gwalior', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2215', 'Hanumana', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2216', 'Harda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2217', 'Harpalpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2218', 'Harrai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2219', 'Harsud', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2220', 'Hatod', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2221', 'Hatpipalya', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2222', 'Hatta', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2223', 'Hindoria', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2224', 'Hirapur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2225', 'Hoshangabad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2226', 'Ichhawar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2227', 'Iklehra', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2228', 'Indergarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2229', 'Indore', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2230', 'Isagarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2231', 'Itarsi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2232', 'Jabalpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2233', 'Jabalpur Cantonment', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2234', 'Jabalpur G.C.F', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2235', 'Jaisinghnagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2236', 'Jaithari', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2237', 'Jaitwara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2238', 'Jamai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2239', 'Jaora', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2240', 'Jatachhapar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2241', 'Jatara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2242', 'Jawad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2243', 'Jawar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2244', 'Jeronkhalsa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2245', 'Jhabua', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2246', 'Jhundpura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2247', 'Jiran', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2248', 'Jirapur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2249', 'Jobat', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2250', 'Joura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2251', 'Kailaras', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2252', 'Kaimur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2253', 'Kakarhati', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2254', 'Kalichhapar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2255', 'Kanad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2256', 'Kannod', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2257', 'Kantaphod', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2258', 'Kareli', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2259', 'Karera', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2260', 'Kari', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2261', 'Karnawad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2262', 'Karrapur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2263', 'Kasrawad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2264', 'Katangi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2265', 'Katni', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2266', 'Kelhauri', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2267', 'Khachrod', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2268', 'Khajuraho', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2269', 'Khamaria', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2270', 'Khand', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2271', 'Khandwa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2272', 'Khaniyadhana', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2273', 'Khargapur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2274', 'Khargone', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2275', 'Khategaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2276', 'Khetia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2277', 'Khilchipur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2278', 'Khirkiya', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2279', 'Khujner', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2280', 'Khurai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2281', 'Kolaras', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2282', 'Kotar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2283', 'Kothi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2284', 'Kotma', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2285', 'Kukshi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2286', 'Kumbhraj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2287', 'Kurwai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2288', 'Lahar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2289', 'Lakhnadon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2290', 'Lateri', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2291', 'Laundi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2292', 'Lidhora Khas', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2293', 'Lodhikheda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2294', 'Loharda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2295', 'Machalpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2296', 'Madhogarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2297', 'Maharajpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2298', 'Maheshwar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2299', 'Mahidpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2300', 'Maihar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2301', 'Majholi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2302', 'Makronia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2303', 'Maksi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2304', 'Malaj Khand', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2305', 'Malanpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2306', 'Malhargarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2307', 'Manasa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2308', 'Manawar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2309', 'Mandav', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2310', 'Mandideep', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2311', 'Mandla', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2312', 'Mandleshwar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2313', 'Mandsaur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2314', 'Manegaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2315', 'Mangawan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2316', 'Manglaya Sadak', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2317', 'Manpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2318', 'Mau', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2319', 'Mauganj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2320', 'Meghnagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2321', 'Mehara Gaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2322', 'Mehgaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2323', 'Mhaugaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2324', 'Mhow', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2325', 'Mihona', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2326', 'Mohgaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2327', 'Morar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2328', 'Morena', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2329', 'Morwa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2330', 'Multai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2331', 'Mundi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2332', 'Mungaoli', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2333', 'Murwara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2334', 'Nagda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2335', 'Nagod', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2336', 'Nagri', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2337', 'Naigarhi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2338', 'Nainpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2339', 'Nalkheda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2340', 'Namli', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2341', 'Narayangarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2342', 'Narsimhapur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2343', 'Narsingarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2344', 'Narsinghpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2345', 'Narwar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2346', 'Nasrullaganj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2347', 'Naudhia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2348', 'Naugaon', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2349', 'Naurozabad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2350', 'Neemuch', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2351', 'Nepa Nagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2352', 'Neuton Chikhli Kalan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2353', 'Nimach', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2354', 'Niwari', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2355', 'Obedullaganj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2356', 'Omkareshwar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2357', 'Orachha', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2358', 'Ordinance Factory Itarsi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2359', 'Pachmarhi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2360', 'Pachmarhi Cantonment', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2361', 'Pachore', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2362', 'Palchorai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2363', 'Palda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2364', 'Palera', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2365', 'Pali', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2366', 'Panagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2367', 'Panara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2368', 'Pandaria', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2369', 'Pandhana', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2370', 'Pandhurna', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2371', 'Panna', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2372', 'Pansemal', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2373', 'Parasia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2374', 'Pasan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2375', 'Patan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2376', 'Patharia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2377', 'Pawai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2378', 'Petlawad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2379', 'Phuph Kalan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2380', 'Pichhore', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2381', 'Pipariya', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2382', 'Pipliya Mandi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2383', 'Piploda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2384', 'Pithampur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2385', 'Polay Kalan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2386', 'Porsa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2387', 'Prithvipur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2388', 'Raghogarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2389', 'Rahatgarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2390', 'Raisen', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2391', 'Rajakhedi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2392', 'Rajgarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2393', 'Rajnagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2394', 'Rajpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2395', 'Rampur Baghelan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2396', 'Rampur Naikin', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2397', 'Rampura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2398', 'Ranapur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2399', 'Ranipura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2400', 'Ratangarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2401', 'Ratlam', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2402', 'Ratlam Kasba', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2403', 'Rau', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2404', 'Rehli', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2405', 'Rehti', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2406', 'Rewa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2407', 'Sabalgarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2408', 'Sagar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2409', 'Sagar Cantonment', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2410', 'Sailana', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2411', 'Sanawad', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2412', 'Sanchi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2413', 'Sanwer', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2414', 'Sarangpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2415', 'Sardarpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2416', 'Sarni', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2417', 'Satai', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2418', 'Satna', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2419', 'Satwas', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2420', 'Sausar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2421', 'Sehore', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2422', 'Semaria', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2423', 'Sendhwa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2424', 'Seondha', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2425', 'Seoni', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2426', 'Seoni Malwa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2427', 'Sethia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2428', 'Shahdol', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2429', 'Shahgarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2430', 'Shahpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2431', 'Shahpura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2432', 'Shajapur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2433', 'Shamgarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2434', 'Sheopur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2435', 'Shivpuri', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2436', 'Shujalpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2437', 'Sidhi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2438', 'Sihora', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2439', 'Singolo', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2440', 'Singrauli', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2441', 'Sinhasa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2442', 'Sirgora', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2443', 'Sirmaur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2444', 'Sironj', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2445', 'Sitamau', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2446', 'Sohagpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2447', 'Sonkatch', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2448', 'Soyatkalan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2449', 'Suhagi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2450', 'Sultanpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2451', 'Susner', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2452', 'Suthaliya', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2453', 'Tal', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2454', 'Talen', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2455', 'Tarana', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2456', 'Taricharkalan', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2457', 'Tekanpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2458', 'Tendukheda', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2459', 'Teonthar', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2460', 'Thandia', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2461', 'Tikamgarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2462', 'Timarni', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2463', 'Tirodi', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2464', 'Udaipura', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2465', 'Ujjain', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2466', 'Ukwa', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2467', 'Umaria', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2468', 'Unchahara', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2469', 'Unhel', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2470', 'Vehicle Factory Jabalpur', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2471', 'Vidisha', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2472', 'Vijayraghavgarh', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2473', 'Waraseoni', '21');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2474', 'Achalpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2475', 'Aheri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2476', 'Ahmadnagar Cantonment', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2477', 'Ahmadpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2478', 'Ahmednagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2479', 'Ajra', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2480', 'Akalkot', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2481', 'Akkalkuwa', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2482', 'Akola', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2483', 'Akot', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2484', 'Alandi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2485', 'Alibag', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2486', 'Allapalli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2487', 'Alore', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2488', 'Amalner', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2489', 'Ambad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2490', 'Ambajogai', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2491', 'Ambernath', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2492', 'Ambivali Tarf Wankhal', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2493', 'Amgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2494', 'Amravati', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2495', 'Anjangaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2496', 'Arvi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2497', 'Ashta', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2498', 'Ashti', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2499', 'Aurangabad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2500', 'Aurangabad Cantonment', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2501', 'Ausa', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2502', 'Babhulgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2503', 'Badlapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2504', 'Balapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2505', 'Ballarpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2506', 'Baramati', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2507', 'Barshi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2508', 'Basmat', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2509', 'Beed', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2510', 'Bhadravati', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2511', 'Bhagur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2512', 'Bhandara', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2513', 'Bhigvan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2514', 'Bhingar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2515', 'Bhiwandi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2516', 'Bhokhardan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2517', 'Bhor', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2518', 'Bhosari', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2519', 'Bhum', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2520', 'Bhusawal', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2521', 'Bid', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2522', 'Biloli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2523', 'Birwadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2524', 'Boisar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2525', 'Bop Khel', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2526', 'Brahmapuri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2527', 'Budhgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2528', 'Buldana', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2529', 'Buldhana', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2530', 'Butibori', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2531', 'Chakan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2532', 'Chalisgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2533', 'Chandrapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2534', 'Chandur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2535', 'Chandur Bazar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2536', 'Chandvad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2537', 'Chicholi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2538', 'Chikhala', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2539', 'Chikhaldara', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2540', 'Chikhli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2541', 'Chinchani', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2542', 'Chinchwad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2543', 'Chiplun', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2544', 'Chopda', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2545', 'Dabhol', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2546', 'Dahance', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2547', 'Dahanu', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2548', 'Daharu', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2549', 'Dapoli Camp', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2550', 'Darwa', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2551', 'Daryapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2552', 'Dattapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2553', 'Daund', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2554', 'Davlameti', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2555', 'Deglur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2556', 'Dehu Road', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2557', 'Deolali', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2558', 'Deolali Pravara', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2559', 'Deoli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2560', 'Desaiganj', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2561', 'Deulgaon Raja', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2562', 'Dewhadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2563', 'Dharangaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2564', 'Dharmabad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2565', 'Dharur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2566', 'Dhatau', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2567', 'Dhule', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2568', 'Digdoh', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2569', 'Diglur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2570', 'Digras', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2571', 'Dombivli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2572', 'Dondaicha', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2573', 'Dudhani', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2574', 'Durgapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2575', 'Dyane', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2576', 'Edandol', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2577', 'Eklahare', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2578', 'Faizpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2579', 'Fekari', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2580', 'Gadchiroli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2581', 'Gadhinghaj', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2582', 'Gandhi Nagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2583', 'Ganeshpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2584', 'Gangakher', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2585', 'Gangapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2586', 'Gevrai', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2587', 'Ghatanji', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2588', 'Ghoti', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2589', 'Ghugus', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2590', 'Ghulewadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2591', 'Godoli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2592', 'Gondia', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2593', 'Guhagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2594', 'Hadgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2595', 'Harnai Beach', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2596', 'Hinganghat', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2597', 'Hingoli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2598', 'Hupari', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2599', 'Ichalkaranji', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2600', 'Igatpuri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2601', 'Indapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2602', 'Jaisinghpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2603', 'Jalgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2604', 'Jalna', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2605', 'Jamkhed', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2606', 'Jawhar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2607', 'Jaysingpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2608', 'Jejuri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2609', 'Jintur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2610', 'Junnar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2611', 'Kabnur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2612', 'Kagal', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2613', 'Kalamb', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2614', 'Kalamnuri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2615', 'Kalas', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2616', 'Kalmeshwar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2617', 'Kalundre', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2618', 'Kalyan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2619', 'Kamthi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2620', 'Kamthi Cantonment', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2621', 'Kandari', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2622', 'Kandhar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2623', 'Kandri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2624', 'Kandri II', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2625', 'Kanhan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2626', 'Kankavli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2627', 'Kannad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2628', 'Karad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2629', 'Karanja', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2630', 'Karanje Tarf', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2631', 'Karivali', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2632', 'Karjat', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2633', 'Karmala', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2634', 'Kasara Budruk', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2635', 'Katai', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2636', 'Katkar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2637', 'Katol', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2638', 'Kegaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2639', 'Khadkale', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2640', 'Khadki', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2641', 'Khamgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2642', 'Khapa', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2643', 'Kharadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2644', 'Kharakvasla', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2645', 'Khed', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2646', 'Kherdi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2647', 'Khoni', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2648', 'Khopoli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2649', 'Khuldabad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2650', 'Kinwat', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2651', 'Kodoli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2652', 'Kolhapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2653', 'Kon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2654', 'Kondumal', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2655', 'Kopargaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2656', 'Kopharad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2657', 'Koradi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2658', 'Koregaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2659', 'Korochi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2660', 'Kudal', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2661', 'Kundaim', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2662', 'Kundalwadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2663', 'Kurandvad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2664', 'Kurduvadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2665', 'Kusgaon Budruk', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2666', 'Lanja', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2667', 'Lasalgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2668', 'Latur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2669', 'Loha', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2670', 'Lohegaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2671', 'Lonar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2672', 'Lonavala', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2673', 'Madhavnagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2674', 'Mahabaleshwar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2675', 'Mahad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2676', 'Mahadula', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2677', 'Maindargi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2678', 'Majalgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2679', 'Malegaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2680', 'Malgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2681', 'Malkapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2682', 'Malwan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2683', 'Manadur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2684', 'Manchar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2685', 'Mangalvedhe', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2686', 'Mangrul Pir', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2687', 'Manmad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2688', 'Manor', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2689', 'Mansar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2690', 'Manwath', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2691', 'Mapuca', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2692', 'Matheran', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2693', 'Mehkar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2694', 'Mhasla', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2695', 'Mhaswad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2696', 'Mira Bhayandar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2697', 'Miraj', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2698', 'Mohpa', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2699', 'Mohpada', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2700', 'Moram', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2701', 'Morshi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2702', 'Mowad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2703', 'Mudkhed', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2704', 'Mukhed', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2705', 'Mul', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2706', 'Mulshi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2707', 'Mumbai', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2708', 'Murbad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2709', 'Murgud', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2710', 'Murtijapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2711', 'Murud', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2712', 'Nachane', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2713', 'Nagardeole', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2714', 'Nagothane', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2715', 'Nagpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2716', 'Nakoda', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2717', 'Nalasopara', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2718', 'Naldurg', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2719', 'Nanded', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2720', 'Nandgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2721', 'Nandura', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2722', 'Nandurbar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2723', 'Narkhed', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2724', 'Nashik', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2725', 'Navapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2726', 'Navi Mumbai', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2727', 'Navi Mumbai Panvel', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2728', 'Neral', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2729', 'Nigdi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2730', 'Nilanga', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2731', 'Nildoh', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2732', 'Nimbhore', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2733', 'Ojhar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2734', 'Osmanabad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2735', 'Pachgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2736', 'Pachora', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2737', 'Padagha', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2738', 'Paithan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2739', 'Palghar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2740', 'Pali', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2741', 'Panchgani', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2742', 'Pandhakarwada', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2743', 'Pandharpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2744', 'Panhala', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2745', 'Panvel', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2746', 'Paranda', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2747', 'Parbhani', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2748', 'Parli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2749', 'Parola', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2750', 'Partur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2751', 'Pasthal', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2752', 'Patan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2753', 'Pathardi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2754', 'Pathri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2755', 'Patur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2756', 'Pawni', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2757', 'Pen', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2758', 'Pethumri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2759', 'Phaltan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2760', 'Pimpri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2761', 'Poladpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2762', 'Pulgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2763', 'Pune', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2764', 'Pune Cantonment', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2765', 'Purna', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2766', 'Purushottamnagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2767', 'Pusad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2768', 'Rahimatpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2769', 'Rahta Pimplas', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2770', 'Rahuri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2771', 'Raigad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2772', 'Rajapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2773', 'Rajgurunagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2774', 'Rajur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2775', 'Rajura', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2776', 'Ramtek', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2777', 'Ratnagiri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2778', 'Ravalgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2779', 'Raver', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2780', 'Revadanda', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2781', 'Risod', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2782', 'Roha Ashtami', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2783', 'Sakri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2784', 'Sandor', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2785', 'Sangamner', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2786', 'Sangli', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2787', 'Sangole', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2788', 'Sasti', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2789', 'Sasvad', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2790', 'Satana', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2791', 'Satara', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2792', 'Savantvadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2793', 'Savda', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2794', 'Savner', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2795', 'Sawari Jawharnagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2796', 'Selu', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2797', 'Shahada', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2798', 'Shahapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2799', 'Shegaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2800', 'Shelar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2801', 'Shendurjana', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2802', 'Shirdi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2803', 'Shirgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2804', 'Shirpur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2805', 'Shirur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2806', 'Shirwal', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2807', 'Shivatkar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2808', 'Shrigonda', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2809', 'Shrirampur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2810', 'Shrirampur Rural', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2811', 'Sillewada', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2812', 'Sillod', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2813', 'Sindhudurg', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2814', 'Sindi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2815', 'Sindi Turf Hindnagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2816', 'Sindkhed Raja', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2817', 'Singnapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2818', 'Sinnar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2819', 'Sirur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2820', 'Sitasawangi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2821', 'Solapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2822', 'Sonai', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2823', 'Sonegaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2824', 'Soyagaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2825', 'Srivardhan', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2826', 'Surgana', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2827', 'Talegaon Dabhade', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2828', 'Taloda', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2829', 'Taloja', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2830', 'Talwade', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2831', 'Tarapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2832', 'Tasgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2833', 'Tathavade', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2834', 'Tekadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2835', 'Telhara', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2836', 'Thane', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2837', 'Tirira', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2838', 'Totaladoh', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2839', 'Trimbak', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2840', 'Tuljapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2841', 'Tumsar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2842', 'Uchgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2843', 'Udgir', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2844', 'Ulhasnagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2845', 'Umarga', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2846', 'Umarkhed', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2847', 'Umarsara', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2848', 'Umbar Pada Nandade', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2849', 'Umred', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2850', 'Umri Pragane Balapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2851', 'Uran', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2852', 'Uran Islampur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2853', 'Utekhol', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2854', 'Vada', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2855', 'Vadgaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2856', 'Vadgaon Kasba', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2857', 'Vaijapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2858', 'Vanvadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2859', 'Varangaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2860', 'Vasai', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2861', 'Vasantnagar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2862', 'Vashind', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2863', 'Vengurla', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2864', 'Virar', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2865', 'Visapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2866', 'Vite', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2867', 'Vithalwadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2868', 'Wadi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2869', 'Waghapur', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2870', 'Wai', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2871', 'Wajegaon', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2872', 'Walani', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2873', 'Wanadongri', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2874', 'Wani', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2875', 'Wardha', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2876', 'Warora', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2877', 'Warthi', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2878', 'Warud', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2879', 'Washim', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2880', 'Yaval', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2881', 'Yavatmal', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2882', 'Yeola', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2883', 'Yerkheda', '22');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2884', 'Andro', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2885', 'Bijoy Govinda', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2886', 'Bishnupur', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2887', 'Churachandpur', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2888', 'Heriok', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2889', 'Imphal', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2890', 'Jiribam', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2891', 'Kakching', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2892', 'Kakching Khunou', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2893', 'Khongman', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2894', 'Kumbi', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2895', 'Kwakta', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2896', 'Lamai', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2897', 'Lamjaotongba', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2898', 'Lamshang', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2899', 'Lilong', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2900', 'Mayang Imphal', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2901', 'Moirang', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2902', 'Moreh', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2903', 'Nambol', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2904', 'Naoriya Pakhanglakpa', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2905', 'Ningthoukhong', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2906', 'Oinam', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2907', 'Porompat', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2908', 'Samurou', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2909', 'Sekmai Bazar', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2910', 'Senapati', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2911', 'Sikhong Sekmai', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2912', 'Sugnu', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2913', 'Thongkhong Laxmi Bazar', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2914', 'Thoubal', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2915', 'Torban', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2916', 'Wangjing', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2917', 'Wangoi', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2918', 'Yairipok', '23');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2919', 'Baghmara', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2920', 'Cherrapunji', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2921', 'Jawai', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2922', 'Madanrting', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2923', 'Mairang', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2924', 'Mawlai', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2925', 'Nongmynsong', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2926', 'Nongpoh', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2927', 'Nongstoin', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2928', 'Nongthymmai', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2929', 'Pynthorumkhrah', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2930', 'Resubelpara', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2931', 'Shillong', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2932', 'Shillong Cantonment', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2933', 'Tura', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2934', 'Williamnagar', '24');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2935', 'Aizawl', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2936', 'Bairabi', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2937', 'Biate', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2938', 'Champhai', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2939', 'Darlawn', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2940', 'Hnahthial', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2941', 'Kawnpui', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2942', 'Khawhai', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2943', 'Khawzawl', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2944', 'Kolasib', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2945', 'Lengpui', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2946', 'Lunglei', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2947', 'Mamit', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2948', 'North Vanlaiphai', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2949', 'Saiha', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2950', 'Sairang', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2951', 'Saitul', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2952', 'Serchhip', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2953', 'Thenzawl', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2954', 'Tlabung', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2955', 'Vairengte', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2956', 'Zawlnuam', '25');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2957', 'Chumukedima', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2958', 'Dimapur', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2959', 'Kohima', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2960', 'Mokokchung', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2961', 'Mon', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2962', 'Phek', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2963', 'Tuensang', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2964', 'Wokha', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2965', 'Zunheboto', '26');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2966', 'Anandapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2967', 'Angul', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2968', 'Aska', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2969', 'Athgarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2970', 'Athmallik', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2971', 'Balagoda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2972', 'Balangir', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2973', 'Balasore', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2974', 'Baleshwar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2975', 'Balimeta', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2976', 'Balugaon', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2977', 'Banapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2978', 'Bangura', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2979', 'Banki', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2980', 'Banposh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2981', 'Barbil', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2982', 'Bargarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2983', 'Baripada', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2984', 'Barpali', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2985', 'Basudebpur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2986', 'Baudh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2987', 'Belagachhia', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2988', 'Belaguntha', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2989', 'Belpahar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2990', 'Berhampur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2991', 'Bhadrak', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2992', 'Bhanjanagar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2993', 'Bhawanipatna', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2994', 'Bhuban', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2995', 'Bhubaneswar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2996', 'Binika', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2997', 'Birmitrapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2998', 'Bishama Katek', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('2999', 'Bolangir', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3000', 'Brahmapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3001', 'Brajrajnagar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3002', 'Buguda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3003', 'Burla', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3004', 'Byasanagar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3005', 'Champua', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3006', 'Chandapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3007', 'Chandbali', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3008', 'Chandili', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3009', 'Charibatia', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3010', 'Chatrapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3011', 'Chikitigarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3012', 'Chitrakonda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3013', 'Choudwar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3014', 'Cuttack', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3015', 'Dadhapatna', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3016', 'Daitari', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3017', 'Damanjodi', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3018', 'Deogarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3019', 'Deracolliery', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3020', 'Dhamanagar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3021', 'Dhenkanal', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3022', 'Digapahandi', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3023', 'Dungamal', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3024', 'Fertilizer Corporation of Indi', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3025', 'Ganjam', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3026', 'Ghantapada', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3027', 'Gopalpur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3028', 'Gudari', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3029', 'Gunupur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3030', 'Hatibandha', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3031', 'Hinjilikatu', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3032', 'Hirakud', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3033', 'Jagatsinghapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3034', 'Jajpur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3035', 'Jalda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3036', 'Jaleswar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3037', 'Jatni', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3038', 'Jaypur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3039', 'Jeypore', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3040', 'Jharsuguda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3041', 'Jhumpura', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3042', 'Joda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3043', 'Junagarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3044', 'Kamakhyanagar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3045', 'Kantabanji', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3046', 'Kantilo', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3047', 'Karanja', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3048', 'Kashinagara', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3049', 'Kataka', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3050', 'Kavisuryanagar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3051', 'Kendrapara', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3052', 'Kendujhar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3053', 'Keonjhar', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3054', 'Kesinga', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3055', 'Khaliapali', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3056', 'Khalikote', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3057', 'Khandaparha', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3058', 'Kharhial', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3059', 'Kharhial Road', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3060', 'Khatiguda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3061', 'Khurda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3062', 'Kochinda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3063', 'Kodala', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3064', 'Konark', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3065', 'Koraput', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3066', 'Kotaparh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3067', 'Lanjigarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3068', 'Lattikata', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3069', 'Makundapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3070', 'Malkangiri', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3071', 'Mukhiguda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3072', 'Nabarangpur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3073', 'Nalco', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3074', 'Naurangapur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3075', 'Nayagarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3076', 'Nilagiri', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3077', 'Nimaparha', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3078', 'Nuapada', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3079', 'Nuapatna', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3080', 'OCL Industrialship', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3081', 'Padampur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3082', 'Paradip', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3083', 'Paradwip', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3084', 'Parlakimidi', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3085', 'Patamundai', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3086', 'Patnagarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3087', 'Phulabani', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3088', 'Pipili', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3089', 'Polasara', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3090', 'Pratapsasan', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3091', 'Puri', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3092', 'Purushottampur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3093', 'Rairangpur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3094', 'Raj Gangpur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3095', 'Rambha', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3096', 'Raurkela', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3097', 'Raurkela Civil Township', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3098', 'Rayagada', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3099', 'Redhakhol', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3100', 'Remuna', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3101', 'Rengali', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3102', 'Rourkela', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3103', 'Sambalpur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3104', 'Sinapali', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3105', 'Sonepur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3106', 'Sorada', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3107', 'Soro', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3108', 'Sunabeda', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3109', 'Sundargarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3110', 'Talcher', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3111', 'Talcher Thermal Power Station ', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3112', 'Tarabha', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3113', 'Tensa', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3114', 'Titlagarh', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3115', 'Udala', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3116', 'Udayagiri', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3117', 'Umarkot', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3118', 'Vikrampur', '29');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3119', 'Ariankuppam', '31');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3120', 'Karaikal', '31');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3121', 'Kurumbapet', '31');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3122', 'Mahe', '31');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3123', 'Ozhukarai', '31');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3124', 'Pondicherry', '31');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3125', 'Villianur', '31');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3126', 'Yanam', '31');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3127', 'Abohar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3128', 'Adampur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3129', 'Ahmedgarh', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3130', 'Ajnala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3131', 'Akalgarh', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3132', 'Alawalpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3133', 'Amloh', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3134', 'Amritsar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3135', 'Amritsar Cantonment', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3136', 'Anandpur Sahib', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3137', 'Badhni Kalan', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3138', 'Bagh Purana', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3139', 'Balachaur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3140', 'Banaur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3141', 'Banga', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3142', 'Banur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3143', 'Baretta', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3144', 'Bariwala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3145', 'Barnala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3146', 'Bassi Pathana', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3147', 'Batala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3148', 'Bathinda', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3149', 'Begowal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3150', 'Behrampur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3151', 'Bhabat', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3152', 'Bhadur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3153', 'Bhankharpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3154', 'Bharoli Kalan', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3155', 'Bhawanigarh', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3156', 'Bhikhi', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3157', 'Bhikhiwind', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3158', 'Bhisiana', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3159', 'Bhogpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3160', 'Bhuch', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3161', 'Bhulath', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3162', 'Budha Theh', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3163', 'Budhlada', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3164', 'Chima', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3165', 'Chohal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3166', 'Dasuya', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3167', 'Daulatpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3168', 'Dera Baba Nanak', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3169', 'Dera Bassi', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3170', 'Dhanaula', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3171', 'Dharam Kot', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3172', 'Dhariwal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3173', 'Dhilwan', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3174', 'Dhuri', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3175', 'Dinanagar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3176', 'Dirba', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3177', 'Doraha', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3178', 'Faridkot', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3179', 'Fateh Nangal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3180', 'Fatehgarh Churian', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3181', 'Fatehgarh Sahib', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3182', 'Fazilka', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3183', 'Firozpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3184', 'Firozpur Cantonment', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3185', 'Gardhiwala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3186', 'Garhshankar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3187', 'Ghagga', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3188', 'Ghanaur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3189', 'Giddarbaha', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3190', 'Gobindgarh', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3191', 'Goniana', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3192', 'Goraya', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3193', 'Gurdaspur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3194', 'Guru Har Sahai', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3195', 'Hajipur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3196', 'Handiaya', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3197', 'Hariana', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3198', 'Hoshiarpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3199', 'Hussainpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3200', 'Jagraon', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3201', 'Jaitu', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3202', 'Jalalabad', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3203', 'Jalandhar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3204', 'Jalandhar Cantonment', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3205', 'Jandiala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3206', 'Jugial', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3207', 'Kalanaur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3208', 'Kapurthala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3209', 'Karoran', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3210', 'Kartarpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3211', 'Khamanon', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3212', 'Khanauri', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3213', 'Khanna', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3214', 'Kharar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3215', 'Khem Karan', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3216', 'Kot Fatta', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3217', 'Kot Isa Khan', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3218', 'Kot Kapura', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3219', 'Kotkapura', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3220', 'Kurali', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3221', 'Lalru', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3222', 'Lehra Gaga', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3223', 'Lodhian Khas', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3224', 'Longowal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3225', 'Ludhiana', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3226', 'Machhiwara', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3227', 'Mahilpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3228', 'Majitha', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3229', 'Makhu', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3230', 'Malaut', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3231', 'Malerkotla', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3232', 'Maloud', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3233', 'Mandi Gobindgarh', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3234', 'Mansa', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3235', 'Maur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3236', 'Moga', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3237', 'Mohali', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3238', 'Moonak', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3239', 'Morinda', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3240', 'Mukerian', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3241', 'Muktsar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3242', 'Mullanpur Dakha', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3243', 'Mullanpur Garibdas', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3244', 'Munak', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3245', 'Muradpura', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3246', 'Nabha', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3247', 'Nakodar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3248', 'Nangal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3249', 'Nawashahr', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3250', 'Naya Nangal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3251', 'Nehon', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3252', 'Nurmahal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3253', 'Pathankot', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3254', 'Patiala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3255', 'Patti', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3256', 'Pattran', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3257', 'Payal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3258', 'Phagwara', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3259', 'Phillaur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3260', 'Qadian', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3261', 'Rahon', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3262', 'Raikot', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3263', 'Raja Sansi', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3264', 'Rajpura', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3265', 'Ram Das', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3266', 'Raman', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3267', 'Rampura', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3268', 'Rayya', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3269', 'Rupnagar', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3270', 'Rurki Kasba', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3271', 'Sahnewal', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3272', 'Samana', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3273', 'Samrala', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3274', 'Sanaur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3275', 'Sangat', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3276', 'Sangrur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3277', 'Sansarpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3278', 'Sardulgarh', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3279', 'Shahkot', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3280', 'Sham Churasi', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3281', 'Shekhpura', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3282', 'Sirhind', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3283', 'Sri Hargobindpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3284', 'Sujanpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3285', 'Sultanpur Lodhi', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3286', 'Sunam', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3287', 'Talwandi Bhai', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3288', 'Talwara', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3289', 'Tappa', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3290', 'Tarn Taran', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3291', 'Urmar Tanda', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3292', 'Zira', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3293', 'Zirakpur', '32');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3294', 'Abu Road', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3295', 'Ajmer', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3296', 'Aklera', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3297', 'Alwar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3298', 'Amet', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3299', 'Antah', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3300', 'Anupgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3301', 'Asind', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3302', 'Bagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3303', 'Bagru', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3304', 'Bahror', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3305', 'Bakani', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3306', 'Bali', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3307', 'Balotra', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3308', 'Bandikui', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3309', 'Banswara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3310', 'Baran', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3311', 'Bari', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3312', 'Bari Sadri', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3313', 'Barmer', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3314', 'Basi', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3315', 'Basni Belima', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3316', 'Baswa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3317', 'Bayana', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3318', 'Beawar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3319', 'Begun', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3320', 'Bhadasar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3321', 'Bhadra', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3322', 'Bhalariya', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3323', 'Bharatpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3324', 'Bhasawar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3325', 'Bhawani Mandi', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3326', 'Bhawri', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3327', 'Bhilwara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3328', 'Bhindar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3329', 'Bhinmal', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3330', 'Bhiwadi', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3331', 'Bijoliya Kalan', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3332', 'Bikaner', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3333', 'Bilara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3334', 'Bissau', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3335', 'Borkhera', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3336', 'Budhpura', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3337', 'Bundi', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3338', 'Chatsu', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3339', 'Chechat', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3340', 'Chhabra', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3341', 'Chhapar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3342', 'Chhipa Barod', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3343', 'Chhoti Sadri', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3344', 'Chirawa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3345', 'Chittaurgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3346', 'Chittorgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3347', 'Chomun', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3348', 'Churu', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3349', 'Daosa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3350', 'Dariba', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3351', 'Dausa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3352', 'Deoli', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3353', 'Deshnok', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3354', 'Devgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3355', 'Devli', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3356', 'Dhariawad', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3357', 'Dhaulpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3358', 'Dholpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3359', 'Didwana', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3360', 'Dig', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3361', 'Dungargarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3362', 'Dungarpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3363', 'Falna', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3364', 'Fatehnagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3365', 'Fatehpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3366', 'Gajsinghpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3367', 'Galiakot', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3368', 'Ganganagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3369', 'Gangapur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3370', 'Goredi Chancha', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3371', 'Gothra', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3372', 'Govindgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3373', 'Gulabpura', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3374', 'Hanumangarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3375', 'Hindaun', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3376', 'Indragarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3377', 'Jahazpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3378', 'Jaipur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3379', 'Jaisalmer', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3380', 'Jaiselmer', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3381', 'Jaitaran', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3382', 'Jalore', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3383', 'Jhalawar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3384', 'Jhalrapatan', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3385', 'Jhunjhunun', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3386', 'Jobner', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3387', 'Jodhpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3388', 'Kaithun', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3389', 'Kaman', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3390', 'Kankroli', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3391', 'Kanor', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3392', 'Kapasan', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3393', 'Kaprain', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3394', 'Karanpura', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3395', 'Karauli', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3396', 'Kekri', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3397', 'Keshorai Patan', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3398', 'Kesrisinghpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3399', 'Khairthal', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3400', 'Khandela', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3401', 'Khanpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3402', 'Kherli', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3403', 'Kherliganj', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3404', 'Kherwara Chhaoni', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3405', 'Khetri', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3406', 'Kiranipura', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3407', 'Kishangarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3408', 'Kishangarh Ranwal', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3409', 'Kolvi Rajendrapura', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3410', 'Kot Putli', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3411', 'Kota', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3412', 'Kuchaman', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3413', 'Kuchera', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3414', 'Kumbhalgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3415', 'Kumbhkot', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3416', 'Kumher', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3417', 'Kushalgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3418', 'Lachhmangarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3419', 'Ladnun', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3420', 'Lakheri', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3421', 'Lalsot', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3422', 'Losal', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3423', 'Madanganj', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3424', 'Mahu Kalan', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3425', 'Mahwa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3426', 'Makrana', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3427', 'Malpura', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3428', 'Mandal', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3429', 'Mandalgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3430', 'Mandawar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3431', 'Mandwa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3432', 'Mangrol', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3433', 'Manohar Thana', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3434', 'Manoharpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3435', 'Marwar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3436', 'Merta', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3437', 'Modak', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3438', 'Mount Abu', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3439', 'Mukandgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3440', 'Mundwa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3441', 'Nadbai', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3442', 'Naenwa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3443', 'Nagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3444', 'Nagaur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3445', 'Napasar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3446', 'Naraina', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3447', 'Nasirabad', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3448', 'Nathdwara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3449', 'Nawa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3450', 'Nawalgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3451', 'Neem Ka Thana', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3452', 'Neemrana', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3453', 'Newa Talai', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3454', 'Nimaj', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3455', 'Nimbahera', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3456', 'Niwai', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3457', 'Nohar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3458', 'Nokha', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3459', 'One SGM', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3460', 'Padampur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3461', 'Pali', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3462', 'Partapur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3463', 'Parvatsar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3464', 'Pasoond', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3465', 'Phalna', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3466', 'Phalodi', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3467', 'Phulera', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3468', 'Pilani', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3469', 'Pilibanga', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3470', 'Pindwara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3471', 'Pipalia Kalan', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3472', 'Pipar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3473', 'Pirawa', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3474', 'Pokaran', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3475', 'Pratapgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3476', 'Pushkar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3477', 'Raipur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3478', 'Raisinghnagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3479', 'Rajakhera', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3480', 'Rajaldesar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3481', 'Rajgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3482', 'Rajsamand', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3483', 'Ramganj Mandi', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3484', 'Ramgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3485', 'Rani', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3486', 'Raniwara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3487', 'Ratan Nagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3488', 'Ratangarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3489', 'Rawatbhata', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3490', 'Rawatsar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3491', 'Rikhabdev', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3492', 'Ringas', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3493', 'Sadri', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3494', 'Sadulshahar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3495', 'Sagwara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3496', 'Salumbar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3497', 'Sambhar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3498', 'Samdari', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3499', 'Sanchor', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3500', 'Sangariya', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3501', 'Sangod', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3502', 'Sardarshahr', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3503', 'Sarwar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3504', 'Satal Kheri', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3505', 'Sawai Madhopur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3506', 'Sewan Kalan', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3507', 'Shahpura', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3508', 'Sheoganj', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3509', 'Sikar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3510', 'Sirohi', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3511', 'Siwana', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3512', 'Sogariya', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3513', 'Sojat', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3514', 'Sojat Road', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3515', 'Sri Madhopur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3516', 'Sriganganagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3517', 'Sujangarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3518', 'Suket', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3519', 'Sumerpur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3520', 'Sunel', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3521', 'Surajgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3522', 'Suratgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3523', 'Swaroopganj', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3524', 'Takhatgarh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3525', 'Taranagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3526', 'Three STR', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3527', 'Tijara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3528', 'Toda Bhim', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3529', 'Toda Raisingh', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3530', 'Todra', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3531', 'Tonk', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3532', 'Udaipur', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3533', 'Udpura', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3534', 'Uniara', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3535', 'Vanasthali', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3536', 'Vidyavihar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3537', 'Vijainagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3538', 'Viratnagar', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3539', 'Wer', '33');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3540', 'Gangtok', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3541', 'Gezing', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3542', 'Jorethang', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3543', 'Mangan', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3544', 'Namchi', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3545', 'Naya Bazar', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3546', 'No City', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3547', 'Rangpo', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3548', 'Sikkim', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3549', 'Singtam', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3550', 'Upper Tadong', '34');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3551', 'Abiramam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3552', 'Achampudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3553', 'Acharapakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3554', 'Acharipallam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3555', 'Achipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3556', 'Adikaratti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3557', 'Adiramapattinam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3558', 'Aduturai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3559', 'Adyar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3560', 'Agaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3561', 'Agasthiswaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3562', 'Akkaraipettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3563', 'Alagappapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3564', 'Alagapuri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3565', 'Alampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3566', 'Alandur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3567', 'Alanganallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3568', 'Alangayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3569', 'Alangudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3570', 'Alangulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3571', 'Alanthurai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3572', 'Alapakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3573', 'Allapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3574', 'Alur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3575', 'Alwar Tirunagari', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3576', 'Alwarkurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3577', 'Ambasamudram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3578', 'Ambur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3579', 'Ammainaickanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3580', 'Ammaparikuppam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3581', 'Ammapettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3582', 'Ammavarikuppam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3583', 'Ammur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3584', 'Anaimalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3585', 'Anaiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3586', 'Anakaputhur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3587', 'Ananthapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3588', 'Andanappettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3589', 'Andipalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3590', 'Andippatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3591', 'Anjugramam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3592', 'Annamalainagar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3593', 'Annavasal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3594', 'Annur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3595', 'Anthiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3596', 'Appakudal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3597', 'Arachalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3598', 'Arakandanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3599', 'Arakonam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3600', 'Aralvaimozhi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3601', 'Arani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3602', 'Arani Road', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3603', 'Arantangi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3604', 'Arasiramani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3605', 'Aravakurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3606', 'Aravankadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3607', 'Arcot', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3608', 'Arimalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3609', 'Ariyalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3610', 'Ariyappampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3611', 'Ariyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3612', 'Arni', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3613', 'Arulmigu Thirumuruganpundi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3614', 'Arumanai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3615', 'Arumbavur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3616', 'Arumuganeri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3617', 'Aruppukkottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3618', 'Ashokapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3619', 'Athani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3620', 'Athanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3621', 'Athimarapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3622', 'Athipattu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3623', 'Athur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3624', 'Attayyampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3625', 'Attur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3626', 'Auroville', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3627', 'Avadattur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3628', 'Avadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3629', 'Avalpundurai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3630', 'Avaniapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3631', 'Avinashi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3632', 'Ayakudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3633', 'Ayanadaippu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3634', 'Aygudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3635', 'Ayothiapattinam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3636', 'Ayyalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3637', 'Ayyampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3638', 'Ayyampettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3639', 'Azhagiapandiapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3640', 'Balakrishnampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3641', 'Balakrishnapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3642', 'Balapallam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3643', 'Balasamudram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3644', 'Bargur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3645', 'Belur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3646', 'Berhatty', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3647', 'Bhavani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3648', 'Bhawanisagar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3649', 'Bhuvanagiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3650', 'Bikketti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3651', 'Bodinayakkanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3652', 'Brahmana Periya Agraharam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3653', 'Buthapandi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3654', 'Buthipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3655', 'Chatrapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3656', 'Chembarambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3657', 'Chengalpattu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3658', 'Chengam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3659', 'Chennai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3660', 'Chennasamudram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3661', 'Chennimalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3662', 'Cheranmadevi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3663', 'Cheruvanki', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3664', 'Chetpet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3665', 'Chettiarpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3666', 'Chettipalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3667', 'Chettipalayam Cantonment', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3668', 'Chettithangal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3669', 'Cheyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3670', 'Cheyyar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3671', 'Chidambaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3672', 'Chinalapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3673', 'Chinna Anuppanadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3674', 'Chinna Salem', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3675', 'Chinnakkampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3676', 'Chinnammanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3677', 'Chinnampalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3678', 'Chinnasekkadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3679', 'Chinnavedampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3680', 'Chitlapakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3681', 'Chittodu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3682', 'Cholapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3683', 'Coimbatore', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3684', 'Coonoor', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3685', 'Courtalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3686', 'Cuddalore', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3687', 'Dalavaipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3688', 'Darasuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3689', 'Denkanikottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3690', 'Desur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3691', 'Devadanapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3692', 'Devakkottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3693', 'Devakottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3694', 'Devanangurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3695', 'Devarshola', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3696', 'Devasthanam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3697', 'Dhalavoipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3698', 'Dhali', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3699', 'Dhaliyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3700', 'Dharapadavedu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3701', 'Dharapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3702', 'Dharmapuri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3703', 'Dindigul', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3704', 'Dusi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3705', 'Edaganasalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3706', 'Edaikodu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3707', 'Edakalinadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3708', 'Elathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3709', 'Elayirampannai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3710', 'Elumalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3711', 'Eral', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3712', 'Eraniel', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3713', 'Eriodu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3714', 'Erode', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3715', 'Erumaipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3716', 'Eruvadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3717', 'Ethapur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3718', 'Ettaiyapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3719', 'Ettimadai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3720', 'Ezhudesam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3721', 'Ganapathipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3722', 'Gandhi Nagar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3723', 'Gangaikondan', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3724', 'Gangavalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3725', 'Ganguvarpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3726', 'Gingi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3727', 'Gopalasamudram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3728', 'Gopichettipalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3729', 'Gudalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3730', 'Gudiyattam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3731', 'Guduvanchery', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3732', 'Gummidipoondi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3733', 'Hanumanthampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3734', 'Harur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3735', 'Harveypatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3736', 'Highways', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3737', 'Hosur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3738', 'Hubbathala', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3739', 'Huligal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3740', 'Idappadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3741', 'Idikarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3742', 'Ilampillai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3743', 'Ilanji', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3744', 'Iluppaiyurani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3745', 'Iluppur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3746', 'Inam Karur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3747', 'Injambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3748', 'Irugur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3749', 'Jaffrabad', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3750', 'Jagathala', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3751', 'Jalakandapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3752', 'Jalladiampet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3753', 'Jambai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3754', 'Jayankondam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3755', 'Jolarpet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3756', 'Kadambur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3757', 'Kadathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3758', 'Kadayal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3759', 'Kadayampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3760', 'Kadayanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3761', 'Kadiapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3762', 'Kalakkad', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3763', 'Kalambur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3764', 'Kalapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3765', 'Kalappanaickenpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3766', 'Kalavai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3767', 'Kalinjur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3768', 'Kaliyakkavilai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3769', 'Kallakkurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3770', 'Kallakudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3771', 'Kallidaikurichchi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3772', 'Kallukuttam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3773', 'Kallupatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3774', 'Kalpakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3775', 'Kalugumalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3776', 'Kamayagoundanpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3777', 'Kambainallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3778', 'Kambam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3779', 'Kamuthi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3780', 'Kanadukathan', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3781', 'Kanakkampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3782', 'Kanam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3783', 'Kanchipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3784', 'Kandanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3785', 'Kangayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3786', 'Kangayampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3787', 'Kangeyanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3788', 'Kaniyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3789', 'Kanjikoil', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3790', 'Kannadendal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3791', 'Kannamangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3792', 'Kannampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3793', 'Kannankurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3794', 'Kannapalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3795', 'Kannivadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3796', 'Kanyakumari', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3797', 'Kappiyarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3798', 'Karaikkudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3799', 'Karamadai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3800', 'Karambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3801', 'Karambakkudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3802', 'Kariamangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3803', 'Kariapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3804', 'Karugampattur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3805', 'Karumandi Chellipalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3806', 'Karumathampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3807', 'Karumbakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3808', 'Karungal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3809', 'Karunguzhi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3810', 'Karuppur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3811', 'Karur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3812', 'Kasipalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3813', 'Kasipalayam G', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3814', 'Kathirvedu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3815', 'Kathujuganapalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3816', 'Katpadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3817', 'Kattivakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3818', 'Kattumannarkoil', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3819', 'Kattupakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3820', 'Kattuputhur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3821', 'Kaveripakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3822', 'Kaveripattinam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3823', 'Kavundampalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3824', 'Kavundampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3825', 'Kayalpattinam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3826', 'Kayattar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3827', 'Kelamangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3828', 'Kelambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3829', 'Kembainaickenpalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3830', 'Kethi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3831', 'Kilakarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3832', 'Kilampadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3833', 'Kilkulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3834', 'Kilkunda', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3835', 'Killiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3836', 'Killlai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3837', 'Kilpennathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3838', 'Kilvelur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3839', 'Kinathukadavu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3840', 'Kiramangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3841', 'Kiranur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3842', 'Kiripatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3843', 'Kizhapavur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3844', 'Kmarasamipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3845', 'Kochadai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3846', 'Kodaikanal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3847', 'Kodambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3848', 'Kodavasal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3849', 'Kodumudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3850', 'Kolachal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3851', 'Kolappalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3852', 'Kolathupalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3853', 'Kolathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3854', 'Kollankodu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3855', 'Kollankoil', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3856', 'Komaralingam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3857', 'Komarapalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3858', 'Kombai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3859', 'Konakkarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3860', 'Konavattam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3861', 'Kondalampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3862', 'Konganapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3863', 'Koradacheri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3864', 'Korampallam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3865', 'Kotagiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3866', 'Kothinallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3867', 'Kottaiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3868', 'Kottakuppam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3869', 'Kottaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3870', 'Kottivakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3871', 'Kottur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3872', 'Kovilpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3873', 'Koyampattur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3874', 'Krishnagiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3875', 'Krishnarayapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3876', 'Krishnasamudram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3877', 'Kuchanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3878', 'Kuhalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3879', 'Kulasekarappattinam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3880', 'Kulasekarapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3881', 'Kulithalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3882', 'Kumarapalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3883', 'Kumarapalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3884', 'Kumarapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3885', 'Kumbakonam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3886', 'Kundrathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3887', 'Kuniyamuthur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3888', 'Kunnathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3889', 'Kunur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3890', 'Kuraikundu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3891', 'Kurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3892', 'Kurinjippadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3893', 'Kurudampalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3894', 'Kurumbalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3895', 'Kuthalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3896', 'Kuthappar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3897', 'Kuttalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3898', 'Kuttanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3899', 'Kuzhithurai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3900', 'Labbaikudikadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3901', 'Lakkampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3902', 'Lalgudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3903', 'Lalpet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3904', 'Llayangudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3905', 'Madambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3906', 'Madanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3907', 'Madathukulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3908', 'Madhavaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3909', 'Madippakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3910', 'Madukkarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3911', 'Madukkur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3912', 'Madurai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3913', 'Maduranthakam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3914', 'Maduravoyal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3915', 'Mahabalipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3916', 'Makkinanpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3917', 'Mallamuppampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3918', 'Mallankinaru', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3919', 'Mallapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3920', 'Mallasamudram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3921', 'Mallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3922', 'Mamallapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3923', 'Mamsapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3924', 'Manachanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3925', 'Manali', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3926', 'Manalmedu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3927', 'Manalurpet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3928', 'Manamadurai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3929', 'Manapakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3930', 'Manapparai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3931', 'Manavalakurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3932', 'Mandaikadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3933', 'Mandapam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3934', 'Mangadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3935', 'Mangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3936', 'Mangalampet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3937', 'Manimutharu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3938', 'Mannargudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3939', 'Mappilaiurani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3940', 'Maraimalai Nagar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3941', 'Marakkanam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3942', 'Maramangalathupatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3943', 'Marandahalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3944', 'Markayankottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3945', 'Marudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3946', 'Marungur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3947', 'Masinigudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3948', 'Mathigiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3949', 'Mattur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3950', 'Mayiladuthurai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3951', 'Mecheri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3952', 'Melacheval', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3953', 'Melachokkanathapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3954', 'Melagaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3955', 'Melamadai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3956', 'Melamaiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3957', 'Melanattam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3958', 'Melathiruppanthuruthi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3959', 'Melattur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3960', 'Melmananbedu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3961', 'Melpattampakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3962', 'Melur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3963', 'Melvisharam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3964', 'Mettupalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3965', 'Mettur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3966', 'Meyyanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3967', 'Milavittan', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3968', 'Minakshipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3969', 'Minambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3970', 'Minjur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3971', 'Modakurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3972', 'Mohanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3973', 'Mopperipalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3974', 'Mudalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3975', 'Mudichur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3976', 'Mudukulathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3977', 'Mukasipidariyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3978', 'Mukkudal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3979', 'Mulagumudu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3980', 'Mulakaraipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3981', 'Mulanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3982', 'Mullakkadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3983', 'Muruganpalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3984', 'Musiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3985', 'Muthupet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3986', 'Muthur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3987', 'Muttayyapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3988', 'Muttupet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3989', 'Muvarasampettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3990', 'Myladi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3991', 'Mylapore', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3992', 'Nadukkuthagai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3993', 'Naduvattam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3994', 'Nagapattinam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3995', 'Nagavakulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3996', 'Nagercoil', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3997', 'Nagojanahalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3998', 'Nallampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('3999', 'Nallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4000', 'Namagiripettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4001', 'Namakkal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4002', 'Nambiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4003', 'Nambutalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4004', 'Nandambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4005', 'Nandivaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4006', 'Nangavalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4007', 'Nangavaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4008', 'Nanguneri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4009', 'Nanjikottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4010', 'Nannilam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4011', 'Naranammalpuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4012', 'Naranapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4013', 'Narasimhanaickenpalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4014', 'Narasingapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4015', 'Narasojipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4016', 'Naravarikuppam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4017', 'Nasiyanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4018', 'Natham', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4019', 'Nathampannai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4020', 'Natrampalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4021', 'Nattam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4022', 'Nattapettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4023', 'Nattarasankottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4024', 'Navalpattu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4025', 'Nazarethpettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4026', 'Nazerath', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4027', 'Neikkarapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4028', 'Neiyyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4029', 'Nellikkuppam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4030', 'Nelliyalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4031', 'Nemili', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4032', 'Nemilicheri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4033', 'Neripperichal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4034', 'Nerkunram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4035', 'Nerkuppai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4036', 'Nerunjipettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4037', 'Neykkarappatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4038', 'Neyveli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4039', 'Nidamangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4040', 'Nilagiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4041', 'Nilakkottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4042', 'Nilankarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4043', 'Odaipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4044', 'Odaiyakulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4045', 'Oddanchatram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4046', 'Odugathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4047', 'Oggiyamduraipakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4048', 'Olagadam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4049', 'Omalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4050', 'Ooty', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4051', 'Orathanadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4052', 'Othakadai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4053', 'Othakalmandapam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4054', 'Ottapparai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4055', 'Pacode', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4056', 'Padaividu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4057', 'Padianallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4058', 'Padirikuppam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4059', 'Padmanabhapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4060', 'Padririvedu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4061', 'Palaganangudy', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4062', 'Palaimpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4063', 'Palakkodu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4064', 'Palamedu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4065', 'Palani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4066', 'Palani Chettipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4067', 'Palavakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4068', 'Palavansathu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4069', 'Palayakayal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4070', 'Palayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4071', 'Palayamkottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4072', 'Palladam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4073', 'Pallapalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4074', 'Pallapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4075', 'Pallattur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4076', 'Pallavaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4077', 'Pallikaranai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4078', 'Pallikonda', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4079', 'Pallipalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4080', 'Pallipalaiyam Agraharam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4081', 'Pallipattu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4082', 'Pammal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4083', 'Panagudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4084', 'Panaimarathupatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4085', 'Panapakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4086', 'Panboli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4087', 'Pandamangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4088', 'Pannaikadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4089', 'Pannaipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4090', 'Pannuratti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4091', 'Panruti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4092', 'Papanasam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4093', 'Pappankurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4094', 'Papparapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4095', 'Pappireddipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4096', 'Paramakkudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4097', 'Paramankurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4098', 'Paramathi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4099', 'Parangippettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4100', 'Paravai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4101', 'Pasur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4102', 'Pathamadai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4103', 'Pattinam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4104', 'Pattiviranpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4105', 'Pattukkottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4106', 'Pazhugal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4107', 'Pennadam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4108', 'Pennagaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4109', 'Pennathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4110', 'Peraiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4111', 'Peralam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4112', 'Perambalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4113', 'Peranamallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4114', 'Peravurani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4115', 'Periyakodiveri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4116', 'Periyakulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4117', 'Periyanayakkanpalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4118', 'Periyanegamam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4119', 'Periyapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4120', 'Periyasemur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4121', 'Pernambut', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4122', 'Perumagalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4123', 'Perumandi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4124', 'Perumuchi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4125', 'Perundurai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4126', 'Perungalathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4127', 'Perungudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4128', 'Perungulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4129', 'Perur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4130', 'Perur Chettipalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4131', 'Pethampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4132', 'Pethanaickenpalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4133', 'Pillanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4134', 'Pirkankaranai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4135', 'Polichalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4136', 'Pollachi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4137', 'Polur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4138', 'Ponmani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4139', 'Ponnamaravathi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4140', 'Ponnampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4141', 'Ponneri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4142', 'Porur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4143', 'Pothanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4144', 'Pothatturpettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4145', 'Pudukadai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4146', 'Pudukkottai Cantonment', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4147', 'Pudukottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4148', 'Pudupalaiyam Aghraharam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4149', 'Pudupalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4150', 'Pudupatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4151', 'Pudupattinam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4152', 'Pudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4153', 'Puduvayal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4154', 'Pulambadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4155', 'Pulampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4156', 'Puliyampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4157', 'Puliyankudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4158', 'Puliyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4159', 'Pullampadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4160', 'Puluvapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4161', 'Punamalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4162', 'Punjai Puliyampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4163', 'Punjai Thottakurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4164', 'Punjaipugalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4165', 'Puthalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4166', 'Putteri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4167', 'Puvalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4168', 'Puzhal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4169', 'Puzhithivakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4170', 'Rajapalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4171', 'Ramanathapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4172', 'Ramapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4173', 'Rameswaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4174', 'Ranipet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4175', 'Rasipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4176', 'Rayagiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4177', 'Rithapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4178', 'Rosalpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4179', 'Rudravathi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4180', 'Sadayankuppam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4181', 'Saint Thomas Mount', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4182', 'Salangapalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4183', 'Salem', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4184', 'Samalapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4185', 'Samathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4186', 'Sambavar Vadagarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4187', 'Sankaramanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4188', 'Sankarankoil', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4189', 'Sankarapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4190', 'Sankari', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4191', 'Sankarnagar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4192', 'Saravanampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4193', 'Sarcarsamakulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4194', 'Sathiyavijayanagaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4195', 'Sathuvachari', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4196', 'Sathyamangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4197', 'Sattankulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4198', 'Sattur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4199', 'Sayalgudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4200', 'Sayapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4201', 'Seithur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4202', 'Sembakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4203', 'Semmipalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4204', 'Sennirkuppam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4205', 'Senthamangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4206', 'Sentharapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4207', 'Senur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4208', 'Sethiathoppu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4209', 'Sevilimedu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4210', 'Sevugampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4211', 'Shenbakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4212', 'Shencottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4213', 'Shenkottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4214', 'Sholavandan', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4215', 'Sholinganallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4216', 'Sholingur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4217', 'Sholur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4218', 'Sikkarayapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4219', 'Singampuneri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4220', 'Singanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4221', 'Singaperumalkoil', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4222', 'Sirapalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4223', 'Sirkali', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4224', 'Sirugamani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4225', 'Sirumugai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4226', 'Sithayankottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4227', 'Sithurajapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4228', 'Sivaganga', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4229', 'Sivagiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4230', 'Sivakasi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4231', 'Sivanthipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4232', 'Sivur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4233', 'Soranjeri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4234', 'South Kannanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4235', 'South Kodikulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4236', 'Srimushnam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4237', 'Sriperumpudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4238', 'Sriramapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4239', 'Srirangam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4240', 'Srivaikuntam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4241', 'Srivilliputtur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4242', 'Suchindram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4243', 'Suliswaranpatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4244', 'Sulur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4245', 'Sundarapandiam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4246', 'Sundarapandiapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4247', 'Surampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4248', 'Surandai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4249', 'Suriyampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4250', 'Swamimalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4251', 'TNPL Pugalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4252', 'Tambaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4253', 'Taramangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4254', 'Tattayyangarpettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4255', 'Tayilupatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4256', 'Tenkasi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4257', 'Thadikombu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4258', 'Thakkolam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4259', 'Thalainayar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4260', 'Thalakudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4261', 'Thamaraikulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4262', 'Thammampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4263', 'Thanjavur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4264', 'Thanthoni', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4265', 'Tharangambadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4266', 'Thedavur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4267', 'Thenambakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4268', 'Thengampudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4269', 'Theni', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4270', 'Theni Allinagaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4271', 'Thenkarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4272', 'Thenthamaraikulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4273', 'Thenthiruperai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4274', 'Thesur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4275', 'Thevaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4276', 'Thevur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4277', 'Thiagadurgam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4278', 'Thiagarajar Colony', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4279', 'Thingalnagar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4280', 'Thiruchirapalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4281', 'Thirukarungudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4282', 'Thirukazhukundram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4283', 'Thirumalayampalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4284', 'Thirumazhisai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4285', 'Thirunagar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4286', 'Thirunageswaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4287', 'Thirunindravur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4288', 'Thirunirmalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4289', 'Thiruparankundram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4290', 'Thiruparappu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4291', 'Thiruporur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4292', 'Thiruppanandal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4293', 'Thirupuvanam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4294', 'Thiruthangal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4295', 'Thiruthuraipundi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4296', 'Thiruvaivaru', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4297', 'Thiruvalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4298', 'Thiruvarur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4299', 'Thiruvattaru', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4300', 'Thiruvenkatam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4301', 'Thiruvennainallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4302', 'Thiruvithankodu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4303', 'Thisayanvilai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4304', 'Thittacheri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4305', 'Thondamuthur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4306', 'Thorapadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4307', 'Thottipalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4308', 'Thottiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4309', 'Thudiyalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4310', 'Thuthipattu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4311', 'Thuvakudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4312', 'Timiri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4313', 'Tindivanam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4314', 'Tinnanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4315', 'Tiruchchendur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4316', 'Tiruchengode', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4317', 'Tirukkalukkundram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4318', 'Tirukkattuppalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4319', 'Tirukkoyilur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4320', 'Tirumangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4321', 'Tirumullaivasal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4322', 'Tirumuruganpundi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4323', 'Tirunageswaram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4324', 'Tirunelveli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4325', 'Tirupathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4326', 'Tirupattur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4327', 'Tiruppuvanam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4328', 'Tirupur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4329', 'Tirusulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4330', 'Tiruttani', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4331', 'Tiruvallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4332', 'Tiruvannamalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4333', 'Tiruverambur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4334', 'Tiruverkadu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4335', 'Tiruvethipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4336', 'Tiruvidaimarudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4337', 'Tiruvottiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4338', 'Tittakudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4339', 'Tondi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4340', 'Turaiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4341', 'Tuticorin', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4342', 'Udagamandalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4343', 'Udagamandalam Valley', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4344', 'Udankudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4345', 'Udayarpalayam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4346', 'Udumalaipettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4347', 'Udumalpet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4348', 'Ullur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4349', 'Ulundurpettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4350', 'Unjalaur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4351', 'Unnamalaikadai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4352', 'Uppidamangalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4353', 'Uppiliapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4354', 'Urachikkottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4355', 'Urapakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4356', 'Usilampatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4357', 'Uthangarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4358', 'Uthayendram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4359', 'Uthiramerur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4360', 'Uthukkottai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4361', 'Uttamapalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4362', 'Uttukkuli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4363', 'Vadakarai Kizhpadugai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4364', 'Vadakkanandal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4365', 'Vadakku Valliyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4366', 'Vadalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4367', 'Vadamadurai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4368', 'Vadavalli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4369', 'Vadipatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4370', 'Vadugapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4371', 'Vaithiswarankoil', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4372', 'Valangaiman', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4373', 'Valasaravakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4374', 'Valavanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4375', 'Vallam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4376', 'Valparai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4377', 'Valvaithankoshtam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4378', 'Vanavasi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4379', 'Vandalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4380', 'Vandavasi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4381', 'Vandiyur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4382', 'Vaniputhur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4383', 'Vaniyambadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4384', 'Varadarajanpettai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4385', 'Varadharajapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4386', 'Vasudevanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4387', 'Vathirairuppu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4388', 'Vattalkundu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4389', 'Vazhapadi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4390', 'Vedapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4391', 'Vedaranniyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4392', 'Vedasandur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4393', 'Velampalaiyam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4394', 'Velankanni', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4395', 'Vellakinar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4396', 'Vellakoil', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4397', 'Vellalapatti', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4398', 'Vellalur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4399', 'Vellanur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4400', 'Vellimalai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4401', 'Vellore', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4402', 'Vellottamparappu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4403', 'Velluru', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4404', 'Vengampudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4405', 'Vengathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4406', 'Vengavasal', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4407', 'Venghatur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4408', 'Venkarai', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4409', 'Vennanthur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4410', 'Veppathur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4411', 'Verkilambi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4412', 'Vettaikaranpudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4413', 'Vettavalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4414', 'Vijayapuri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4415', 'Vikramasingapuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4416', 'Vikravandi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4417', 'Vilangudi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4418', 'Vilankurichi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4419', 'Vilapakkam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4420', 'Vilathikulam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4421', 'Vilavur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4422', 'Villukuri', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4423', 'Villupuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4424', 'Viraganur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4425', 'Virakeralam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4426', 'Virakkalpudur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4427', 'Virapandi', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4428', 'Virapandi Cantonment', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4429', 'Virappanchatram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4430', 'Viravanallur', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4431', 'Virudambattu', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4432', 'Virudhachalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4433', 'Virudhunagar', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4434', 'Virupakshipuram', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4435', 'Viswanatham', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4436', 'Vriddhachalam', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4437', 'Walajabad', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4438', 'Walajapet', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4439', 'Wellington', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4440', 'Yercaud', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4441', 'Zamin Uthukuli', '35');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4442', 'Achampet', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4443', 'Adilabad', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4444', 'Armoor', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4445', 'Asifabad', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4446', 'Badepally', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4447', 'Banswada', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4448', 'Bellampalli', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4449', 'Bhadrachalam', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4450', 'Bhainsa', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4451', 'Bhongir', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4452', 'Bhupalpally', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4453', 'Bodhan', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4454', 'Bollaram', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4455', 'Devarkonda', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4456', 'Farooqnagar', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4457', 'Gadwal', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4458', 'Gajwel', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4459', 'Ghatkesar', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4460', 'Hyderabad', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4461', 'Jagtial', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4462', 'Jangaon', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4463', 'Kagaznagar', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4464', 'Kalwakurthy', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4465', 'Kamareddy', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4466', 'Karimnagar', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4467', 'Khammam', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4468', 'Kodada', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4469', 'Koratla', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4470', 'Kottagudem', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4471', 'Kyathampalle', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4472', 'Madhira', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4473', 'Mahabubabad', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4474', 'Mahbubnagar', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4475', 'Mancherial', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4476', 'Mandamarri', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4477', 'Manuguru', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4478', 'Medak', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4479', 'Medchal', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4480', 'Miryalaguda', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4481', 'Nagar Karnul', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4482', 'Nakrekal', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4483', 'Nalgonda', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4484', 'Narayanpet', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4485', 'Narsampet', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4486', 'Nirmal', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4487', 'Nizamabad', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4488', 'Palwancha', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4489', 'Peddapalli', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4490', 'Ramagundam', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4491', 'Ranga Reddy district', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4492', 'Sadasivpet', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4493', 'Sangareddy', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4494', 'Sarapaka', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4495', 'Sathupalle', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4496', 'Secunderabad', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4497', 'Siddipet', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4498', 'Singapur', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4499', 'Sircilla', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4500', 'Suryapet', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4501', 'Tandur', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4502', 'Vemulawada', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4503', 'Vikarabad', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4504', 'Wanaparthy', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4505', 'Warangal', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4506', 'Yellandu', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4507', 'Zahirabad', '36');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4508', 'Agartala', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4509', 'Amarpur', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4510', 'Ambassa', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4511', 'Badharghat', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4512', 'Belonia', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4513', 'Dharmanagar', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4514', 'Gakulnagar', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4515', 'Gandhigram', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4516', 'Indranagar', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4517', 'Jogendranagar', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4518', 'Kailasahar', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4519', 'Kamalpur', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4520', 'Kanchanpur', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4521', 'Khowai', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4522', 'Kumarghat', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4523', 'Kunjaban', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4524', 'Narsingarh', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4525', 'Pratapgarh', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4526', 'Ranir Bazar', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4527', 'Sabrum', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4528', 'Sonamura', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4529', 'Teliamura', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4530', 'Udaipur', '37');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4531', 'Achhalda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4532', 'Achhnera', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4533', 'Adari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4534', 'Afzalgarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4535', 'Agarwal Mandi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4536', 'Agra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4537', 'Agra Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4538', 'Ahraura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4539', 'Ailum', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4540', 'Air Force Area', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4541', 'Ajhuwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4542', 'Akbarpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4543', 'Alapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4544', 'Aliganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4545', 'Aligarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4546', 'Allahabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4547', 'Allahabad Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4548', 'Allahganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4549', 'Amanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4550', 'Ambahta', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4551', 'Amethi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4552', 'Amila', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4553', 'Amilo', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4554', 'Aminagar Sarai', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4555', 'Aminagar Urf Bhurbaral', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4556', 'Amraudha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4557', 'Amroha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4558', 'Anandnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4559', 'Anpara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4560', 'Antu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4561', 'Anupshahr', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4562', 'Aonla', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4563', 'Armapur Estate', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4564', 'Ashokpuram', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4565', 'Ashrafpur Kichhauchha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4566', 'Atarra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4567', 'Atasu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4568', 'Atrauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4569', 'Atraulia', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4570', 'Auraiya', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4571', 'Aurangabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4572', 'Aurangabad Bangar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4573', 'Auras', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4574', 'Awagarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4575', 'Ayodhya', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4576', 'Azamgarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4577', 'Azizpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4578', 'Azmatgarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4579', 'Babarpur Ajitmal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4580', 'Baberu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4581', 'Babina', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4582', 'Babrala', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4583', 'Babugarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4584', 'Bachhiowan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4585', 'Bachhraon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4586', 'Bad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4587', 'Badaun', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4588', 'Baghpat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4589', 'Bah', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4590', 'Bahadurganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4591', 'Baheri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4592', 'Bahjoi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4593', 'Bahraich', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4594', 'Bahsuma', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4595', 'Bahua', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4596', 'Bajna', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4597', 'Bakewar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4598', 'Bakiabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4599', 'Baldeo', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4600', 'Ballia', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4601', 'Balrampur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4602', 'Banat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4603', 'Banda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4604', 'Bangarmau', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4605', 'Banki', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4606', 'Bansdih', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4607', 'Bansgaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4608', 'Bansi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4609', 'Barabanki', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4610', 'Baragaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4611', 'Baraut', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4612', 'Bareilly', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4613', 'Bareilly Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4614', 'Barhalganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4615', 'Barhani', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4616', 'Barhapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4617', 'Barkhera', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4618', 'Barsana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4619', 'Barva Sagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4620', 'Barwar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4621', 'Basti', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4622', 'Begumabad Budhana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4623', 'Behat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4624', 'Behta Hajipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4625', 'Bela', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4626', 'Belthara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4627', 'Beniganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4628', 'Beswan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4629', 'Bewar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4630', 'Bhadarsa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4631', 'Bhadohi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4632', 'Bhagwantnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4633', 'Bharatganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4634', 'Bhargain', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4635', 'Bharthana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4636', 'Bharuhana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4637', 'Bharwari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4638', 'Bhatni Bazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4639', 'Bhatpar Rani', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4640', 'Bhawan Bahadurnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4641', 'Bhinga', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4642', 'Bhojpur Dharampur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4643', 'Bhokarhedi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4644', 'Bhongaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4645', 'Bhulepur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4646', 'Bidhuna', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4647', 'Bighapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4648', 'Bijnor', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4649', 'Bijpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4650', 'Bikapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4651', 'Bilari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4652', 'Bilaspur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4653', 'Bilgram', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4654', 'Bilhaur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4655', 'Bilram', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4656', 'Bilrayaganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4657', 'Bilsanda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4658', 'Bilsi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4659', 'Bindki', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4660', 'Bisalpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4661', 'Bisanda Buzurg', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4662', 'Bisauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4663', 'Bisharatganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4664', 'Bisokhar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4665', 'Biswan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4666', 'Bithur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4667', 'Budaun', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4668', 'Bugrasi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4669', 'Bulandshahar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4670', 'Burhana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4671', 'Chail', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4672', 'Chak Imam Ali', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4673', 'Chakeri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4674', 'Chakia', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4675', 'Chandauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4676', 'Chandausi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4677', 'Chandpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4678', 'Charkhari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4679', 'Charthawal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4680', 'Chaumuhan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4681', 'Chhaprauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4682', 'Chhara Rafatpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4683', 'Chharprauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4684', 'Chhata', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4685', 'Chhatari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4686', 'Chhibramau', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4687', 'Chhutmalpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4688', 'Chilkana Sultanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4689', 'Chirgaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4690', 'Chit Baragaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4691', 'Chitrakut Dham', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4692', 'Chopan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4693', 'Choubepur Kalan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4694', 'Chunar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4695', 'Churk Ghurma', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4696', 'Colonelganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4697', 'Dadri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4698', 'Dalmau', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4699', 'Dankaur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4700', 'Dariyabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4701', 'Dasna', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4702', 'Dataganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4703', 'Daurala', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4704', 'Dayal Bagh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4705', 'Deoband', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4706', 'Deoranian', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4707', 'Deoria', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4708', 'Dewa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4709', 'Dhampur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4710', 'Dhanauha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4711', 'Dhanauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4712', 'Dhanaura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4713', 'Dharoti Khurd', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4714', 'Dhauratanda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4715', 'Dhaurhra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4716', 'Dibai', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4717', 'Dibiyapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4718', 'Dildarnagar Fatehpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4719', 'Do Ghat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4720', 'Dohrighat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4721', 'Dostpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4722', 'Dudhinagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4723', 'Dulhipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4724', 'Dundwaraganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4725', 'Ekdil', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4726', 'Erich', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4727', 'Etah', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4728', 'Etawah', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4729', 'Faizabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4730', 'Faizabad Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4731', 'Faizganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4732', 'Farah', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4733', 'Faridnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4734', 'Faridpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4735', 'Faridpur Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4736', 'Fariha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4737', 'Farrukhabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4738', 'Fatehabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4739', 'Fatehganj Pashchimi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4740', 'Fatehganj Purvi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4741', 'Fatehgarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4742', 'Fatehpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4743', 'Fatehpur Chaurasi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4744', 'Fatehpur Sikri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4745', 'Firozabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4746', 'Gajraula', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4747', 'Ganga Ghat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4748', 'Gangapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4749', 'Gangoh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4750', 'Ganj Muradabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4751', 'Garautha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4752', 'Garhi Pukhta', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4753', 'Garhmukteshwar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4754', 'Gaura Barahaj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4755', 'Gauri Bazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4756', 'Gausganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4757', 'Gawan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4758', 'Ghatampur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4759', 'Ghaziabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4760', 'Ghazipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4761', 'Ghiror', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4762', 'Ghorawal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4763', 'Ghosi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4764', 'Ghosia Bazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4765', 'Ghughuli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4766', 'Gohand', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4767', 'Gokul', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4768', 'Gola Bazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4769', 'Gola Gokarannath', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4770', 'Gonda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4771', 'Gopamau', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4772', 'Gopiganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4773', 'Gorakhpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4774', 'Gosainganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4775', 'Govardhan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4776', 'Greater Noida', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4777', 'Gulaothi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4778', 'Gulariya', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4779', 'Gulariya Bhindara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4780', 'Gunnaur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4781', 'Gursahaiganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4782', 'Gursarai', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4783', 'Gyanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4784', 'Hafizpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4785', 'Haidergarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4786', 'Haldaur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4787', 'Hamirpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4788', 'Handia', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4789', 'Hapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4790', 'Hardoi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4791', 'Harduaganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4792', 'Hargaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4793', 'Hariharpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4794', 'Harraiya', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4795', 'Hasanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4796', 'Hasayan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4797', 'Hastinapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4798', 'Hata', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4799', 'Hathras', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4800', 'Hyderabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4801', 'Ibrahimpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4802', 'Iglas', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4803', 'Ikauna', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4804', 'Iltifatganj Bazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4805', 'Indian Telephone Industry Mank', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4806', 'Islamnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4807', 'Itaunja', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4808', 'Itimadpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4809', 'Jagner', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4810', 'Jahanabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4811', 'Jahangirabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4812', 'Jahangirpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4813', 'Jais', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4814', 'Jaithara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4815', 'Jalalabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4816', 'Jalali', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4817', 'Jalalpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4818', 'Jalaun', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4819', 'Jalesar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4820', 'Jamshila', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4821', 'Jangipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4822', 'Jansath', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4823', 'Jarwal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4824', 'Jasrana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4825', 'Jaswantnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4826', 'Jatari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4827', 'Jaunpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4828', 'Jewar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4829', 'Jhalu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4830', 'Jhansi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4831', 'Jhansi Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4832', 'Jhansi Railway Settlement', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4833', 'Jhinjhak', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4834', 'Jhinjhana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4835', 'Jhusi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4836', 'Jhusi Kohna', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4837', 'Jiyanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4838', 'Joya', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4839', 'Jyoti Khuria', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4840', 'Jyotiba Phule Nagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4841', 'Kabrai', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4842', 'Kachhauna Patseni', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4843', 'Kachhla', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4844', 'Kachhwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4845', 'Kadaura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4846', 'Kadipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4847', 'Kailashpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4848', 'Kaimganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4849', 'Kairana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4850', 'Kakgaina', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4851', 'Kakod', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4852', 'Kakori', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4853', 'Kakrala', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4854', 'Kalinagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4855', 'Kalpi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4856', 'Kamalganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4857', 'Kampil', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4858', 'Kandhla', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4859', 'Kandwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4860', 'Kannauj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4861', 'Kanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4862', 'Kant', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4863', 'Kanth', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4864', 'Kaptanganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4865', 'Karaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4866', 'Karari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4867', 'Karhal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4868', 'Karnawal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4869', 'Kasganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4870', 'Katariya', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4871', 'Katghar Lalganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4872', 'Kathera', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4873', 'Katra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4874', 'Katra Medniganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4875', 'Kauriaganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4876', 'Kemri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4877', 'Kerakat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4878', 'Khadda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4879', 'Khaga', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4880', 'Khailar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4881', 'Khair', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4882', 'Khairabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4883', 'Khairagarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4884', 'Khalilabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4885', 'Khamaria', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4886', 'Khanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4887', 'Kharela', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4888', 'Khargupur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4889', 'Khariya', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4890', 'Kharkhoda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4891', 'Khatauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4892', 'Khatauli Rural', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4893', 'Khekra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4894', 'Kheri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4895', 'Kheta Sarai', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4896', 'Khudaganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4897', 'Khurja', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4898', 'Khutar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4899', 'Kiraoli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4900', 'Kiratpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4901', 'Kishanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4902', 'Kishni', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4903', 'Kithaur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4904', 'Koiripur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4905', 'Konch', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4906', 'Kopaganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4907', 'Kora Jahanabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4908', 'Korwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4909', 'Kosi Kalan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4910', 'Kota', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4911', 'Kotra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4912', 'Kotwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4913', 'Kulpahar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4914', 'Kunda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4915', 'Kundarki', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4916', 'Kunwargaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4917', 'Kurara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4918', 'Kurawali', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4919', 'Kursath', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4920', 'Kurthi Jafarpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4921', 'Kushinagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4922', 'Kusmara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4923', 'Laharpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4924', 'Lakhimpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4925', 'Lakhna', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4926', 'Lalganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4927', 'Lalitpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4928', 'Lar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4929', 'Lawar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4930', 'Ledwa Mahuwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4931', 'Lohta', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4932', 'Loni', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4933', 'Lucknow', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4934', 'Machhlishahr', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4935', 'Madhoganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4936', 'Madhogarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4937', 'Maghar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4938', 'Mahaban', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4939', 'Maharajganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4940', 'Mahmudabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4941', 'Mahoba', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4942', 'Maholi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4943', 'Mahona', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4944', 'Mahroni', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4945', 'Mailani', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4946', 'Mainpuri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4947', 'Majhara Pipar Ehatmali', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4948', 'Majhauli Raj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4949', 'Malihabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4950', 'Mallanwam', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4951', 'Mandawar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4952', 'Manikpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4953', 'Maniyar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4954', 'Manjhanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4955', 'Mankapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4956', 'Marehra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4957', 'Mariahu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4958', 'Maruadih', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4959', 'Maswasi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4960', 'Mataundh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4961', 'Mathu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4962', 'Mathura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4963', 'Mathura Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4964', 'Mau', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4965', 'Mau Aima', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4966', 'Maudaha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4967', 'Mauranipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4968', 'Maurawan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4969', 'Mawana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4970', 'Meerut', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4971', 'Mehnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4972', 'Mehndawal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4973', 'Mendu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4974', 'Milak', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4975', 'Miranpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4976', 'Mirat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4977', 'Mirat Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4978', 'Mirganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4979', 'Mirzapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4980', 'Misrikh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4981', 'Modinagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4982', 'Mogra Badshahpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4983', 'Mohan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4984', 'Mohanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4985', 'Mohiuddinpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4986', 'Moradabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4987', 'Moth', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4988', 'Mubarakpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4989', 'Mughal Sarai', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4990', 'Mughal Sarai Railway Settlemen', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4991', 'Muhammadabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4992', 'Muhammadi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4993', 'Mukrampur Khema', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4994', 'Mundia', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4995', 'Mundora', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4996', 'Muradnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4997', 'Mursan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4998', 'Musafirkhana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('4999', 'Muzaffarnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5000', 'Nadigaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5001', 'Nagina', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5002', 'Nagram', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5003', 'Nai Bazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5004', 'Nainana Jat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5005', 'Najibabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5006', 'Nakur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5007', 'Nanaunta', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5008', 'Nandgaon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5009', 'Nanpara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5010', 'Naraini', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5011', 'Narauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5012', 'Naraura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5013', 'Naugawan Sadat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5014', 'Nautanwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5015', 'Nawabganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5016', 'Nichlaul', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5017', 'Nidhauli Kalan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5018', 'Nihtaur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5019', 'Nindaura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5020', 'Niwari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5021', 'Nizamabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5022', 'Noida', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5023', 'Northern Railway Colony', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5024', 'Nurpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5025', 'Nyoria Husenpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5026', 'Nyotini', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5027', 'Obra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5028', 'Oel Dhakwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5029', 'Orai', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5030', 'Oran', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5031', 'Ordinance Factory Muradnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5032', 'Pachperwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5033', 'Padrauna', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5034', 'Pahasu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5035', 'Paintepur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5036', 'Pali', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5037', 'Palia Kalan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5038', 'Parasi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5039', 'Parichha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5040', 'Parichhatgarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5041', 'Parsadepur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5042', 'Patala', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5043', 'Patiyali', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5044', 'Patti', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5045', 'Pawayan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5046', 'Phalauda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5047', 'Phaphund', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5048', 'Phulpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5049', 'Phulwaria', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5050', 'Pihani', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5051', 'Pilibhit', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5052', 'Pilkana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5053', 'Pilkhuwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5054', 'Pinahat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5055', 'Pipalsana Chaudhari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5056', 'Pipiganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5057', 'Pipraich', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5058', 'Pipri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5059', 'Pratapgarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5060', 'Pukhrayan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5061', 'Puranpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5062', 'Purdil Nagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5063', 'Purqazi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5064', 'Purwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5065', 'Qasimpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5066', 'Rabupura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5067', 'Radha Kund', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5068', 'Rae Bareilly', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5069', 'Raja Ka Rampur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5070', 'Rajapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5071', 'Ramkola', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5072', 'Ramnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5073', 'Rampur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5074', 'Rampur Bhawanipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5075', 'Rampur Karkhana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5076', 'Rampur Maniharan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5077', 'Rampura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5078', 'Ranipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5079', 'Rashidpur Garhi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5080', 'Rasra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5081', 'Rasulabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5082', 'Rath', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5083', 'Raya', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5084', 'Renukut', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5085', 'Reoti', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5086', 'Richha', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5087', 'Risia Bazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5088', 'Rithora', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5089', 'Robertsganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5090', 'Roza', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5091', 'Rudarpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5092', 'Rudauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5093', 'Rudayan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5094', 'Rura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5095', 'Rustamnagar Sahaspur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5096', 'Sabatwar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5097', 'Sadabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5098', 'Sadat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5099', 'Safipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5100', 'Sahanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5101', 'Saharanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5102', 'Sahaspur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5103', 'Sahaswan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5104', 'Sahawar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5105', 'Sahibabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5106', 'Sahjanwa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5107', 'Sahpau', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5108', 'Saidpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5109', 'Sainthal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5110', 'Saiyadraja', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5111', 'Sakhanu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5112', 'Sakit', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5113', 'Salarpur Khadar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5114', 'Salimpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5115', 'Salon', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5116', 'Sambhal', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5117', 'Sambhawali', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5118', 'Samdhan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5119', 'Samthar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5120', 'Sandi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5121', 'Sandila', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5122', 'Sarai Mir', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5123', 'Sarai akil', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5124', 'Sarauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5125', 'Sardhana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5126', 'Sarila', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5127', 'Sarsawan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5128', 'Sasni', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5129', 'Satrikh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5130', 'Saunkh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5131', 'Saurikh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5132', 'Seohara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5133', 'Sewal Khas', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5134', 'Sewarhi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5135', 'Shahabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5136', 'Shahganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5137', 'Shahi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5138', 'Shahjahanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5139', 'Shahjahanpur Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5140', 'Shahpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5141', 'Shamli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5142', 'Shamsabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5143', 'Shankargarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5144', 'Shergarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5145', 'Sherkot', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5146', 'Shikarpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5147', 'Shikohabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5148', 'Shisgarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5149', 'Shivdaspur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5150', 'Shivli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5151', 'Shivrajpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5152', 'Shohratgarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5153', 'Siddhanur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5154', 'Siddharthnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5155', 'Sidhauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5156', 'Sidhpura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5157', 'Sikandarabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5158', 'Sikandarpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5159', 'Sikandra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5160', 'Sikandra Rao', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5161', 'Singahi Bhiraura', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5162', 'Sirathu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5163', 'Sirsa', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5164', 'Sirsaganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5165', 'Sirsi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5166', 'Sisauli', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5167', 'Siswa Bazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5168', 'Sitapur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5169', 'Siyana', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5170', 'Som', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5171', 'Sonbhadra', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5172', 'Soron', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5173', 'Suar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5174', 'Sukhmalpur Nizamabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5175', 'Sultanpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5176', 'Sumerpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5177', 'Suriyawan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5178', 'Swamibagh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5179', 'Tajpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5180', 'Talbahat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5181', 'Talgram', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5182', 'Tambaur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5183', 'Tanda', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5184', 'Tatarpur Lallu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5185', 'Tetribazar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5186', 'Thakurdwara', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5187', 'Thana Bhawan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5188', 'Thiriya Nizamat Khan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5189', 'Tikaitnagar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5190', 'Tikri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5191', 'Tilhar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5192', 'Tindwari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5193', 'Tirwaganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5194', 'Titron', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5195', 'Tori Fatehpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5196', 'Tulsipur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5197', 'Tundla', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5198', 'Tundla Kham', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5199', 'Tundla Railway Colony', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5200', 'Ugu', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5201', 'Ujhani', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5202', 'Ujhari', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5203', 'Umri', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5204', 'Umri Kalan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5205', 'Un', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5206', 'Unchahar', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5207', 'Unnao', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5208', 'Usaihat', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5209', 'Usawan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5210', 'Utraula', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5211', 'Varanasi', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5212', 'Varanasi Cantonment', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5213', 'Vijaigarh', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5214', 'Vrindavan', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5215', 'Wazirganj', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5216', 'Zafarabad', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5217', 'Zaidpur', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5218', 'Zamania', '38');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5219', 'Almora', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5220', 'Almora Cantonment', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5221', 'Badrinathpuri', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5222', 'Bageshwar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5223', 'Bah Bazar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5224', 'Banbasa', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5225', 'Bandia', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5226', 'Barkot', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5227', 'Bazpur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5228', 'Bhim Tal', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5229', 'Bhowali', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5230', 'Chakrata', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5231', 'Chamba', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5232', 'Chamoli and Gopeshwar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5233', 'Champawat', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5234', 'Clement Town', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5235', 'Dehra Dun Cantonment', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5236', 'Dehradun', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5237', 'Dehrakhas', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5238', 'Devaprayag', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5239', 'Dhaluwala', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5240', 'Dhandera', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5241', 'Dharchula', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5242', 'Dharchula Dehat', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5243', 'Didihat', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5244', 'Dineshpur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5245', 'Doiwala', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5246', 'Dugadda', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5247', 'Dwarahat', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5248', 'Gadarpur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5249', 'Gangotri', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5250', 'Gauchar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5251', 'Haldwani', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5252', 'Haridwar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5253', 'Herbertpur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5254', 'Jaspur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5255', 'Jhabrera', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5256', 'Joshimath', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5257', 'Kachnal Gosain', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5258', 'Kaladungi', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5259', 'Kalagarh', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5260', 'Karnaprayang', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5261', 'Kashipur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5262', 'Kashirampur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5263', 'Kausani', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5264', 'Kedarnath', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5265', 'Kelakhera', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5266', 'Khatima', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5267', 'Kichha', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5268', 'Kirtinagar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5269', 'Kotdwara', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5270', 'Laksar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5271', 'Lalkuan', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5272', 'Landaura', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5273', 'Landhaura Cantonment', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5274', 'Lensdaun', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5275', 'Logahat', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5276', 'Mahua Dabra Haripura', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5277', 'Mahua Kheraganj', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5278', 'Manglaur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5279', 'Masuri', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5280', 'Mohanpur Mohammadpur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5281', 'Muni Ki Reti', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5282', 'Nagla', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5283', 'Nainital', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5284', 'Nainital Cantonment', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5285', 'Nandaprayang', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5286', 'Narendranagar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5287', 'Pauri', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5288', 'Pithoragarh', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5289', 'Pratitnagar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5290', 'Raipur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5291', 'Raiwala', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5292', 'Ramnagar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5293', 'Ranikhet', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5294', 'Ranipur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5295', 'Rishikesh', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5296', 'Rishikesh Cantonment', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5297', 'Roorkee', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5298', 'Rudraprayag', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5299', 'Rudrapur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5300', 'Rurki', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5301', 'Rurki Cantonment', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5302', 'Shaktigarh', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5303', 'Sitarganj', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5304', 'Srinagar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5305', 'Sultanpur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5306', 'Tanakpur', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5307', 'Tehri', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5308', 'Udham Singh Nagar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5309', 'Uttarkashi', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5310', 'Vikasnagar', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5311', 'Virbhadra', '39');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5312', '24 Parganas (n)', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5313', '24 Parganas (s)', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5314', 'Adra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5315', 'Ahmadpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5316', 'Aiho', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5317', 'Aistala', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5318', 'Alipur Duar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5319', 'Alipur Duar Railway Junction', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5320', 'Alpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5321', 'Amalhara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5322', 'Amkula', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5323', 'Amlagora', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5324', 'Amodghata', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5325', 'Amtala', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5326', 'Andul', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5327', 'Anksa', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5328', 'Ankurhati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5329', 'Anup Nagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5330', 'Arambagh', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5331', 'Argari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5332', 'Arsha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5333', 'Asansol', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5334', 'Ashoknagar Kalyangarh', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5335', 'Aurangabad', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5336', 'Bablari Dewanganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5337', 'Badhagachhi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5338', 'Baduria', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5339', 'Baghdogra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5340', 'Bagnan', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5341', 'Bagra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5342', 'Bagula', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5343', 'Baharampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5344', 'Bahirgram', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5345', 'Bahula', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5346', 'Baidyabati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5347', 'Bairatisal', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5348', 'Baj Baj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5349', 'Bakreswar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5350', 'Balaram Pota', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5351', 'Balarampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5352', 'Bali Chak', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5353', 'Ballavpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5354', 'Bally', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5355', 'Balurghat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5356', 'Bamunari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5357', 'Banarhat Tea Garden', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5358', 'Bandel', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5359', 'Bangaon', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5360', 'Bankra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5361', 'Bankura', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5362', 'Bansbaria', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5363', 'Banshra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5364', 'Banupur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5365', 'Bara Bamonia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5366', 'Barakpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5367', 'Barakpur Cantonment', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5368', 'Baranagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5369', 'Barasat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5370', 'Barddhaman', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5371', 'Barijhati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5372', 'Barjora', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5373', 'Barrackpore', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5374', 'Baruihuda', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5375', 'Baruipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5376', 'Barunda', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5377', 'Basirhat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5378', 'Baska', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5379', 'Begampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5380', 'Beldanga', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5381', 'Beldubi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5382', 'Belebathan', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5383', 'Beliator', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5384', 'Bhadreswar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5385', 'Bhandardaha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5386', 'Bhangar Raghunathpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5387', 'Bhangri Pratham Khanda', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5388', 'Bhanowara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5389', 'Bhatpara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5390', 'Bholar Dabri', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5391', 'Bidhannagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5392', 'Bidyadharpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5393', 'Biki Hakola', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5394', 'Bilandapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5395', 'Bilpahari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5396', 'Bipra Noapara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5397', 'Birlapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5398', 'Birnagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5399', 'Bisarpara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5400', 'Bishnupur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5401', 'Bolpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5402', 'Bongaon', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5403', 'Bowali', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5404', 'Burdwan', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5405', 'Canning', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5406', 'Cart Road', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5407', 'Chachanda', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5408', 'Chak Bankola', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5409', 'Chak Enayetnagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5410', 'Chak Kashipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5411', 'Chakalampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5412', 'Chakbansberia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5413', 'Chakdaha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5414', 'Chakpara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5415', 'Champahati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5416', 'Champdani', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5417', 'Chamrail', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5418', 'Chandannagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5419', 'Chandpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5420', 'Chandrakona', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5421', 'Chapari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5422', 'Chapui', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5423', 'Char Brahmanagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5424', 'Char Maijdia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5425', 'Charka', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5426', 'Chata Kalikapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5427', 'Chauhati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5428', 'Checha Khata', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5429', 'Chelad', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5430', 'Chhora', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5431', 'Chikrand', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5432', 'Chittaranjan', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5433', 'Contai', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5434', 'Cooch Behar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5435', 'Dainhat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5436', 'Dakshin Baguan', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5437', 'Dakshin Jhapardaha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5438', 'Dakshin Rajyadharpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5439', 'Dakshin Raypur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5440', 'Dalkola', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5441', 'Dalurband', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5442', 'Darap Pur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5443', 'Darjiling', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5444', 'Daulatpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5445', 'Debipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5446', 'Defahat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5447', 'Deora', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5448', 'Deulia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5449', 'Dhakuria', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5450', 'Dhandadihi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5451', 'Dhanyakuria', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5452', 'Dharmapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5453', 'Dhatri Gram', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5454', 'Dhuilya', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5455', 'Dhulagari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5456', 'Dhulian', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5457', 'Dhupgari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5458', 'Dhusaripara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5459', 'Diamond Harbour', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5460', 'Digha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5461', 'Dignala', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5462', 'Dinhata', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5463', 'Dubrajpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5464', 'Dumjor', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5465', 'Durgapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5466', 'Durllabhganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5467', 'Egra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5468', 'Eksara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5469', 'Falakata', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5470', 'Farakka', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5471', 'Fatellapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5472', 'Fort Gloster', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5473', 'Gabberia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5474', 'Gadigachha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5475', 'Gairkata', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5476', 'Gangarampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5477', 'Garalgachha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5478', 'Garbeta Amlagora', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5479', 'Garhbeta', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5480', 'Garshyamnagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5481', 'Garui', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5482', 'Garulia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5483', 'Gayespur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5484', 'Ghatal', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5485', 'Ghorsala', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5486', 'Goaljan', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5487', 'Goasafat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5488', 'Gobardanga', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5489', 'Gobindapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5490', 'Gopalpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5491', 'Gopinathpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5492', 'Gora Bazar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5493', 'Guma', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5494', 'Gurdaha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5495', 'Guriahati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5496', 'Guskhara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5497', 'Habra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5498', 'Haldia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5499', 'Haldibari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5500', 'Halisahar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5501', 'Haora', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5502', 'Harharia Chak', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5503', 'Harindanga', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5504', 'Haringhata', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5505', 'Haripur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5506', 'Harishpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5507', 'Hatgachha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5508', 'Hatsimla', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5509', 'Hijuli', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5510', 'Hindustan Cables Town', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5511', 'Hooghly', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5512', 'Howrah', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5513', 'Hugli-Chunchura', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5514', 'Humaipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5515', 'Ichha Pur Defence Estate', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5516', 'Ingraj Bazar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5517', 'Islampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5518', 'Jafarpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5519', 'Jagadanandapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5520', 'Jagdishpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5521', 'Jagtaj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5522', 'Jala Kendua', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5523', 'Jaldhaka', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5524', 'Jalkhura', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5525', 'Jalpaiguri', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5526', 'Jamuria', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5527', 'Jangipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5528', 'Jaygaon', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5529', 'Jaynagar-Majilpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5530', 'Jemari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5531', 'Jemari Township', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5532', 'Jetia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5533', 'Jhalida', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5534', 'Jhargram', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5535', 'Jhorhat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5536', 'Jiaganj-Azimganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5537', 'Joka', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5538', 'Jot Kamal', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5539', 'Kachu Pukur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5540', 'Kajora', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5541', 'Kakdihi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5542', 'Kakdwip', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5543', 'Kalaikunda', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5544', 'Kalara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5545', 'Kalimpong', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5546', 'Kaliyaganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5547', 'Kalna', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5548', 'Kalyani', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5549', 'Kamarhati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5550', 'Kanaipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5551', 'Kanchrapara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5552', 'Kandi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5553', 'Kanki', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5554', 'Kankuria', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5555', 'Kantlia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5556', 'Kanyanagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5557', 'Karimpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5558', 'Karsiyang', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5559', 'Kasba', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5560', 'Kasimbazar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5561', 'Katwa', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5562', 'Kaugachhi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5563', 'Kenda', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5564', 'Kendra Khottamdi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5565', 'Kendua', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5566', 'Kesabpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5567', 'Khagrabari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5568', 'Khalia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5569', 'Khalor', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5570', 'Khandra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5571', 'Khantora', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5572', 'Kharagpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5573', 'Kharagpur Railway Settlement', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5574', 'Kharar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5575', 'Khardaha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5576', 'Khari Mala Khagrabari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5577', 'Kharsarai', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5578', 'Khatra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5579', 'Khodarampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5580', 'Kodalia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5581', 'Kolaghat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5582', 'Kolaghat Thermal Power Project', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5583', 'Kolkata', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5584', 'Konardihi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5585', 'Konnogar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5586', 'Krishnanagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5587', 'Krishnapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5588', 'Kshidirpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5589', 'Kshirpai', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5590', 'Kulihanda', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5591', 'Kulti', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5592', 'Kunustara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5593', 'Kuperskem', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5594', 'Madanpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5595', 'Madhusudanpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5596', 'Madhyamgram', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5597', 'Maheshtala', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5598', 'Mahiari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5599', 'Mahikpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5600', 'Mahira', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5601', 'Mahishadal', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5602', 'Mainaguri', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5603', 'Makardaha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5604', 'Mal', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5605', 'Malda', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5606', 'Mandarbani', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5607', 'Mansinhapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5608', 'Masila', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5609', 'Maslandapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5610', 'Mathabhanga', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5611', 'Mekliganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5612', 'Memari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5613', 'Midnapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5614', 'Mirik', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5615', 'Monoharpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5616', 'Mrigala', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5617', 'Muragachha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5618', 'Murgathaul', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5619', 'Murshidabad', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5620', 'Nabadhai Dutta Pukur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5621', 'Nabagram', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5622', 'Nabgram', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5623', 'Nachhratpur Katabari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5624', 'Nadia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5625', 'Naihati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5626', 'Nalhati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5627', 'Nasra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5628', 'Natibpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5629', 'Naupala', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5630', 'Navadwip', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5631', 'Nebadhai Duttapukur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5632', 'New Barrackpore', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5633', 'Ni Barakpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5634', 'Nibra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5635', 'Noapara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5636', 'Nokpul', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5637', 'North Barakpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5638', 'Odlabari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5639', 'Old Maldah', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5640', 'Ondal', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5641', 'Pairagachha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5642', 'Palashban', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5643', 'Panchla', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5644', 'Panchpara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5645', 'Pandua', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5646', 'Pangachhiya', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5647', 'Paniara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5648', 'Panihati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5649', 'Panuhat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5650', 'Par Beliya', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5651', 'Parashkol', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5652', 'Parasia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5653', 'Parbbatipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5654', 'Parui', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5655', 'Paschim Jitpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5656', 'Paschim Punro Para', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5657', 'Patrasaer', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5658', 'Pattabong Tea Garden', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5659', 'Patuli', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5660', 'Patulia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5661', 'Phulia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5662', 'Podara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5663', 'Port Blair', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5664', 'Prayagpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5665', 'Pujali', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5666', 'Purba Medinipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5667', 'Purba Tajpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5668', 'Purulia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5669', 'Raghudebbati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5670', 'Raghudebpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5671', 'Raghunathchak', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5672', 'Raghunathpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5673', 'Raghunathpur-Dankuni', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5674', 'Raghunathpur-Magra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5675', 'Raigachhi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5676', 'Raiganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5677', 'Raipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5678', 'Rajarhat Gopalpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5679', 'Rajpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5680', 'Ramchandrapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5681', 'Ramjibanpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5682', 'Ramnagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5683', 'Rampur Hat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5684', 'Ranaghat', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5685', 'Raniganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5686', 'Ratibati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5687', 'Raypur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5688', 'Rishra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5689', 'Rishra Cantonment', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5690', 'Ruiya', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5691', 'Sahajadpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5692', 'Sahapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5693', 'Sainthia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5694', 'Salap', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5695', 'Sankarpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5696', 'Sankrail', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5697', 'Santoshpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5698', 'Saontaidih', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5699', 'Sarenga', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5700', 'Sarpi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5701', 'Satigachha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5702', 'Serpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5703', 'Shankhanagar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5704', 'Shantipur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5705', 'Shrirampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5706', 'Siduli', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5707', 'Siliguri', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5708', 'Simla', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5709', 'Singur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5710', 'Sirsha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5711', 'Siuri', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5712', 'Sobhaganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5713', 'Sodpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5714', 'Sonamukhi', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5715', 'Sonatikiri', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5716', 'Srikantabati', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5717', 'Srirampur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5718', 'Sukdal', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5719', 'Taherpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5720', 'Taki', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5721', 'Talbandha', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5722', 'Tamluk', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5723', 'Tarakeswar', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5724', 'Tentulberia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5725', 'Tentulkuli', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5726', 'Thermal Power Project', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5727', 'Tinsukia', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5728', 'Titagarh', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5729', 'Tufanganj', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5730', 'Ukhra', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5731', 'Ula', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5732', 'Ulubaria', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5733', 'Uttar Durgapur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5734', 'Uttar Goara', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5735', 'Uttar Kalas', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5736', 'Uttar Kamakhyaguri', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5737', 'Uttar Latabari', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5738', 'Uttar Mahammadpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5739', 'Uttar Pirpur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5740', 'Uttar Raypur', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5741', 'Uttarpara-Kotrung', '41');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5742', 'Abohar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5743', 'Adampur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5744', 'Ahmedgarh', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5745', 'Ajnala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5746', 'Akalgarh', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5747', 'Alawalpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5748', 'Amloh', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5749', 'Amritsar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5750', 'Amritsar Cantonment', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5751', 'Anandpur Sahib', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5752', 'Badhni Kalan', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5753', 'Bagh Purana', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5754', 'Balachaur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5755', 'Banaur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5756', 'Banga', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5757', 'Banur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5758', 'Baretta', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5759', 'Bariwala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5760', 'Barnala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5761', 'Bassi Pathana', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5762', 'Batala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5763', 'Bathinda', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5764', 'Begowal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5765', 'Behrampur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5766', 'Bhabat', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5767', 'Bhadur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5768', 'Bhankharpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5769', 'Bharoli Kalan', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5770', 'Bhawanigarh', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5771', 'Bhikhi', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5772', 'Bhikhiwind', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5773', 'Bhisiana', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5774', 'Bhogpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5775', 'Bhuch', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5776', 'Bhulath', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5777', 'Budha Theh', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5778', 'Budhlada', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5779', 'Chima', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5780', 'Chohal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5781', 'Dasuya', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5782', 'Daulatpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5783', 'Dera Baba Nanak', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5784', 'Dera Bassi', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5785', 'Dhanaula', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5786', 'Dharam Kot', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5787', 'Dhariwal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5788', 'Dhilwan', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5789', 'Dhuri', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5790', 'Dinanagar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5791', 'Dirba', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5792', 'Doraha', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5793', 'Faridkot', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5794', 'Fateh Nangal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5795', 'Fatehgarh Churian', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5796', 'Fatehgarh Sahib', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5797', 'Fazilka', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5798', 'Firozpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5799', 'Firozpur Cantonment', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5800', 'Gardhiwala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5801', 'Garhshankar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5802', 'Ghagga', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5803', 'Ghanaur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5804', 'Giddarbaha', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5805', 'Gobindgarh', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5806', 'Goniana', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5807', 'Goraya', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5808', 'Gurdaspur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5809', 'Guru Har Sahai', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5810', 'Hajipur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5811', 'Handiaya', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5812', 'Hariana', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5813', 'Hoshiarpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5814', 'Hussainpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5815', 'Jagraon', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5816', 'Jaitu', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5817', 'Jalalabad', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5818', 'Jalandhar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5819', 'Jalandhar Cantonment', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5820', 'Jandiala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5821', 'Jugial', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5822', 'Kalanaur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5823', 'Kapurthala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5824', 'Karoran', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5825', 'Kartarpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5826', 'Khamanon', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5827', 'Khanauri', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5828', 'Khanna', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5829', 'Kharar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5830', 'Khem Karan', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5831', 'Kot Fatta', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5832', 'Kot Isa Khan', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5833', 'Kot Kapura', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5834', 'Kotkapura', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5835', 'Kurali', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5836', 'Lalru', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5837', 'Lehra Gaga', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5838', 'Lodhian Khas', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5839', 'Longowal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5840', 'Ludhiana', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5841', 'Machhiwara', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5842', 'Mahilpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5843', 'Majitha', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5844', 'Makhu', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5845', 'Malaut', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5846', 'Malerkotla', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5847', 'Maloud', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5848', 'Mandi Gobindgarh', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5849', 'Mansa', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5850', 'Maur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5851', 'Moga', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5852', 'Mohali', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5853', 'Moonak', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5854', 'Morinda', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5855', 'Mukerian', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5856', 'Muktsar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5857', 'Mullanpur Dakha', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5858', 'Mullanpur Garibdas', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5859', 'Munak', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5860', 'Muradpura', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5861', 'Nabha', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5862', 'Nakodar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5863', 'Nangal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5864', 'Nawashahr', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5865', 'Naya Nangal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5866', 'Nehon', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5867', 'Nurmahal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5868', 'Pathankot', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5869', 'Patiala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5870', 'Patti', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5871', 'Pattran', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5872', 'Payal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5873', 'Phagwara', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5874', 'Phillaur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5875', 'Qadian', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5876', 'Rahon', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5877', 'Raikot', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5878', 'Raja Sansi', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5879', 'Rajpura', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5880', 'Ram Das', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5881', 'Raman', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5882', 'Rampura', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5883', 'Rayya', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5884', 'Rupnagar', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5885', 'Rurki Kasba', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5886', 'Sahnewal', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5887', 'Samana', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5888', 'Samrala', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5889', 'Sanaur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5890', 'Sangat', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5891', 'Sangrur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5892', 'Sansarpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5893', 'Sardulgarh', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5894', 'Shahkot', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5895', 'Sham Churasi', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5896', 'Shekhpura', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5897', 'Sirhind', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5898', 'Sri Hargobindpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5899', 'Sujanpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5900', 'Sultanpur Lodhi', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5901', 'Sunam', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5902', 'Talwandi Bhai', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5903', 'Talwara', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5904', 'Tappa', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5905', 'Tarn Taran', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5906', 'Urmar Tanda', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5907', 'Zira', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5908', 'Zirakpur', '2728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5909', 'Eshkashem', '42');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5910', 'Fayzabad', '42');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5911', 'Jurm', '42');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5912', 'Khandud', '42');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5913', 'Qal\'eh-ye Panjeh', '42');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5914', 'Bala Morghab', '43');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5915', 'Qal\'eh-ye Naw', '43');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5916', 'Andarab', '44');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5917', 'Baghlan', '44');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5918', 'Dahaneh-ye Ghawri', '44');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5919', 'Nahrin', '44');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5920', 'Pol-e Khumri', '44');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5921', 'Balkh', '45');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5922', 'Dawlatabad', '45');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5923', 'Mazar-e Sharif', '45');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5924', 'Qarchi Gak', '45');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5925', 'Shulgara', '45');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5926', 'Tash Gozar', '45');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5927', 'Bamiyan', '46');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5928', 'Panjab', '46');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5929', 'Qil Qal\'eh', '46');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5930', 'Anar Darreh', '47');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5931', 'Farah', '47');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5932', 'Shindand', '47');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5933', 'Andkhvoy', '48');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5934', 'Darzi Ab', '48');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5935', 'Dawlatabad', '48');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5936', 'Maymanah', '48');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5937', 'Chaghcharan', '49');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5938', 'Shahrak', '49');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5939', 'Taywarah', '49');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5940', 'Ghazni', '50');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5941', 'Awbeh', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5942', 'Eslam Qal\'eh', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5943', 'Ghurian', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5944', 'Herat', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5945', 'Karukh', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5946', 'Kuhestan', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5947', 'Kushk', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5948', 'Qarabagh', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5949', 'Tawraghudi', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5950', 'Tir Pol', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5951', 'Zendejan', '51');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5952', 'Baghran', '52');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5953', 'Darwishan', '52');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5954', 'Deh Shu', '52');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5955', 'Gereshk', '52');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5956', 'Lashkar Gah', '52');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5957', 'Sangin', '52');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5958', 'Aqchah', '53');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5959', 'Qarqin', '53');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5960', 'Sang-e Charak', '53');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5961', 'Shibarghan', '53');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5962', 'Baghrami', '54');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5963', 'Kabul', '54');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5964', 'Mir Bachchekut', '54');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5965', 'Paghman', '54');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5966', 'Qarabagh', '54');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5967', 'Sarawbi', '54');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5968', 'Mahmud-e Raqi', '55');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5969', 'Taghab', '55');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5970', 'Khawst', '56');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5971', 'Asadabad', '57');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5972', 'Asmar', '57');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5973', 'Mehtar Lam', '58');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5974', 'Azraw', '59');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5975', 'Baraki Barak', '59');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5976', 'Pol-e Alam', '59');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5977', 'Achin', '60');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5978', 'Batsawul', '60');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5979', 'Hugyani', '60');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5980', 'Jalalabad', '60');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5981', 'Nader Shah Kawt', '60');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5982', 'Chahar Burjak', '61');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5983', 'Chakhansur', '61');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5984', 'Khash', '61');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5985', 'Mirabad', '61');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5986', 'Rudbar', '61');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5987', 'Zaranj', '61');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5988', 'Nuristan', '62');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5989', 'Orgun', '63');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5990', 'Zareh Sharan', '63');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5991', 'Zarghun Shahr', '63');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5992', '\'Ali Khayl', '64');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5993', 'Ghardez', '64');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5994', 'Charikar', '65');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5995', 'Jabal-os-Saraj', '65');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5996', 'Qandahar', '66');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5997', 'Dasht-e Archa', '67');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5998', 'Emam Saheb', '67');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('5999', 'Hazart Imam', '67');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6000', 'Khanabad', '67');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6001', 'Qal\'eh-ye Zal', '67');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6002', 'Qunduz', '67');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6003', 'Aybak', '68');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6004', 'Kholm', '68');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6005', 'Chah Ab', '70');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6006', 'Eshkamesh', '70');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6007', 'Farkhar', '70');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6008', 'Khwajeh Ghar', '70');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6009', 'Rostaq', '70');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6010', 'Taloqan', '70');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6011', 'Yangi Qal\'eh', '70');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6012', 'Deh Rawud', '71');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6013', 'Gaz Ab', '71');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6014', 'Tarin Kawt', '71');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6015', 'Uruzgan', '71');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6016', 'Gardan Diwal', '72');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6017', 'Maydanshahr', '72');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6018', 'Qalat-e Ghilzay', '73');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6019', 'Berat', '74');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6020', 'Polican', '74');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6021', 'Ure Vajgurore', '74');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6022', 'Bulqize', '75');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6023', 'Delvine', '76');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6024', 'Bilisht', '77');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6025', 'Maqellare', '78');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6026', 'Peshkopi', '78');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6027', 'Durres', '79');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6028', 'Shijak', '79');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6029', 'Cerrik', '80');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6030', 'Elbasan', '80');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6031', 'Kerrabe', '80');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6032', 'Fier', '81');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6033', 'Patos', '81');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6034', 'Roskovec', '81');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6035', 'Gjirokaster', '82');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6036', 'Libohove', '82');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6037', 'Gramsh', '83');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6038', 'Krume', '84');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6039', 'Kavaje', '85');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6040', 'Erseke', '86');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6041', 'Leskovik', '86');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6042', 'Korce', '87');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6043', 'Maliq', '87');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6044', 'Fushe-Kruje', '88');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6045', 'Kruje', '88');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6046', 'Mamurras', '88');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6047', 'Milot', '88');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6048', 'Kucove', '89');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6049', 'Kukes', '90');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6050', 'Lac', '91');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6051', 'Lezhe', '92');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6052', 'Shengjin', '92');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6053', 'Librazhd', '93');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6054', 'Perrenjas', '93');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6055', 'Lushnje', '94');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6056', 'Rrogozhine', '94');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6057', 'Ballsh', '95');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6058', 'Burrel', '97');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6059', 'Klos', '97');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6060', 'Kraste', '97');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6061', 'Ulze', '97');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6062', 'Kurbnesh', '98');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6063', 'Rreshen', '98');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6064', 'Rubik', '98');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6065', 'Peqin', '99');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6066', 'Kelcyre', '100');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6067', 'Permet', '100');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6068', 'Pogradec', '101');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6069', 'Fierze', '102');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6070', 'Fushe-Arrez', '102');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6071', 'Puke', '102');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6072', 'Konispol', '103');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6073', 'Sarande', '103');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6074', 'Shkoder', '104');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6075', 'Corovode', '105');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6076', 'Memaliaj', '106');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6077', 'Tepelene', '106');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6078', 'Kamze', '107');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6079', 'Paskuqan', '107');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6080', 'Tirane', '107');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6081', 'Vore', '107');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6082', 'Bajram Curri', '108');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6083', 'Himare', '109');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6084', 'Orikum', '109');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6085', 'Selenice', '109');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6086', 'Vlore', '109');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6087', 'Adrar', '112');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6088', 'Awlaf', '112');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6089', 'Rijan', '112');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6090', 'Timimun', '112');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6091', 'Hydra', '113');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6092', 'Kouba', '113');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6093', 'Annabah', '114');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6094', 'Birrahhal', '114');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6095', 'Saraydih', '114');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6096', 'Sidi Amar', '114');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6097', 'al-Buni', '114');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6098', 'al-Hajar', '114');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6099', '\'Abadlah', '115');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6100', 'Bani Wanif', '115');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6101', 'Bashshar', '115');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6102', 'Qanadsan', '115');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6103', 'Taghit', '115');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6104', '\'Aris', '116');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6105', '\'Ayn Tutah', '116');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6106', 'Barikah', '116');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6107', 'Batnah', '116');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6108', 'Marwanah', '116');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6109', 'Naghaus', '116');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6110', 'Ra\'s-al-\'Ayun', '116');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6111', 'Tazult', '116');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6112', '\'Ayt Rizin', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6113', 'Akbu', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6114', 'Amizur', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6115', 'Barbasha', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6116', 'Bijayah', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6117', 'Farrawn', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6118', 'Ighram', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6119', 'Sadduk', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6120', 'Shamini', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6121', 'Sidi \'Aysh', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6122', 'Taskaryut', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6123', 'Tazmalt', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6124', 'Timazrit', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6125', 'Uz-al-Laqin', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6126', 'al-Qasr', '117');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6127', 'Awlad Jallal', '118');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6128', 'Biskrah', '118');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6129', 'Sidi Khalid', '118');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6130', 'Sidi Ukbah', '118');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6131', 'Tulja', '118');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6132', 'Um\'ash', '118');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6133', 'Zaribat-al-Wad', '118');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6134', 'Awlad Salam', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6135', 'Awlad Yaysh', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6136', 'Bani Khalil', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6137', 'Bani Marad', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6138', 'Bani Tamu', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6139', 'Blidah', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6140', 'Bu Arfa', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6141', 'Bufarik', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6142', 'Buinan', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6143', 'Buqara', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6144', 'Maftah', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6145', 'Muzayah', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6146', 'Shabli', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6147', 'Shari\'ah', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6148', 'Shiffa', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6149', 'Sidi Mussa', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6150', 'Suma', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6151', 'Wadi al-Allagh', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6152', 'al-\'Afrun', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6153', 'al-Arba\'a', '119');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6154', '\'Ayn Bissim', '120');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6155', 'Aghbalu', '120');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6156', 'Bi\'r Ghabalu', '120');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6157', 'Buirah', '120');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6158', 'Lakhdariyah', '120');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6159', 'Shurfa', '120');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6160', 'Sur-al-Ghuzlan', '120');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6161', '\'Ayn Tayah', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6162', 'Awlad Haddaj', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6163', 'Awlad Mussa', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6164', 'Bani Amran', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6165', 'Budwawu', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6166', 'Budwawu al-Bahri', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6167', 'Bumardas', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6168', 'Burj Minayal', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6169', 'Dalis', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6170', 'Hammadi', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6171', 'Issar', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6172', 'Khamis-al-Khashnah', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6173', 'Nasiriyah', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6174', 'Raghayah', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6175', 'Sa\'abat', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6176', 'Tinyah', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6177', 'al-Arba\'a Tash', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6178', 'ar-Ruwibah', '121');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6179', 'Ammi Mussa', '123');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6180', 'Ghalizan', '123');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6181', 'Jidiwiyah', '123');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6182', 'Mazunah', '123');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6183', 'Sidi Muhammad Ban \'Ali', '123');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6184', 'Wadi Rahiyu', '123');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6185', 'Zammurah', '123');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6186', 'Biryan', '124');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6187', 'Bu Nura', '124');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6188', 'Ghardaia', '124');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6189', 'Ghardayah', '124');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6190', 'Matlili', '124');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6191', 'al-Ghuli\'ah', '124');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6192', 'al-Qararah', '124');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6193', 'Ilizi', '125');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6194', 'Amir \'Abd-al-Qadar', '126');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6195', 'Jijili', '126');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6196', 'Shifka', '126');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6197', 'Tahar', '126');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6198', 'al-Miliyah', '126');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6199', '\'Ayn Wissarah', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6200', '\'Ayn-al-Ibil', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6201', 'Birin', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6202', 'Dar Shiyukh', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6203', 'Hassi Bahbah', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6204', 'Jilfah', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6205', 'Mis\'ad', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6206', 'Sharif', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6207', 'al-Idrisiyah', '127');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6208', 'Khanshalah', '128');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6209', 'Sharshar', '128');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6210', 'Tawziyanat', '128');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6211', 'al-Mahmal', '128');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6212', '\'Ayn-al-Hajal', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6213', '\'Ayn-al-Milh', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6214', 'Bu Sa\'adah', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6215', 'Hammam Dhala\'a', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6216', 'Ma\'adid', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6217', 'Maghra', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6218', 'Masilah', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6219', 'Sidi \'Aysa', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6220', 'Wanugha', '129');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6221', '\'Ayn Bu Sif', '130');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6222', 'Birwaghiyah', '130');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6223', 'Midyah', '130');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6224', 'Qasr-al-Bukhari', '130');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6225', 'Shillalah', '130');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6226', 'Tablat', '130');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6227', 'Farjiwah', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6228', 'Milah', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6229', 'Qararam Quqa', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6230', 'Ruwashad', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6231', 'Salghum-al-\'Ayd', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6232', 'Sidi Maruf', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6233', 'Sidi Marwan', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6234', 'Tajananah', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6235', 'Talighmah', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6236', 'Wadi Athmaniyah', '131');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6237', 'Bu Khanifiyah', '132');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6238', 'Muaskar', '132');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6239', 'Muhammadiyah', '132');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6240', 'Siq', '132');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6241', 'Tighinnif', '132');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6242', 'Wadi al-Abtal', '132');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6243', 'Zahana', '132');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6244', '\'Ayn Tadalas', '133');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6245', 'Hassi Mamash', '133');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6246', 'Mazaghran', '133');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6247', 'Mustaghanam', '133');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6248', 'Sidi Ali', '133');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6249', '\'Ayn Safra', '134');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6250', 'Mishriyah', '134');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6251', 'Naama', '134');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6252', 'Oran', '135');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6253', 'Ouargla', '136');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6254', '\'Ayn Bardah', '137');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6255', 'Bumahra Ahmad', '137');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6256', 'Hamman Awlad \'Ali', '137');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6257', 'Qalmah', '137');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6258', 'Wadi Zinati', '137');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6259', '\'Ayn Abid', '138');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6260', '\'Ayn Samara', '138');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6261', 'Didush Murad', '138');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6262', 'Hamma Bu Ziyan', '138');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6263', 'Qustantinah', '138');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6264', 'Zighut Yusuf', '138');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6265', 'al-Khurub', '138');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6266', '\'Azzabah', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6267', 'Amjaz Adshish', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6268', 'Fil Fila', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6269', 'Karkira', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6270', 'Ramadan Jamal', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6271', 'Sakikdah', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6272', 'Shataybih', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6273', 'Tamalus', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6274', 'al-Harush', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6275', 'al-Qull', '139');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6276', '\'Ayn \'Azl', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6277', '\'Ayn Arnat', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6278', '\'Ayn Taqrut', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6279', '\'Ayn Wilman', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6280', '\'Ayn-al-Khabira', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6281', 'Bouira', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6282', 'Buq\'ah', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6283', 'Salah Bay', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6284', 'Satif', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6285', 'Setif', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6286', 'Ziyama Mansuriyah', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6287', 'al-\'Ulmah', '140');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6288', '\'Ayn-al-Hajar', '141');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6289', 'Sayda\'', '141');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6290', '\'Ayn Qazzan', '144');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6291', '\'Ayn Salah', '144');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6292', 'Tamanghasat', '144');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6293', '\'Ayn Binyan', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6294', 'Bu Isma\'il', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6295', 'Bu Midfar\'ah', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6296', 'Damus', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6297', 'Duwirah', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6298', 'Hajut', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6299', 'Hammam Righa', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6300', 'Sawlah', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6301', 'Shiragha', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6302', 'Shirshall', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6303', 'Sidi Farj', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6304', 'Stawali', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6305', 'Tibazah', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6306', 'Ziralda', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6307', 'al-Qull\'ah', '145');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6308', 'Bi\'r-al-\'Itir', '146');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6309', 'Hammamat', '146');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6310', 'Mursut', '146');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6311', 'Shariyah', '146');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6312', 'Tibissah', '146');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6313', 'Winzah', '146');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6314', 'al-\'Awaynat', '146');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6315', 'Awlad Mimun', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6316', 'Bani Mastar', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6317', 'Bani Sikran', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6318', 'Ghazawat', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6319', 'Hannayah', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6320', 'Maghniyah', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6321', 'Nidruma', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6322', 'Ramsh', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6323', 'Sabra', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6324', 'Shatwan', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6325', 'Sibdu', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6326', 'Sidi \'Abdallah', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6327', 'Tilimsan', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6328', 'al-Mansurah', '147');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6329', 'Tinduf', '148');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6330', 'Thaniyat-al-Had', '149');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6331', 'Tisamsilt', '149');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6332', '\'Ayn Dhahab', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6333', 'Firindah', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6334', 'Mahdiyah', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6335', 'Mashra\'a Asfa', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6336', 'Qasr Shillalah', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6337', 'Rahuyah', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6338', 'Sughar', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6339', 'Takhamarat', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6340', 'Tiyarat', '150');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6341', '\'Ayn Bayda', '152');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6342', '\'Ayn Fakrun', '152');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6343', '\'Ayn Kirshah', '152');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6344', '\'Ayn Malilah', '152');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6345', 'Bi\'r Shuhada', '152');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6346', 'Miskyanah', '152');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6347', 'Shamurah', '152');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6348', 'Umm-al-Bawaghi', '152');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6349', '\'Ayn Biya', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6350', '\'Ayn-at-Turk', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6351', 'Arzu', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6352', 'Bi\'r-al-Jir', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6353', 'Butlilis', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6354', 'Hassi Bu Nif', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6355', 'Mars-al-Kabir', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6356', 'Qadayal', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6357', 'Sidi ash-Shami', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6358', 'Wadi Thalatha', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6359', 'Wahran', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6360', 'al-Ansur', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6361', 'as-Saniyah', '153');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6362', 'Hassi Mas\'ud', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6363', 'Nazla', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6364', 'Ruwisiyat', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6365', 'Tabisbast', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6366', 'Tamalhat', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6367', 'Tamasin', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6368', 'Tayabat-al-Janubiyah', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6369', 'Tughghurt', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6370', 'Warqla', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6371', 'al-Hajirah', '154');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6372', 'Aflu', '158');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6373', 'Hassi al-Raml', '158');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6374', 'al-Aghwat', '158');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6375', 'Brizyanah', '159');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6376', 'al-Abyad Sidi Shaykh', '159');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6377', 'al-Bayadh', '159');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6378', 'Bab Azwar', '160');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6379', 'Baraki', '160');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6380', 'Bir Murad Rais', '160');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6381', 'Birkhadam', '160');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6382', 'Burj-al-Kiffan', '160');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6383', 'Dar-al-Bayda', '160');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6384', 'al-Jaza\'ir', '160');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6385', 'Bayadha', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6386', 'Dabilah', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6387', 'Hassan \'Abd-al-Karim', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6388', 'Hassi Halifa', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6389', 'Jama\'a', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6390', 'Maqran', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6391', 'Qamar', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6392', 'Raqiba', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6393', 'Rubbah', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6394', 'Sidi Amran', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6395', 'al-Mighair', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6396', 'al-Wad', '161');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6397', '\'Ayn Maran', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6398', 'Abu al-Hassan', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6399', 'Bani Hawa', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6400', 'Bu Qadir', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6401', 'Sidi Ukaskah', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6402', 'Tanas', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6403', 'Wadi Sali', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6404', 'Wadi al-Fiddah', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6405', 'ash-Shalif', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6406', 'ash-Shattiyah', '162');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6407', 'Ban Mahdi', '163');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6408', 'Bani Amar', '163');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6409', 'Basbas', '163');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6410', 'Dariyan', '163');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6411', 'Saba\'ita Muk', '163');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6412', 'al-Qal\'ah', '163');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6413', 'at-Tarif', '163');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6414', 'Afono', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6415', 'Alao', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6416', 'Alofau', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6417', 'Amouli', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6418', 'Aoa', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6419', 'Atu\'u', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6420', 'Aua', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6421', 'Aunu\'u', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6422', 'Faga\'alu', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6423', 'Faga\'itua', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6424', 'Fagasa', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6425', 'Fagatogo', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6426', 'Lauli\'i', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6427', 'Leloaloa', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6428', 'Nu\'uuli', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6429', 'Pago Pago', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6430', 'Tula', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6431', 'Utulei', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6432', 'Vatia', '164');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6433', 'Ofu', '165');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6434', 'Aoloau', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6435', 'Faleniu', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6436', 'Futiga', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6437', 'Ili\'ili', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6438', 'Leone', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6439', 'Malaeimi', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6440', 'Malaeloa-Aitulagi', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6441', 'Malaeloa-Ituau', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6442', 'Mapusagafou', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6443', 'Mesepa', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6444', 'Pava\'ia\'i', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6445', 'Tafuna', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6446', 'Taputimu', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6447', 'Vailoatai', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6448', 'Vaitogi', '167');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6449', 'Canillo', '169');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6450', 'Encamp', '170');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6451', 'Ordino', '173');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6452', 'Caxito', '175');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6453', 'Benguela', '176');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6454', 'Lobito', '176');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6455', 'Camacupa', '177');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6456', 'Catabola', '177');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6457', 'Catumbela', '177');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6458', 'Chissamba', '177');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6459', 'Kuito', '177');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6460', 'Cabinda', '178');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6461', 'Ondjiva', '179');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6462', 'Caala', '180');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6463', 'Catchiungo', '180');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6464', 'Huambo', '180');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6465', 'Longonjo', '180');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6466', 'Caconda', '181');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6467', 'Caluquembe', '181');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6468', 'Lubango', '181');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6469', 'Menongue', '182');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6470', 'Luanda', '185');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6471', 'Malanje', '188');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6472', 'Cazaje', '189');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6473', 'Leua', '189');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6474', 'Luau', '189');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6475', 'Luena', '189');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6476', 'Lumeje', '189');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6477', 'Namibe', '190');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6478', 'Camabatela', '191');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6479', 'Uige', '191');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6480', 'M\'banza-Kongo', '192');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6481', 'N\'zeto', '192');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6482', 'Soyo', '192');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6483', 'Codrington', '201');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6484', 'Catamarca', '209');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6485', 'Presidencia Roque Saenz Pena', '210');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6486', 'Resistencia', '210');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6487', 'Comodoro Rivadavia', '211');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6488', 'Puerto Madryn', '211');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6489', 'Rawson', '211');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6490', 'Trelew', '211');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6491', 'Alta Gracia', '212');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6492', 'Bell Ville', '212');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6493', 'Cordoba', '212');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6494', 'Rio Cuarto', '212');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6495', 'Rio Tercero', '212');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6496', 'San Francisco', '212');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6497', 'Villa Carlos Paz', '212');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6498', 'Villa Maria', '212');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6499', 'Corrientes', '213');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6500', 'Goya', '213');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6501', 'Mercedes', '213');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6502', 'San Lorenzo', '213');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6503', 'Formosa', '216');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6504', 'Jujuy', '217');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6505', 'Libertador General San Martin', '217');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6506', 'San Pedro', '217');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6507', 'Godoy Cruz', '220');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6508', 'Lujan', '220');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6509', 'Mendoza', '220');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6510', 'Rivadavia', '220');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6511', 'San Martin', '220');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6512', 'San Rafael', '220');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6513', 'Eldorado', '221');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6514', 'Obera', '221');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6515', 'Posadas', '221');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6516', 'Cutral Co', '222');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6517', 'Neuquen', '222');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6518', 'Salta', '224');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6519', 'San Ramon de la Nueva Oran', '224');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6520', 'Tartagal', '224');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6521', 'Tucuman', '231');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6522', 'Ashtarak', '232');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6523', 'Talin', '232');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6524', 'Ararat', '233');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6525', 'Artashat', '233');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6526', 'Armavir', '234');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6527', 'Vagharshapat', '234');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6528', 'Gavar', '235');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6529', 'Martuni', '235');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6530', 'Sevan', '235');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6531', 'Vardenis', '235');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6532', 'Abovyan', '236');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6533', 'Arzni', '236');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6534', 'Charentsavan', '236');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6535', 'Hrazdan', '236');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6536', 'Akhtala', '237');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6537', 'Alaverdi', '237');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6538', 'Spitak', '237');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6539', 'Stepanavan', '237');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6540', 'Tashir', '237');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6541', 'Vanadzor', '237');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6542', 'Artik', '238');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6543', 'Gyumri', '238');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6544', 'Stepanakert', '239');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6545', 'Angeghakot', '240');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6546', 'Goris', '240');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6547', 'Kajaran', '240');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6548', 'Kapan', '240');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6549', 'Meghri', '240');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6550', 'Sisian', '240');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6551', 'Dilijan', '241');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6552', 'Ijevan', '241');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6553', 'Yerevan', '243');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6554', 'Aruba', '244');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6555', 'Glenfield', '245');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6556', 'Henderson', '245');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6557', 'Milford', '245');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6558', 'Balgowlah', '247');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6559', 'Balmain', '248');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6560', 'Bankstown', '249');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6561', 'Camberwell', '252');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6562', 'Caulfield', '255');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6563', 'Chatswood', '256');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6564', 'Cheltenham', '257');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6565', 'Cherrybrook', '258');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6566', 'Clayton', '259');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6567', 'Collingwood', '260');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6568', 'Hawthorn', '262');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6569', 'Jannnali', '263');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6570', 'Knoxfield', '264');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6571', 'Melbourne', '265');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6572', 'South Oakleigh', '265');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6573', 'Cottesole', '268');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6574', 'Darch', '268');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6575', 'Mullaloo', '268');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6576', 'Noranda', '268');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6577', 'Osborne Park', '268');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6578', 'Willetton', '268');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6579', 'Acacia Ridge', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6580', 'Aitkenvale', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6581', 'Alderley', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6582', 'Alexander Hills', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6583', 'Archerfield', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6584', 'Ashmore', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6585', 'Atherton', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6586', 'Ayr', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6587', 'Beachmere', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6588', 'Beenleigh', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6589', 'Beerwah', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6590', 'Bell', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6591', 'Belmont', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6592', 'Biloela', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6593', 'Birkdale', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6594', 'Blackwater', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6595', 'Bongaree', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6596', 'Bonogin', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6597', 'Boonah', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6598', 'Bowen', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6599', 'Brendale', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6600', 'Brisbane', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6601', 'Buddina', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6602', 'Buderim', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6603', 'Bundaberg', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6604', 'Bundall', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6605', 'Burleigh Heads', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6606', 'Burpengary', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6607', 'Cabaland', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6608', 'Caboolture', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6609', 'Cairns', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6610', 'Cairns Northern Beaches', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6611', 'Caloundra', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6612', 'Capalaba', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6613', 'Charters Towers', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6614', 'Childers', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6615', 'Cleveland', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6616', 'Coolum Beach', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6617', 'Coopers Plain', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6618', 'Dalby', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6619', 'Deception Bay', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6620', 'Eagle Farm', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6621', 'Eagleby', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6622', 'Emerald', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6623', 'Emundi', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6624', 'Forest Lake', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6625', 'Gatton', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6626', 'Gladstone', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6627', 'Gold Coast', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6628', 'Gowrie Junction', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6629', 'Gympie', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6630', 'Helensvale', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6631', 'Hervey Bay', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6632', 'Ingham', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6633', 'Innisfail', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6634', 'Ipswich', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6635', 'Jindalee', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6636', 'Julatten', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6637', 'Kawana Waters', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6638', 'Kingaroy', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6639', 'Lawnton', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6640', 'Loganholme', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6641', 'Mackay', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6642', 'Mareeba', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6643', 'Maroochydore', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6644', 'Maroochydore-Mooloolaba', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6645', 'Maryborough', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6646', 'Miami', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6647', 'Milton', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6648', 'Molendinar', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6649', 'Moranbah', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6650', 'Morayfield', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6651', 'Mossman', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6652', 'Mount Glorious', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6653', 'Mount Isa', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6654', 'Murarrie', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6655', 'Nairand Kay', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6656', 'Nambour', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6657', 'Nerang', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6658', 'Nobby Beach', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6659', 'Noosa Heads', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6660', 'Noosaville', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6661', 'Paddington', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6662', 'Port Douglas', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6663', 'Robina', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6664', 'Rockhampton', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6665', 'Rocklea', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6666', 'Roma', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6667', 'Rubyvale', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6668', 'Sanctuary Cove', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6669', 'Slade Point', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6670', 'Southport', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6671', 'Suburb', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6672', 'Sunshine Coast', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6673', 'Tewantin-Noosa', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6674', 'The Summit', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6675', 'Toowong', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6676', 'Toowoomba', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6677', 'Townsville', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6678', 'Victoria Point', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6679', 'Warwick', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6680', 'Willawong', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6681', 'Yatala', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6682', 'Yeppoon', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6683', 'Zillmere', '269');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6684', 'Bridgewater-Gagebrook', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6685', 'Burnie', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6686', 'Burnie-Devonport', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6687', 'Glenorchy', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6688', 'Hobart', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6689', 'Kingston-Blackmans Bay', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6690', 'Launceston', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6691', 'New Norfolk', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6692', 'Rowella', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6693', 'Sheffield', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6694', 'Ulverstone', '271');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6695', 'Templestowe', '272');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6696', 'Albion', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6697', 'Ararat', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6698', 'Avenel', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6699', 'Avondale Heights', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6700', 'Baccus Marsh', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6701', 'Bairnsdale', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6702', 'Ballarat', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6703', 'Balwyn', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6704', 'Batman', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6705', 'Bayswater', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6706', 'Belmont', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6707', 'Benalla', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6708', 'Bendigo', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6709', 'Bentleigh East', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6710', 'Berwick', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6711', 'Blackburn', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6712', 'Blue Mountains', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6713', 'Boonah', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6714', 'Boronia', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6715', 'Box Hill', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6716', 'Brighton East', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6717', 'Bundoora', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6718', 'Campbellfield', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6719', 'Carlton South', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6720', 'Caroline Springs', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6721', 'Castle Hill', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6722', 'Castlemaine', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6723', 'Caulfield', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6724', 'Cheltenham', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6725', 'Chester', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6726', 'Clayton South', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6727', 'Clifton Springs', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6728', 'Coburg', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6729', 'Colac', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6730', 'Collingwood', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6731', 'Craigieburn', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6732', 'Cranbourne', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6733', 'Crib Point', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6734', 'Dandenong', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6735', 'Devon Meadows', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6736', 'Diamond Creek', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6737', 'Doncaster East', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6738', 'Doncester', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6739', 'Donvale', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6740', 'Echuca-Moama', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6741', 'Elsternwick', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6742', 'Eltham', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6743', 'Fairfield', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6744', 'Fitzroy', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6745', 'Frnakston', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6746', 'Geelong', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6747', 'Glen Waverley', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6748', 'Glenorchy', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6749', 'Hallam', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6750', 'Hamilton', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6751', 'Hastings', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6752', 'Healesville', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6753', 'Horsham', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6754', 'Hughesdale', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6755', 'Ivanhoe', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6756', 'Keilor', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6757', 'Kensington', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6758', 'Kerang', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6759', 'Kilmore', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6760', 'Kilsyth', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6761', 'Kyabram', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6762', 'Lakes Entrance', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6763', 'Lalor', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6764', 'Lara', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6765', 'Laverton North', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6766', 'Leopold', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6767', 'Lower Templestowe', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6768', 'Maidstone', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6769', 'Malvern', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6770', 'Maryborough', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6771', 'Melbourne', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6772', 'Melton', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6773', 'Middle Park', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6774', 'Mildura', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6775', 'Mitcham', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6776', 'Moe-Yallourn', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6777', 'Moorabbin', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6778', 'Mordialloc', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6779', 'Morwell', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6780', 'Mulgrave', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6781', 'Murrumbeena', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6782', 'Neerim South', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6783', 'Noble Park North', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6784', 'Notting Hill', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6785', 'Oak Park', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6786', 'Ocean Grove-Barwon Heads', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6787', 'Olinda', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6788', 'Pakenham', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6789', 'Park Orchards', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6790', 'Port Melbourne', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6791', 'Portland', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6792', 'Prahran', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6793', 'Preston', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6794', 'Pritbourne', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6795', 'Queenscliff', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6796', 'Reservoir', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6797', 'Ringwood', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6798', 'Rowville', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6799', 'Sale', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6800', 'Sandringham', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6801', 'Scoresby', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6802', 'Sebastopol', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6803', 'Seymour', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6804', 'Shepparton-Mooroopna', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6805', 'Somerville', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6806', 'South Yarra', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6807', 'Southbank', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6808', 'St. Albans', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6809', 'St. Kilda East', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6810', 'Stawell', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6811', 'Sunbury', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6812', 'Sunshine West', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6813', 'Swan Hill', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6814', 'Tatura', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6815', 'Thomastown', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6816', 'Thornbury', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6817', 'Tongala', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6818', 'Torquay', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6819', 'Traralgon', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6820', 'Tullamarine', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6821', 'Vermont', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6822', 'Wangaratta', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6823', 'Wantirna', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6824', 'Warragul', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6825', 'Warrnambool', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6826', 'Welshpool', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6827', 'Wendouree', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6828', 'Wonthaggi', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6829', 'Woodend', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6830', 'Yarrawonga-Mulwala', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6831', 'Yea', '273');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6832', 'Wheeler', '276');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6833', 'Eisenstadt', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6834', 'GroBpetersdorf', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6835', 'Jennersdorf', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6836', 'Kemeten', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6837', 'Mattersburg', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6838', 'Neudorfl', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6839', 'Neusiedl am See', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6840', 'Oberwart', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6841', 'Pinkafeld', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6842', 'Rust', '280');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6843', 'Maria Rain', '281');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6844', 'Poggersdorf', '281');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6845', 'Althofen', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6846', 'Arnoldstein', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6847', 'Bad Sankt Leonhard', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6848', 'Bleiburg', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6849', 'Ebenthal', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6850', 'Eberndorf', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6851', 'Feldkirchen', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6852', 'Ferlach', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6853', 'Finkenstein', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6854', 'Friesach', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6855', 'Hermagor', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6856', 'Klagenfurt', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6857', 'Klagenfurt ', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6858', 'Lohnsburg', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6859', 'Moosburg', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6860', 'Paternion', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6861', 'Radentheim', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6862', 'Sankt Andra', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6863', 'Sankt Jakob', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6864', 'Sankt Veit', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6865', 'Seeboden', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6866', 'Spittal', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6867', 'Velden am Worthersee', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6868', 'Villach', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6869', 'Volkermarkt', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6870', 'Wernberg', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6871', 'Wolfsberg', '282');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6872', 'Amstetten', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6873', 'Bad Voslau', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6874', 'Baden', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6875', 'Berndorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6876', 'Boheimkirchen', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6877', 'Bruck an der Leitha', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6878', 'Brunn', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6879', 'Deutsch-Wagram', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6880', 'Ebreichsdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6881', 'Eggendorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6882', 'Fischamend', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6883', 'Gablitz', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6884', 'Ganserndorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6885', 'Gerasdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6886', 'Gloggnitz', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6887', 'Gmund', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6888', 'Greifenstein', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6889', 'GroB-Enzersdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6890', 'GroB-Gerungs', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6891', 'Guntramsdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6892', 'Haag', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6893', 'Hainburg', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6894', 'Heidenreichstein', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6895', 'Herzogenburg', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6896', 'Himberg', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6897', 'Hollabrunn', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6898', 'Horn', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6899', 'Klosterneuburg', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6900', 'Korneuburg', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6901', 'Kottingbrunn', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6902', 'Krems', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6903', 'Laa', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6904', 'Langenlois', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6905', 'Langenzersdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6906', 'Leobendorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6907', 'Leopoldsdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6908', 'Lilienfeld', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6909', 'Loipersdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6910', 'Maria Enzersdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6911', 'Melk', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6912', 'Mistelbach', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6913', 'Modling', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6914', 'Neulengbach', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6915', 'Neunkirchen', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6916', 'Niederleis', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6917', 'Ober-Grabendorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6918', 'Perchtoldsdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6919', 'Pernitz', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6920', 'Pottendorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6921', 'Poysdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6922', 'Pressbaum', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6923', 'Purgstall', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6924', 'Purkersdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6925', 'Reichenau', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6926', 'Retz', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6927', 'Sankt Andra-Wordern', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6928', 'Sankt Peter in der Au', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6929', 'Sankt Polten', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6930', 'Sankt Valentin', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6931', 'Scheibbs', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6932', 'Schrems', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6933', 'Schwechat', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6934', 'Seitenstetten', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6935', 'Sollenau', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6936', 'Stockerau', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6937', 'Strasshof', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6938', 'Ternitz', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6939', 'Traiskirchen', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6940', 'Traismauer', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6941', 'Tulln', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6942', 'Vosendorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6943', 'Waidhofen', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6944', 'Wiener Neudorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6945', 'Wiener Neustadt', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6946', 'Wieselburg', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6947', 'Wilhelmsburg', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6948', 'Wolkersdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6949', 'Ybbs', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6950', 'Ybbsitz', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6951', 'Zistersdorf', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6952', 'Zwettl', '285');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6953', 'Alkoven', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6954', 'Altheim', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6955', 'Altmunster', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6956', 'Andorf', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6957', 'Ansfelden', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6958', 'Asten', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6959', 'Attnang-Puchheim', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6960', 'Aurolzmunster', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6961', 'Bad Goisern', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6962', 'Bad Hall', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6963', 'Bad Ischl', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6964', 'Braunau', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6965', 'Breitenfurt', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6966', 'Ebensee', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6967', 'Eferding', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6968', 'Engerwitzdorf', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6969', 'Enns', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6970', 'Feldkirchen an der Donau', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6971', 'Frankenburg', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6972', 'Freistadt', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6973', 'Gallneukirchen', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6974', 'Garsten', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6975', 'Gmunden', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6976', 'Gramastetten', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6977', 'Grieskirchen', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6978', 'Gunskirchen', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6979', 'Horsching', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6980', 'Kirchdorf an der Krems', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6981', 'Kremsmunster', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6982', 'Krenglbach', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6983', 'Laakirchen', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6984', 'Lenzing', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6985', 'Leonding', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6986', 'Linz', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6987', 'Loibichl', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6988', 'Marchtrenk', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6989', 'Mattighofen', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6990', 'Mauthausen', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6991', 'Micheldorf', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6992', 'Neuhofen an der Krems', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6993', 'Ohlsdorf', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6994', 'Ottensheim', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6995', 'Pasching', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6996', 'Perg', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6997', 'Pettenbach', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6998', 'Pram', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('6999', 'Pregarten', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7000', 'Puchenau', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7001', 'Regau', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7002', 'Ried', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7003', 'Rohrbach in Oberosterreich', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7004', 'Rutzenmoos', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7005', 'Sankt Florian', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7006', 'Sankt Georgen', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7007', 'Sankt Marien', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7008', 'Scharding', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7009', 'Scharnstein', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7010', 'Schwertberg', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7011', 'Seewalchen', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7012', 'Sierning', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7013', 'Stadl-Paura', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7014', 'Steyr', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7015', 'Steyregg', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7016', 'Steyrermuhl', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7017', 'Thalheim', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7018', 'Timelkam', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7019', 'Traun', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7020', 'Vocklabruck', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7021', 'Vocklamarkt', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7022', 'Vorchdorf', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7023', 'Wels', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7024', 'Wilhering', '286');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7025', 'Abtenau', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7026', 'Anif', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7027', 'Bad Gastein', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7028', 'Bad Hofgastein', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7029', 'Bergheim', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7030', 'Bischofshofen', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7031', 'Bruck an der GroBglocknerstraB', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7032', 'Burmoos', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7033', 'Elsbethen', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7034', 'Eugendorf', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7035', 'Forstau', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7036', 'Grodig', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7037', 'Hallein', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7038', 'Hallwang', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7039', 'Henndorf', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7040', 'Kuchl', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7041', 'Mayrhofen', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7042', 'Mittersill', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7043', 'Neumarkt', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7044', 'Oberndorf', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7045', 'Obertrum am See', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7046', 'Piesendorf', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7047', 'Puch', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7048', 'Radstadt', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7049', 'Saalfelden', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7050', 'Salzburg', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7051', 'Sankt Johann im Pongau', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7052', 'Seekirchen', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7053', 'Sieghartskirchen', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7054', 'StraBwalchen', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7055', 'Strobl', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7056', 'Tamsweg', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7057', 'Thalgau', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7058', 'Wals-Siezenheim', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7059', 'Wolfgangsee', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7060', 'Zell am See', '287');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7061', 'Albersdorf', '288');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7062', 'Bad Aussee', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7063', 'Barnbach', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7064', 'Bruck an der Mur', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7065', 'Deutschlandsberg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7066', 'Eisenerz', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7067', 'Feldbach', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7068', 'Feldkirchen bei Graz', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7069', 'Fohnsdorf', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7070', 'Frohnleiten', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7071', 'Furstenfeld', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7072', 'Gleisdorf', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7073', 'Gratkorn', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7074', 'Graz', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7075', 'Hartberg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7076', 'Judenburg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7077', 'Judendorf-StraBengel', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7078', 'Kapfenberg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7079', 'Karlsdorf', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7080', 'Kindberg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7081', 'Knittelfeld', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7082', 'Koflach', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7083', 'Krieglach', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7084', 'Lannach', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7085', 'Leibnitz', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7086', 'Leoben', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7087', 'Liezen', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7088', 'Murzzuschlag', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7089', 'Rottenmann', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7090', 'Schladming', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7091', 'Seiersberg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7092', 'Spielberg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7093', 'Trofaiach', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7094', 'Voitsberg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7095', 'Wagna', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7096', 'Weiz', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7097', 'Zeltweg', '289');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7098', 'Deutschfeistritz', '290');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7099', 'Liezen', '290');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7100', 'Sankt Bartholoma', '290');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7101', 'Absam', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7102', 'Axams', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7103', 'Ebbs', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7104', 'Fugen', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7105', 'Hall', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7106', 'Haselgehr', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7107', 'Hopfgarten', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7108', 'Imst', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7109', 'Innsbruck', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7110', 'Jenbach', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7111', 'Kirchberg', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7112', 'Kirchbichl', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7113', 'Kitzbuhel', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7114', 'Kramsach', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7115', 'Kufstein', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7116', 'Landeck', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7117', 'Lienz', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7118', 'Matrei', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7119', 'Neustift im Stubaital', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7120', 'Reutte', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7121', 'Rum', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7122', 'Sankt Johann in Tirol', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7123', 'Scheffau', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7124', 'Schwaz', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7125', 'St. Johann Am Walde', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7126', 'Telfs', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7127', 'Vols', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7128', 'Vomp', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7129', 'Wattens', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7130', 'Worgl', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7131', 'Zirl', '291');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7132', 'Altach', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7133', 'Bludenz', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7134', 'Bregenz', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7135', 'Chassieu', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7136', 'Dietmannsried', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7137', 'Dornbirn', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7138', 'Feldkirch', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7139', 'Frastanz', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7140', 'Gotzis', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7141', 'Hard', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7142', 'Hochst', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7143', 'Hohenems', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7144', 'Horbranz', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7145', 'Hufingen', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7146', 'Lauterach', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7147', 'Lochau', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7148', 'Lustenau', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7149', 'Mittelberg', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7150', 'Nenzing', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7151', 'Nuziders', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7152', 'Rankweil', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7153', 'Schruns', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7154', 'Thuringen', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7155', 'Wolfurt', '293');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7156', 'Vienna', '294');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7157', 'Wien', '294');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7158', 'Alat', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7159', 'Artyom', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7160', 'Baki', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7161', 'Bakixanov', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7162', 'Balaxani', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7163', 'Bilacari', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7164', 'Bilqax', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7165', 'Bina', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7166', 'Buzovna', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7167', 'Haci Zeynalabdin', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7168', 'Hovsan', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7169', 'Lokbatan', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7170', 'Mastaga', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7171', 'Puta', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7172', 'Qarasuxur', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7173', 'Qobustan', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7174', 'Rasulzada', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7175', 'Sabuncu', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7176', 'Sanqacal', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7177', 'Sumqayit', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7178', 'Suraxani', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7179', 'Xirdalan', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7180', 'Zirya', '295');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7181', 'Daskasan', '297');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7182', 'Ganca', '297');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7183', 'Xanlar', '297');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7184', 'Ganja', '298');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7185', 'Cabrayil', '299');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7186', 'Kalbacar', '299');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7187', 'Lacin', '299');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7188', 'Astara', '300');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7189', 'Goytapa', '300');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7190', 'Lankaran', '300');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7191', 'Masalli', '300');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7192', 'Neftcala', '300');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7193', 'Agcabadi', '301');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7194', 'Agdam', '301');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7195', 'Barda', '301');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7196', 'Mingacevir', '301');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7197', 'Tartar', '301');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7198', 'Yevlax', '301');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7199', 'Ali Bayramli', '302');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7200', 'Bilasuvar', '302');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7201', 'Calilabad', '302');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7202', 'Qarasu', '302');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7203', 'Qazimammad', '302');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7204', 'Saatli', '302');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7205', 'Sabirabad', '302');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7206', 'Salyan', '302');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7207', 'Susa', '303');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7208', 'Xankandi', '303');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7209', 'Xocavand', '303');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7210', 'Culfa', '304');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7211', 'Naxcivan', '304');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7212', 'Ordubad', '304');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7213', 'Sadarak', '304');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7214', 'Sarur', '304');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7215', 'Beylaqan', '305');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7216', 'Fuzuli', '305');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7217', 'Imisli', '305');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7218', 'Agstafa', '306');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7219', 'Gadabay', '306');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7220', 'Kovlar', '306');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7221', 'Qaracamirli', '306');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7222', 'Qazax', '306');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7223', 'Samkir', '306');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7224', 'Tovuz', '306');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7225', 'Amircan', '307');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7226', 'Balakan', '307');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7227', 'Katex', '307');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7228', 'Oguz', '307');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7229', 'Qabala', '307');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7230', 'Qax', '307');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7231', 'Saki', '307');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7232', 'Zaqatala', '307');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7233', 'Agdas', '308');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7234', 'Agsu', '308');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7235', 'Goycay', '308');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7236', 'Ismayilli', '308');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7237', 'Kurdamir', '308');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7238', 'Samaxi', '308');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7239', 'Ucar', '308');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7240', 'Zardab', '308');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7241', 'Davaci', '309');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7242', 'Quba', '309');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7243', 'Qusar', '309');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7244', 'Siyazan', '309');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7245', 'Xacmaz', '309');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7246', 'Xudat', '309');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7247', 'Coopers Town', '310');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7248', 'Marsh Harbour', '310');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7249', 'Andros Town', '312');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7250', 'Nicholls Town', '312');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7251', 'Alice Town', '314');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7252', 'Freetown', '317');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7253', 'Rock Sound', '317');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7254', 'Pirates Well', '322');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7255', '\'Isa', '327');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7256', 'Badiyah', '328');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7257', 'Hidd', '329');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7258', 'Mahama', '331');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7259', 'Manama', '332');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7260', 'Sitrah', '333');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7261', 'al-Manamah', '334');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7262', 'al-Muharraq', '335');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7263', 'ar-Rifa\'a', '336');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7264', 'Bandarban', '338');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7265', 'Barguna', '339');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7266', 'Barisal', '340');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7267', 'Gaurnadi', '340');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7268', 'Mehendiganj', '340');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7269', 'Nalchiti', '340');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7270', 'Bhola', '341');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7271', 'Burhanuddin', '341');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7272', 'Char Fasson', '341');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7273', 'Lalmohan', '341');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7274', 'Adamighi', '342');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7275', 'Bogora', '342');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7276', 'Sherpur', '342');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7277', 'Chandpur', '344');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7278', 'Hajiganj', '344');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7279', 'Boalkhali', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7280', 'Chattagam', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7281', 'Fatikchhari', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7282', 'Lohagara', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7283', 'Patiya', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7284', 'Rangunia', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7285', 'Raozan', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7286', 'Sandip', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7287', 'Satkaniya', '345');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7288', 'Alamdanga', '347');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7289', 'Chuadanga', '347');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7290', 'Damurhuda', '347');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7291', 'Dhaka', '348');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7292', 'Dhamrai', '348');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7293', 'Dohar', '348');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7294', 'Bochanganj', '349');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7295', 'Dinajpur', '349');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7296', 'Fulbari', '349');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7297', 'Parbatipur', '349');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7298', 'Bhanga', '350');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7299', 'Char Bhadrasan', '350');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7300', 'Faridpur', '350');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7301', 'Chhagalnaiya', '351');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7302', 'Feni', '351');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7303', 'Gaybanda', '352');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7304', 'Gazipur', '353');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7305', 'Tungi', '353');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7306', 'Gopalganj', '354');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7307', 'Tungi Para', '354');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7308', 'Baniachang', '355');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7309', 'Habiganj', '355');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7310', 'Jamalpur', '357');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7311', 'Sarishabari', '357');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7312', 'Abhaynagar', '358');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7313', 'Jessor', '358');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7314', 'Jhikargachha', '358');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7315', 'Keshabpur', '358');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7316', 'Jhalakati', '359');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7317', 'Jhanaydah', '360');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7318', 'Kaliganj', '360');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7319', 'Kotchandpur', '360');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7320', 'Shailkupa', '360');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7321', 'Khagrachari', '361');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7322', 'Manikchhari', '361');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7323', 'Ramgarh', '361');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7324', 'Khulna', '362');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7325', 'Phultala', '362');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7326', 'Bajitpur', '363');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7327', 'Bhairab Bazar', '363');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7328', 'Itna', '363');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7329', 'Kishorganj', '363');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7330', 'Komilla', '365');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7331', 'Laksham', '365');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7332', 'Chilmari', '366');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7333', 'Kurigram', '366');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7334', 'Nageshwari', '366');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7335', 'Ulipur', '366');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7336', 'Bheramara', '367');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7337', 'Kushtiya', '367');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7338', 'Lakshmipur', '368');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7339', 'Ramganj', '368');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7340', 'Ramgati', '368');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7341', 'Raypur', '368');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7342', 'Madaripur', '370');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7343', 'Magura', '371');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7344', 'Bhaluka', '372');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7345', 'Fulbaria', '372');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7346', 'Gafargaon', '372');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7347', 'Ishwarganj', '372');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7348', 'Maimansingh', '372');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7349', 'Muktagachha', '372');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7350', 'Trishal', '372');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7351', 'Manikganj', '373');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7352', 'Meherpur', '375');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7353', 'Munshiganj', '376');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7354', 'Kalia', '377');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7355', 'Naral', '377');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7356', 'Narayanganj', '378');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7357', 'Rupganj', '378');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7358', 'Narsingdi', '379');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7359', 'Roypura', '379');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7360', 'Gurudaspur', '380');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7361', 'Nator', '380');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7362', 'Naugaon', '381');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7363', 'Gomastapur', '382');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7364', 'Nawabganj', '382');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7365', 'Shibganj', '382');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7366', 'Netrakona', '383');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7367', 'Domar', '384');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7368', 'Nilphamari', '384');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7369', 'Sa\'idpur', '384');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7370', 'Begamganj', '385');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7371', 'Noakhali', '385');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7372', 'Senbagh', '385');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7373', 'Bera', '386');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7374', 'Bhangura', '386');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7375', 'Ishurdi', '386');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7376', 'Pabna', '386');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7377', 'Panchagarh', '387');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7378', 'Patuakhali', '388');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7379', 'Bhandaria', '389');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7380', 'Mathbaria', '389');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7381', 'Nesarabad', '389');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7382', 'Pirojpur', '389');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7383', 'Pangsha', '390');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7384', 'Rajbari', '390');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7385', 'Rajshahi', '391');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7386', 'Kaptai', '392');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7387', 'Rangamati', '392');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7388', 'Badarganj', '393');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7389', 'Kaunia', '393');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7390', 'Rangpur', '393');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7391', 'Satkhira', '394');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7392', 'Palang', '395');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7393', 'Nalitabari', '396');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7394', 'Sherpur', '396');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7395', 'Silhat', '397');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7396', 'Shahjadpur', '398');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7397', 'Sirajganj', '398');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7398', 'Chhatak', '399');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7399', 'Sunamganj', '399');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7400', 'Gopalpur', '400');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7401', 'Mirzapur', '400');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7402', 'Sakhipur', '400');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7403', 'Tangayal', '400');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7404', 'Pirganj', '401');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7405', 'Thakurgaon', '401');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7406', 'Baranavichy', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7407', 'Bjaroza', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7408', 'Bjeloozersk', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7409', 'Brest', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7410', 'David-Haradok', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7411', 'Drahichyn', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7412', 'Hancavichy', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7413', 'Ivacevichy', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7414', 'Ivanava', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7415', 'Kamjenec', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7416', 'Kobryn', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7417', 'Kosava', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7418', 'Ljahavichy', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7419', 'Luninjec', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7420', 'Malaryta', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7421', 'Mikashevichy', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7422', 'Pinsk', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7423', 'Pruzhany', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7424', 'Stolin', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7425', 'Vysokoje', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7426', 'Zhabinka', '413');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7427', 'Buda Kosheljovo', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7428', 'Chechersk', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7429', 'Dobrush', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7430', 'Hojniki', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7431', 'Homjel\'', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7432', 'Jel\'sk', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7433', 'Kalinkavichy', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7434', 'Kascjukovka', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7435', 'Mazyr', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7436', 'Narovlja', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7437', 'Pjetrykav', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7438', 'Rahachow', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7439', 'Rechyca', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7440', 'Svetlahorsk', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7441', 'Vasilevichy', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7442', 'Vjetka', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7443', 'Zhlobin', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7444', 'Zhytkavichy', '414');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7445', 'Ashmjany', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7446', 'Berjozovka', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7447', 'Hrodna', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7448', 'Lida', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7449', 'Masty', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7450', 'Navahrudak', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7451', 'Shchuchyn', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7452', 'Skidel\'', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7453', 'Slonim', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7454', 'Smarhon\'', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7455', 'Vawkavysk', '415');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7456', 'Asipovichy', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7457', 'Babrujsk', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7458', 'Byhau', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7459', 'Chausy', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7460', 'Cherikov', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7461', 'Horki', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7462', 'Kascjukovichy', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7463', 'Klimavichy', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7464', 'Krychaw', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7465', 'Mahiljow', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7466', 'Mstislav', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7467', 'Shklov', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7468', 'Slaeuharad', '416');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7469', 'Minsk', '418');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7470', 'Petrikov', '420');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7471', 'Baran\'', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7472', 'Braslav', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7473', 'Chashniki', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7474', 'Disna', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7475', 'Dokshicy', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7476', 'Dubrovna', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7477', 'Haradok', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7478', 'Hlybokaje', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7479', 'Ljepjel\'', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7480', 'Mjory', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7481', 'Navapolack', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7482', 'Novalukoml\'', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7483', 'Orsha', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7484', 'Pastavy', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7485', 'Polack', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7486', 'Polotsk', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7487', 'Senno', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7488', 'Talachyn', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7489', 'Verhnjadzvimsk', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7490', 'Vicebsk', '421');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7491', 'Aartselaar', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7492', 'Antwerpen', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7493', 'Arendonk', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7494', 'Baarle-Hertog', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7495', 'Balen', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7496', 'Beerse', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7497', 'Berlaar', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7498', 'Boechout', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7499', 'Bonheiden', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7500', 'Boom', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7501', 'Bornem', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7502', 'Borsbeek', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7503', 'Brasschaat', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7504', 'Brecht', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7505', 'Dessel', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7506', 'Deurne', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7507', 'Duffel', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7508', 'Edegem', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7509', 'Ekeren', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7510', 'Essen', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7511', 'Geel', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7512', 'Geluvele', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7513', 'Grobbendonk', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7514', 'Heist-op-den-Berg', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7515', 'Hemiksem', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7516', 'Herentals', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7517', 'Herenthout', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7518', 'Herselt', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7519', 'Hoogstraten', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7520', 'Hove', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7521', 'Hulshout', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7522', 'Kalmpthout', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7523', 'Kalmthout', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7524', 'Kapellen', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7525', 'Kasterlee', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7526', 'Kontich', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7527', 'Laakdal', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7528', 'Lier', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7529', 'Lille', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7530', 'Lint', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7531', 'Malle', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7532', 'Mechelen', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7533', 'Meerhout', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7534', 'Merksplas', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7535', 'Mol', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7536', 'Mortsel', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7537', 'Niel', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7538', 'Nijlen', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7539', 'Olen', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7540', 'Oud-Turnhout', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7541', 'Putte', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7542', 'Puurs', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7543', 'Ranst', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7544', 'Ravels', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7545', 'Retie', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7546', 'Rijkevorsel', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7547', 'Robrechts', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7548', 'Rumst', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7549', 'Schelle', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7550', 'Schilde', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7551', 'Schoten', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7552', 'Sint-Amands', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7553', 'Sint-Katelijne-Waver', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7554', 'Stabroek', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7555', 'Turnhout', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7556', 'Vorselaar', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7557', 'Vosselaar', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7558', 'Westerlo', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7559', 'Wijnegem', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7560', 'Willebroek', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7561', 'Wilrijk', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7562', 'Wommelgem', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7563', 'Wuustwezel', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7564', 'Zandhoven', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7565', 'Zoersel', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7566', 'Zwijndrecht', '422');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7567', 'Berchem', '423');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7568', 'Alsemberg', '424');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7569', 'Asse Zellik', '424');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7570', 'Brussels', '424');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7571', 'Bruxelles', '424');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7572', 'Diegem', '424');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7573', 'Alsemberg', '425');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7574', 'Asse Zellik', '425');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7575', 'Brussels', '425');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7576', 'Bruxelles', '425');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7577', 'Diegem', '425');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7578', 'Brussel', '426');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7579', 'Aiseau-Presles', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7580', 'Anderlues', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7581', 'Antoing', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7582', 'Ath', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7583', 'Beaumont', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7584', 'Beloeil', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7585', 'Bernissart', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7586', 'Binche', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7587', 'Boussu', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7588', 'Braine-le-Comte', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7589', 'Brugelette', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7590', 'Brunehaut', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7591', 'Celles', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7592', 'Chapelle-lez-Herlaimont', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7593', 'Charleroi', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7594', 'Chatelet', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7595', 'Chievres', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7596', 'Chimay', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7597', 'Colfontaine', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7598', 'Comines-Warneton', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7599', 'Courcelles', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7600', 'Dour', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7601', 'Ecaussinnes', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7602', 'Ellezelles', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7603', 'Enghien', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7604', 'Erquelinnes', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7605', 'Estaimpuis', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7606', 'Estinnes', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7607', 'Farciennes', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7608', 'Fleurus', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7609', 'Flobecq', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7610', 'Fontaine-l\'Eveque', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7611', 'Frameries', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7612', 'Frasnes-lez-Anvaing', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7613', 'Froidchapelle', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7614', 'Gerpinnes', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7615', 'Haine-Saint-Pierre', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7616', 'Ham-sur-Heure-Nalinnes', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7617', 'Hensies', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7618', 'Honnelles', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7619', 'Jurbise', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7620', 'La Louviere', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7621', 'Le Roeulx', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7622', 'Lens', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7623', 'Les Bons Villers', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7624', 'Lessines', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7625', 'Leuze-en-Hainaut', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7626', 'Lobbes', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7627', 'Manage', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7628', 'Merbes-le-Chateau', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7629', 'Momignies', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7630', 'Mons', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7631', 'Mont-de-l\'Enclus', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7632', 'Montigny-le-Tilleul', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7633', 'Morlanwelz', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7634', 'Mouscron', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7635', 'Pecq', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7636', 'Peruwelz', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7637', 'Pont-a-Celles', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7638', 'Quaregnon', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7639', 'Quevy', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7640', 'Quievrain', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7641', 'Rumes', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7642', 'Saint-Ghislain', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7643', 'Seneffe', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7644', 'Silly', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7645', 'Sivry-Rance', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7646', 'Soignies', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7647', 'Thuin', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7648', 'Tournai', '428');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7649', 'Amay', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7650', 'Amel', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7651', 'Angleur', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7652', 'Ans', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7653', 'Anthisnes', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7654', 'Aubel', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7655', 'Awans', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7656', 'Aywaille', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7657', 'Baelen', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7658', 'Bassenge', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7659', 'Berloz', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7660', 'Beyne-Heusay', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7661', 'Blegny', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7662', 'Braives', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7663', 'Bullingen', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7664', 'Burdinne', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7665', 'Burg-Reuland', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7666', 'Butgenbach', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7667', 'Chaudfontaine', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7668', 'Clavier', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7669', 'Comblain-au-Pont', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7670', 'Crisnee', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7671', 'Dalhem', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7672', 'Dison', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7673', 'Donceel', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7674', 'Engis', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7675', 'Esneux', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7676', 'Eupen', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7677', 'Faimes', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7678', 'Ferrieres', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7679', 'Fexhe-le-Haut-Clocher', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7680', 'Flemalle', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7681', 'Fleron', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7682', 'Geer', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7683', 'Grace-Hollogne', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7684', 'Hamoir', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7685', 'Hannut', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7686', 'Heron', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7687', 'Herstal', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7688', 'Herve', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7689', 'Huy', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7690', 'Jalhay', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7691', 'Juprelle', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7692', 'Kelmis', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7693', 'Liege', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7694', 'Lierneux', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7695', 'Limbourg', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7696', 'Lincent', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7697', 'Lontzen', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7698', 'Malmedy', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7699', 'Marchin', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7700', 'Modave', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7701', 'Montzen', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7702', 'Nandrin', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7703', 'Neupre', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7704', 'Olne', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7705', 'Oreye', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7706', 'Ouffet', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7707', 'Oupeye', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7708', 'Pepinster', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7709', 'Plombieres', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7710', 'Racour', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7711', 'Raeren', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7712', 'Remicourt', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7713', 'Saint-Georges-sur-Meuse', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7714', 'Saint-Nicolas', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7715', 'Sankt Vith', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7716', 'Seraing', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7717', 'Soumagne', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7718', 'Spa', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7719', 'Sprimont', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7720', 'Stavelot', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7721', 'Stoumont', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7722', 'Theux', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7723', 'Thimister-Clermont', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7724', 'Tinlot', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7725', 'Trois-Ponts', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7726', 'Trooz', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7727', 'Verlaine', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7728', 'Verviers', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7729', 'Villers-le-Bouillet', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7730', 'Vise', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7731', 'Waimes', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7732', 'Wanze', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7733', 'Waremme', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7734', 'Wasseiges', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7735', 'Welkenraedt', '429');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7736', 'Alken', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7737', 'As', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7738', 'Beringen', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7739', 'Bilzen', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7740', 'Bocholt', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7741', 'Borgloon', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7742', 'Bree', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7743', 'Diepenbeek', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7744', 'Dilsen-Stokkem', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7745', 'Genk', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7746', 'Gingelom', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7747', 'Halen', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7748', 'Ham', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7749', 'Hamont-Achel', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7750', 'Hasselt', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7751', 'Hechtel-Eksel', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7752', 'Heers', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7753', 'Herk-de-Stad', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7754', 'Herstappe', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7755', 'Heusden-Zolder', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7756', 'Hoeselt', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7757', 'Houthalen-Helchteren', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7758', 'Kinrooi', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7759', 'Kortessem', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7760', 'Kuringen', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7761', 'Lanaken', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7762', 'Leopoldsburg', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7763', 'Lommel', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7764', 'Lummen', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7765', 'Maaseik', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7766', 'Maasmechelen', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7767', 'Meeuwen-Gruitrode', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7768', 'Neerpelt', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7769', 'Nieuwerkerken', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7770', 'Opglabbeek', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7771', 'Overpelt', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7772', 'Peer', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7773', 'Riemst', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7774', 'Sint-Truiden', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7775', 'Tessenderlo', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7776', 'Tongeren', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7777', 'Voeren', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7778', 'Wellen', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7779', 'Zonhoven', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7780', 'Zutendaal', '430');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7781', 'Arlon', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7782', 'Attert', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7783', 'Aubange', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7784', 'Bastogne', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7785', 'Bertogne', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7786', 'Bertrix', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7787', 'Bouillon', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7788', 'Chiny', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7789', 'Daverdisse', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7790', 'Durbuy', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7791', 'Erezee', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7792', 'Etalle', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7793', 'Fauvillers', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7794', 'Florenville', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7795', 'Gouvy', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7796', 'Grapfontaine', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7797', 'Habay', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7798', 'Herbeumont', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7799', 'Hotton', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7800', 'Houffalize', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7801', 'La Roche-en-Ardenne', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7802', 'Leglise', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7803', 'Libin', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7804', 'Libramont-Chevigny', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7805', 'Manhay', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7806', 'Marche-en-Famenne', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7807', 'Marloie', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7808', 'Martelange', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7809', 'Meix-devant-Virton', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7810', 'Messancy', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7811', 'Musson', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7812', 'Nassogne', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7813', 'Neufchateau', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7814', 'Paliseul', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7815', 'Rendeux', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7816', 'Rouvroy', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7817', 'Saint-Hubert', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7818', 'Saint-Leger', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7819', 'Sainte-Ode', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7820', 'Tellin', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7821', 'Tenneville', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7822', 'Tintigny', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7823', 'Vaux-sur-Sure', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7824', 'Vielsalm', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7825', 'Virton', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7826', 'Wellin', '431');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7827', 'Andenne', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7828', 'Anhee', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7829', 'Assesse', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7830', 'Beauraing', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7831', 'Bievre', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7832', 'Cerfontaine', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7833', 'Ciney', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7834', 'Couvin', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7835', 'Dinant', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7836', 'Doische', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7837', 'Eghezee', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7838', 'Fernelmont', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7839', 'Floreffe', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7840', 'Florennes', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7841', 'Fosses-la-Ville', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7842', 'Gedinne', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7843', 'Gembloux', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7844', 'Gesves', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7845', 'Hamois', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7846', 'Hastiere', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7847', 'Havelange', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7848', 'Houyet', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7849', 'Jambes', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7850', 'Jemeppe-sur-Sambre', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7851', 'La Bruyere', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7852', 'Malonne', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7853', 'Mettet', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7854', 'Namur', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7855', 'Ohey', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7856', 'Onhaye', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7857', 'Philippeville', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7858', 'Profondeville', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7859', 'Rochefort', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7860', 'Sambreville', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7861', 'Sombreffe', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7862', 'Somme-Leuze', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7863', 'Suarlee', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7864', 'Viroinval', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7865', 'Vresse-sur-Semois', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7866', 'Walcourt', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7867', 'Yvoir', '432');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7868', 'Gullegem', '433');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7869', 'Langdorp', '433');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7870', 'Aalst', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7871', 'Aalter', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7872', 'Assenede', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7873', 'Berlare', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7874', 'Beveren', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7875', 'Brakel', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7876', 'Buggenhout', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7877', 'De Pinte', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7878', 'Deinze', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7879', 'Denderleeuw', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7880', 'Dendermonde', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7881', 'Destelbergen', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7882', 'Drongen', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7883', 'Eeklo', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7884', 'Erembodegem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7885', 'Erpe-Mere', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7886', 'Evergem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7887', 'Gavere', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7888', 'Gent', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7889', 'Geraardsbergen', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7890', 'Ghent', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7891', 'Haaltert', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7892', 'Hamme', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7893', 'Herzele', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7894', 'Horebeke', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7895', 'Kaprijke', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7896', 'Kerksken', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7897', 'Kluisbergen', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7898', 'Knesselare', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7899', 'Kruibeke', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7900', 'Kruishoutem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7901', 'Laarne', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7902', 'Lebbeke', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7903', 'Lede', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7904', 'Lierde', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7905', 'Lochristi', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7906', 'Lokeren', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7907', 'Lovendegem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7908', 'Maarkedal', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7909', 'Maldegem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7910', 'Melle', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7911', 'Merelbeke', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7912', 'Moerbeke', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7913', 'Nazareth', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7914', 'Nevele', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7915', 'Ninove', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7916', 'Oosterzele', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7917', 'Oudenaarde', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7918', 'Ronse', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7919', 'Semmerzake', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7920', 'Sint-Gillis-Waas', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7921', 'Sint-Laureins', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7922', 'Sint-Lievens-Houtem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7923', 'Sint-Martens-Latem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7924', 'Sint-Niklaas', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7925', 'Stekene', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7926', 'Temse', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7927', 'Waarschoot', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7928', 'Waasmunster', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7929', 'Wachtebeke', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7930', 'Wetteren', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7931', 'Wichelen', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7932', 'Wortegem-Petegem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7933', 'Zele', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7934', 'Zelzate', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7935', 'Zingem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7936', 'Zomergem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7937', 'Zottegem', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7938', 'Zulte', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7939', 'Zwalm', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7940', 'Zwijnaarde', '434');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7941', 'Aarschot', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7942', 'Affligem', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7943', 'Asse', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7944', 'Beersel', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7945', 'Begijnendijk', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7946', 'Bekkevoort', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7947', 'Bertem', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7948', 'Bever', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7949', 'Bierbeek', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7950', 'Boortmeerbeek', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7951', 'Boutersem', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7952', 'Diest', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7953', 'Dilbeek', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7954', 'Drogenbos', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7955', 'Galmaarden', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7956', 'Geetbets', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7957', 'Glabbeek', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7958', 'Gooik', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7959', 'Grimbergen', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7960', 'Haacht', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7961', 'Halle', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7962', 'Herent', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7963', 'Herne', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7964', 'Hoegaarden', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7965', 'Hoeilaart', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7966', 'Holsbeek', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7967', 'Huldenberg', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7968', 'Kampenhout', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7969', 'Kapelle-op-den-Bos', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7970', 'Keerbergen', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7971', 'Kortenaken', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7972', 'Kortenberg', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7973', 'Kraainem', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7974', 'Landen', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7975', 'Lennik', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7976', 'Leuven', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7977', 'Liedekerke', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7978', 'Linkebeek', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7979', 'Linter', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7980', 'Londerzeel', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7981', 'Lubbeek', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7982', 'Machelen', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7983', 'Meise', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7984', 'Merchtem', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7985', 'Opwijk', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7986', 'Oud-Heverlee', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7987', 'Overijse', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7988', 'Pepingen', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7989', 'Roosdaal', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7990', 'Rotselaar', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7991', 'Scherpenheuvel-Zichem', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7992', 'Sint-Genesius-Rode', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7993', 'Sint-Pieters-Leeuw', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7994', 'Steenokkerzeel', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7995', 'Ternat', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7996', 'Tervuren', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7997', 'Tielt-Winge', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7998', 'Tienen', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('7999', 'Tremelo', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8000', 'Vilvoorde', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8001', 'Wemmel', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8002', 'Wezembeek-Oppem', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8003', 'Zaventem', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8004', 'Zemst', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8005', 'Zoutleeuw', '436');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8006', 'Callenelle', '437');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8007', 'Marcinelle', '437');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8008', 'Strepy-Bracquegnies', '437');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8009', 'Alveringem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8010', 'Anzegem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8011', 'Ardooie', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8012', 'Avelgem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8013', 'Beernem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8014', 'Blankenberge', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8015', 'Bredene', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8016', 'Brugge', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8017', 'Damme', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8018', 'De Haan', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8019', 'De Panne', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8020', 'Deerlijk', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8021', 'Dentergem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8022', 'Diksmuide', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8023', 'Geluveld', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8024', 'Gistel', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8025', 'Harelbeke', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8026', 'Heuvelland', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8027', 'Hooglede', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8028', 'Houthulst', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8029', 'Ichtegem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8030', 'Ieper', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8031', 'Ingelmunster', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8032', 'Ingooigem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8033', 'Izegem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8034', 'Jabbeke', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8035', 'Knokke-Heist', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8036', 'Koekelare', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8037', 'Koksijde', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8038', 'Kortemark', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8039', 'Kortrijk', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8040', 'Kuurne', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8041', 'Langemark-Poelkapelle', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8042', 'Ledegem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8043', 'Lendelede', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8044', 'Lichtervelde', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8045', 'Lo-Reninge', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8046', 'Menen', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8047', 'Mesen', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8048', 'Meulebeke', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8049', 'Middelkerke', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8050', 'Moorslede', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8051', 'Nieuwpoort', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8052', 'Oostende', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8053', 'Oostkamp', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8054', 'Oostrozebeke', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8055', 'Oudenburg', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8056', 'Pittem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8057', 'Poperinge', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8058', 'Roeselare', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8059', 'Ruiselede', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8060', 'Spiere-Helkijn', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8061', 'Staden', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8062', 'Tielt', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8063', 'Torhout', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8064', 'Veurne', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8065', 'Vleteren', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8066', 'Waregem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8067', 'Wervik', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8068', 'Wevelgem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8069', 'Wielsbeke', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8070', 'Wingene', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8071', 'Zedelgem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8072', 'Zeebrugge', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8073', 'Zonnebeke', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8074', 'Zuienkerke', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8075', 'Zwevegem', '438');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8076', 'Belize', '439');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8077', 'San Pedro', '439');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8078', 'Belmopan', '440');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8079', 'Benque Viejo', '440');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8080', 'San Ignacio', '440');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8081', 'Corozal', '441');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8082', 'Punta Gorda', '444');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8083', 'Kandi', '445');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8084', 'Malanville', '445');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8085', 'Batia', '446');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8086', 'Boukombe', '446');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8087', 'Kouande', '446');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8088', 'Natitingou', '446');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8089', 'Allada', '447');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8090', 'Cotonou', '447');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8091', 'Ouidah', '447');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8092', 'Tanguiete', '447');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8093', 'Bembereke', '448');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8094', 'Nikki', '448');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8095', 'Parakou', '448');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8096', 'Tchaourou', '448');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8097', 'Dassa', '449');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8098', 'Savalou', '449');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8099', 'Save', '449');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8100', 'Aplahoue', '450');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8101', 'Dogbo', '450');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8102', 'Djougou', '451');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8103', 'Cotonou', '452');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8104', 'Athieme', '453');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8105', 'Come', '453');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8106', 'Grand Popo', '453');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8107', 'Lokossa', '453');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8108', 'Adjohoun', '454');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8109', 'Porto Novo', '454');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8110', 'Ketou', '455');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8111', 'Pobe', '455');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8112', 'Sakete', '455');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8113', 'Abomey', '456');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8114', 'Bohicon', '456');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8115', 'Cove', '456');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8116', 'Zagnanado', '456');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8117', 'Hamilton', '457');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8118', 'Jakar', '459');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8119', 'Chhukha', '460');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8120', 'Phuentsholing', '460');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8121', 'Damphu', '461');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8122', 'Taga Dzong', '462');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8123', 'Geylegphug', '463');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8124', 'Ha', '464');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8125', 'Lhuntshi', '465');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8126', 'Mongar', '466');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8127', 'Pemagatsel', '467');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8128', 'Gasa', '468');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8129', 'Punakha', '468');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8130', 'Paro', '469');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8131', 'Phuntsholing', '470');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8132', 'Samchi', '470');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8133', 'Shemgang', '472');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8134', 'Tashigang', '473');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8135', 'Thimphu', '474');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8136', 'Timphu', '474');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8137', 'Tongsa', '475');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8138', 'Wangdiphodrang', '476');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8139', 'Guayaramerin', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8140', 'Magdalena', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8141', 'Reyes', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8142', 'Riberalta', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8143', 'Rurrenabaque', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8144', 'San Borja', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8145', 'San Ignacio', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8146', 'San Ramon', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8147', 'Santa Ana', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8148', 'Santa Rosa', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8149', 'Trinidad', '477');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8150', 'Camargo', '478');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8151', 'Monteagudo', '478');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8152', 'Muyupampa', '478');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8153', 'Padilla', '478');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8154', 'Sucre', '478');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8155', 'Tarabuco', '478');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8156', 'Villa Serano', '478');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8157', 'Aiquile', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8158', 'Arani', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8159', 'Capinota', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8160', 'Chimore', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8161', 'Cliza', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8162', 'Cochabamba', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8163', 'Colomi', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8164', 'Entre Rios', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8165', 'Irpa Irpa', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8166', 'Ivirgarzama', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8167', 'Mizque', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8168', 'Punata', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8169', 'Shinahota', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8170', 'Sipe Sipe', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8171', 'Tarata', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8172', 'Ucurena', '479');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8173', 'Caracollo', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8174', 'Challapata', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8175', 'Eucaliptus', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8176', 'Huanuni', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8177', 'Machacamarca', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8178', 'Oruro', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8179', 'Poopo', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8180', 'Santiago de Huari', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8181', 'Totoral', '481');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8182', 'Cobija', '482');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8183', 'Atocha', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8184', 'Betanzos', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8185', 'Colquechaca', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8186', 'Llallagua', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8187', 'Potosi', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8188', 'Santa Barbara', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8189', 'Tupiza', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8190', 'Uncia', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8191', 'Uyuni', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8192', 'Villazon', '483');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8193', 'Bermejo', '485');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8194', 'Entre Rios', '485');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8195', 'San Lorenzo', '485');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8196', 'Tarija', '485');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8197', 'Villamontes', '485');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8198', 'Yacuiba', '485');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8199', 'Kachikau', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8200', 'Kasane', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8201', 'Kavimba', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8202', 'Kazungula', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8203', 'Lesoma', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8204', 'Muchinje-Mabale', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8205', 'Pandamatenga', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8206', 'Pandamatenga Botswana Defence ', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8207', 'Parakarungu', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8208', 'Satau', '493');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8209', 'Francistown', '494');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8210', 'Gaborone', '495');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8211', 'Bere', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8212', 'Charles Hill', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8213', 'Chobokwane', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8214', 'Dekar', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8215', 'East Hanahai', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8216', 'Ghanzi', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8217', 'Groote Laagte', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8218', 'Kacgae', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8219', 'Karakobis', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8220', 'Kuke Quarantine Camp', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8221', 'Kule', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8222', 'Makunda', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8223', 'Ncojane', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8224', 'New Xade', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8225', 'New Xanagas', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8226', 'Qabo', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8227', 'Tsootsha', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8228', 'West Hanahai', '496');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8229', 'Jwaneng', '497');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8230', 'Artisia', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8231', 'Bokaa', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8232', 'Dikgonye', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8233', 'Dikwididi', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8234', 'Kgomodiatshaba', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8235', 'Khurutshe', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8236', 'Leshibitse', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8237', 'Mabalane', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8238', 'Malolwane', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8239', 'Malotwana Siding', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8240', 'Matebeleng', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8241', 'Mmamashia', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8242', 'Mmathubudukwane', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8243', 'Mochudi', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8244', 'Modipane', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8245', 'Morwa', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8246', 'Oliphants Drift', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8247', 'Oodi', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8248', 'Pilane', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8249', 'Ramonaka', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8250', 'Ramotlabaki', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8251', 'Rasesa', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8252', 'Sikwane', '500');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8253', 'Boatlaname', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8254', 'Botlhapatlou', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8255', 'Diagane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8256', 'Diphudugodu', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8257', 'Diremogolo Lands', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8258', 'Ditshegwane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8259', 'Ditshukudu', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8260', 'Dumadumane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8261', 'Dutlwe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8262', 'Gabane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8263', 'Gakgatla', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8264', 'Gakuto', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8265', 'Galekgatshwane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8266', 'Gamodubu', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8267', 'Gaphatshwa', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8268', 'Hatsalatladi', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8269', 'Kamenakwe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8270', 'Kaudwane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8271', 'Kgaphamadi', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8272', 'Kgope', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8273', 'Khekhenya-Chepetese', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8274', 'Khudumelapye', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8275', 'Kopong', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8276', 'Kotolaname', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8277', 'Kubung', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8278', 'Kumakwane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8279', 'Kweneng', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8280', 'Lentsweletau', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8281', 'Lephepe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8282', 'Lesirane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8283', 'Letlhakeng', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8284', 'Losilakgokong', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8285', 'Maboane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8286', 'Mahetlwe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8287', 'Makabanyane-Dikgokong', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8288', 'Malwelwe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8289', 'Mamhiko', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8290', 'Manaledi', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8291', 'Mantshwabisi', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8292', 'Marejwane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8293', 'Masebele', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8294', 'Medie', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8295', 'Metsibotlhoko', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8296', 'Metsimotlhaba', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8297', 'Mmakanke', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8298', 'Mmankgodi', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8299', 'Mmanoko', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8300', 'Mmokolodi', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8301', 'Mmopane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8302', 'Mmopane Lands', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8303', 'Mogoditshane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8304', 'Mogoditshane Botswana Defence ', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8305', 'Mogoditshane Lands', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8306', 'Mogonono', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8307', 'Molepolole', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8308', 'Mononyane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8309', 'Monwane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8310', 'Morabane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8311', 'Morope', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8312', 'Moshaweng', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8313', 'Mosokotswe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8314', 'Motokwe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8315', 'Ngware', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8316', 'Nkoyaphiri', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8317', 'Ramaphatlhe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8318', 'Salajwe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8319', 'Serinane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8320', 'Sesung', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8321', 'Shadishadi', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8322', 'Sojwe', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8323', 'Sorilatholo', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8324', 'Suping', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8325', 'Takatokwane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8326', 'Thamaga', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8327', 'Thebephatshwa', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8328', 'Tlowaneng', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8329', 'Tsetseng', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8330', 'Tswaane', '501');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8331', 'Lobatse', '502');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8332', 'Bodibeng', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8333', 'Boro', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8334', 'Botlhatlogo', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8335', 'Chanoga', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8336', 'Chuchubega', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8337', 'Daonara', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8338', 'Ditshiping', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8339', 'Habu', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8340', 'Jao', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8341', 'Kareng', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8342', 'Katamaga', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8343', 'Kgakge', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8344', 'Khwai Camp', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8345', 'Komana', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8346', 'Legotlhwana', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8347', 'Mababe', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8348', 'Makalamabedi', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8349', 'Matlapana', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8350', 'Matsaudi', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8351', 'Mawana', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8352', 'Mokgalo-Haka', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8353', 'Morutsha', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8354', 'Nxharaga', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8355', 'Phuduhudu', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8356', 'Samodupi', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8357', 'Sankuyo', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8358', 'Sehithwa', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8359', 'Semboyo', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8360', 'Sexaxa', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8361', 'Shakawe', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8362', 'Shorobe', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8363', 'Somela', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8364', 'Toteng', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8365', 'Tsanekona', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8366', 'Tsao', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8367', 'Xaxaba', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8368', 'Xhobe', '503');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8369', 'Bethel', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8370', 'Borobadilepe', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8371', 'Diabo', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8372', 'Digawana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8373', 'Dikhukhung', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8374', 'Dinatshana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8375', 'Dipotsana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8376', 'Ditlharapa', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8377', 'Gamajalela', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8378', 'Gasita', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8379', 'Gathwane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8380', 'Good Hope', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8381', 'Goora-seno', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8382', 'Gopong', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8383', 'Hebron', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8384', 'Itholoke', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8385', 'Kanaku', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8386', 'Kangwe', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8387', 'Kanye', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8388', 'Keng', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8389', 'Kgomokasitwa', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8390', 'Kgoro', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8391', 'Khakhea', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8392', 'Khonkhwa', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8393', 'Kokong', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8394', 'Lehoko', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8395', 'Lejwana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8396', 'Lekgolobotlo', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8397', 'Leporung', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8398', 'Logagane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8399', 'Lorolwana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8400', 'Lorwana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8401', 'Lotlhakane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8402', 'Lotlhakane West', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8403', 'Mabule', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8404', 'Mabutsane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8405', 'Madingwana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8406', 'Magoriapitse', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8407', 'Magotlhawane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8408', 'Mahotshwane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8409', 'Maisane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8410', 'Makokwe', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8411', 'Malokaganyane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8412', 'Manyana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8413', 'Maokane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8414', 'Marojane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8415', 'Maruswa', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8416', 'Metlobo', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8417', 'Metlojane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8418', 'Mmakgori', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8419', 'Mmathethe', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8420', 'Mogojogojo', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8421', 'Mogonye', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8422', 'Mogwalale', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8423', 'Mokatako', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8424', 'Mokgomane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8425', 'Mokhomba', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8426', 'Molapowabojang', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8427', 'Molete', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8428', 'Morwamosu', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8429', 'Moshaneng', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8430', 'Moshupa', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8431', 'Motlhwatse', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8432', 'Motsentshe', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8433', 'Musi', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8434', 'Ngwatsau', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8435', 'Ntlhantlhe', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8436', 'Papatlo', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8437', 'Phihitshwane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8438', 'Pitsana-Potokwe', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8439', 'Pitsane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8440', 'Pitseng-Ralekgetho', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8441', 'Pitshane Molopo', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8442', 'Rakhuna', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8443', 'Ralekgetho', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8444', 'Ramatlabama', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8445', 'Ranaka', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8446', 'Sedibeng', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8447', 'Segakwana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8448', 'Segwagwa', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8449', 'Seherelela', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8450', 'Sekhutlane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8451', 'Sekoma', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8452', 'Selokolela', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8453', 'Semane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8454', 'Sese', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8455', 'Sesung', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8456', 'Sheep Farm', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8457', 'Tlhankane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8458', 'Tlhareseleele', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8459', 'Tshidilamolomo', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8460', 'Tshwaane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8461', 'Tsonyane', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8462', 'Tswaaneng', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8463', 'Tswagare-Lothoje-Lokalana', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8464', 'Tswanyaneng', '504');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8465', 'Beetsha', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8466', 'Eretsha', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8467', 'Etsha 1', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8468', 'Etsha 13', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8469', 'Etsha 6', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8470', 'Etsha 8', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8471', 'Etsha 9', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8472', 'Gane', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8473', 'Gonutsuga', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8474', 'Gowe', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8475', 'Gudingwa', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8476', 'Gumare', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8477', 'Ikoga', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8478', 'Kajaja', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8479', 'Kapotora Lands', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8480', 'Kauxwhi', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8481', 'Matswee', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8482', 'Maun', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8483', 'Moaha', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8484', 'Mohembo East', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8485', 'Mohembo West', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8486', 'Mokgacha', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8487', 'Ngarange', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8488', 'Nokaneng', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8489', 'Nxamasere', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8490', 'Nxaunxau', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8491', 'Nxwee', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8492', 'Qangwa', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8493', 'Roye', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8494', 'Samochema', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8495', 'Sekondomboro', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8496', 'Sepopa', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8497', 'Seronga', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8498', 'Shaowe', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8499', 'Tobere Lands', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8500', 'Tubu', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8501', 'Tubu Lands', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8502', 'Xadau', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8503', 'Xakao', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8504', 'Xaxa', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8505', 'Xhauga', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8506', 'Xurube', '506');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8507', 'Orapa', '507');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8508', 'Sowa', '510');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8509', 'Acrelandia', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8510', 'Brasileia', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8511', 'Cruzeiro do Sul', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8512', 'Epitaciolandia', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8513', 'Feijo', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8514', 'Mancio Lima', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8515', 'Manoel Urbano', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8516', 'Marechal Thaumaturgo', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8517', 'Placido de Castro', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8518', 'Porto Walter', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8519', 'Rio Branco', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8520', 'Rodrigues Alves', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8521', 'Sena Madureira', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8522', 'Senador Guiomard', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8523', 'Tarauaca', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8524', 'Xapuri', '512');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8525', 'Agua Branca', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8526', 'Anadia', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8527', 'Arapiraca', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8528', 'Atalaia', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8529', 'Barra de Santo Antonio', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8530', 'Batalha', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8531', 'Boca da Mata', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8532', 'Cacimbinhas', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8533', 'Cajueiro', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8534', 'Campo Alegre', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8535', 'Campo Grande', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8536', 'Canapi', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8537', 'Capela', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8538', 'Coite do Noia', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8539', 'Colonia Leopoldina', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8540', 'Coruripe', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8541', 'Craibas', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8542', 'Delmiro Gouveia', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8543', 'Dois Riachos', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8544', 'Estrela de Alagoas', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8545', 'Feira Grande', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8546', 'Flexeiras', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8547', 'Girau do Ponciano', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8548', 'Ibateguara', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8549', 'Igaci', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8550', 'Igreja Nova', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8551', 'Inhapi', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8552', 'Joaquim Gomes', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8553', 'Jundia', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8554', 'Junqueiro', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8555', 'Lagoa da Canoa', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8556', 'Limoeiro de Anadia', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8557', 'Maceio', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8558', 'Major Isidoro', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8559', 'Maragogi', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8560', 'Maravilha', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8561', 'Marechal Deodoro', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8562', 'Maribondo', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8563', 'Mata Grande', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8564', 'Matriz de Camaragibe', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8565', 'Messias', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8566', 'Minador do Negrao', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8567', 'Murici', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8568', 'Novo Lino', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8569', 'Olho d\'Agua das Flores', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8570', 'Olivenca', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8571', 'Palmeira dos Indios', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8572', 'Pao de Acucar', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8573', 'Passo de Camaragibe', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8574', 'Penedo', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8575', 'Piacabucu', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8576', 'Pilar', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8577', 'Piranhas', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8578', 'Poco das Trincheiras', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8579', 'Porto Calvo', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8580', 'Porto Real do Colegio', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8581', 'Quebrangulo', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8582', 'Rio Largo', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8583', 'Santana do Ipanema', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8584', 'Santana do Mundau', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8585', 'Sao Jose da Laje', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8586', 'Sao Jose da Tapera', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8587', 'Sao Luis do Quitunde', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8588', 'Sao Miguel dos Campos', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8589', 'Sao Sebastiao', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8590', 'Satuba', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8591', 'Senador Rui Palmeira', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8592', 'Taquarana', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8593', 'Teotonio Vilela', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8594', 'Traipu', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8595', 'Uniao dos Palmares', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8596', 'Vicosa', '513');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8597', 'Amapa', '514');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8598', 'Laranjal do Jari', '514');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8599', 'Macapa', '514');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8600', 'Mazagao', '514');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8601', 'Oiapoque', '514');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8602', 'Santana', '514');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8603', 'Alvaraes', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8604', 'Anori', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8605', 'Apui', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8606', 'Autazes', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8607', 'Barcelos', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8608', 'Barreirinha', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8609', 'Benjamin Constant', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8610', 'Boca do Acre', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8611', 'Borba', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8612', 'Canutama', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8613', 'Carauari', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8614', 'Careiro', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8615', 'Careiro da Varzea', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8616', 'Coari', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8617', 'Codajas', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8618', 'Eirunepe', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8619', 'Envira', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8620', 'Fonte Boa', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8621', 'Guajara', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8622', 'Humaita', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8623', 'Ipixuna', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8624', 'Iranduba', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8625', 'Itacoatiara', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8626', 'Japura', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8627', 'Jutai', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8628', 'Labrea', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8629', 'Manacapuru', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8630', 'Manaquiri', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8631', 'Manaus', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8632', 'Manicore', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8633', 'Maraa', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8634', 'Maues', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8635', 'Nhamunda', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8636', 'Nova Olinda do Norte', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8637', 'Novo Airao', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8638', 'Novo Aripuana', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8639', 'Parintins', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8640', 'Pauini', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8641', 'Rio Preto da Eva', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8642', 'Santa Isabel do Rio Negro', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8643', 'Santo Antonio do Ica', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8644', 'Sao Gabriel da Cachoeira', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8645', 'Sao Paulo de Olivenca', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8646', 'Tabatinga', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8647', 'Tapaua', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8648', 'Tefe', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8649', 'Tonantins', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8650', 'Uarini', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8651', 'Urucara', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8652', 'Urucurituba', '515');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8653', 'Acajutiba', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8654', 'Alagoinhas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8655', 'Amargosa', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8656', 'Amelia Rodrigues', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8657', 'America Dourada', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8658', 'Anage', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8659', 'Araci', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8660', 'Aurelino Leal', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8661', 'Baixa Grande', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8662', 'Barra', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8663', 'Barra da Estiva', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8664', 'Barra do Choca', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8665', 'Barreiras', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8666', 'Belmonte', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8667', 'Boa Vista do Tupim', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8668', 'Bom Jesus da Lapa', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8669', 'Boquira', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8670', 'Brumado', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8671', 'Buerarema', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8672', 'Cachoeira', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8673', 'Cacule', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8674', 'Caetite', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8675', 'Cafarnaum', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8676', 'Camacan', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8677', 'Camacari', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8678', 'Camamu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8679', 'Campo Alegre de Lourdes', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8680', 'Campo Formoso', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8681', 'Canarana', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8682', 'Canavieiras', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8683', 'Candeias', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8684', 'Candido Sales', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8685', 'Cansancao', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8686', 'Capim Grosso', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8687', 'Caravelas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8688', 'Carinhanha', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8689', 'Casa Nova', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8690', 'Castro Alves', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8691', 'Catu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8692', 'Cicero Dantas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8693', 'Cipo', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8694', 'Coaraci', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8695', 'Conceicao da Feira', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8696', 'Conceicao do Almeida', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8697', 'Conceicao do Coite', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8698', 'Conceicao do Jacuipe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8699', 'Conde', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8700', 'Coracao de Maria', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8701', 'Coronel Joao Sa', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8702', 'Correntina', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8703', 'Cruz das Almas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8704', 'Curaca', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8705', 'Dias d\'Avila', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8706', 'Encruzilhada', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8707', 'Entre Rios', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8708', 'Esplanada', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8709', 'Euclides da Cunha', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8710', 'Eunapolis', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8711', 'Feira de Santana', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8712', 'Filadelfia', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8713', 'Formosa do Rio Preto', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8714', 'Gandu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8715', 'Guanambi', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8716', 'Guaratinga', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8717', 'Iacu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8718', 'Ibicarai', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8719', 'Ibicui', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8720', 'Ibipeba', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8721', 'Ibirapitanga', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8722', 'Ibirataia', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8723', 'Ibotirama', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8724', 'Iguai', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8725', 'Ilheus', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8726', 'Inhambupe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8727', 'Ipiau', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8728', 'Ipira', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8729', 'Iraquara', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8730', 'Irara', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8731', 'Irece', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8732', 'Itabela', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8733', 'Itaberaba', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8734', 'Itabuna', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8735', 'Itacare', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8736', 'Itagi', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8737', 'Itagiba', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8738', 'Itajuipe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8739', 'Itamaraju', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8740', 'Itambe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8741', 'Itanhem', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8742', 'Itaparica', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8743', 'Itapetinga', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8744', 'Itapicuru', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8745', 'Itarantim', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8746', 'Itirucu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8747', 'Itiuba', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8748', 'Itororo', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8749', 'Ituacu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8750', 'Itubera', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8751', 'Jacobina', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8752', 'Jaguaquara', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8753', 'Jaguarari', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8754', 'Jequie', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8755', 'Jeremoabo', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8756', 'Jitauna', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8757', 'Joao Dourado', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8758', 'Juazeiro', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8759', 'Jussara', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8760', 'Laje', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8761', 'Lapao', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8762', 'Lauro de Freitas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8763', 'Livramento', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8764', 'Macarani', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8765', 'Macaubas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8766', 'Madre de Deus', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8767', 'Mairi', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8768', 'Maracas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8769', 'Maragogipe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8770', 'Marau', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8771', 'Mascote', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8772', 'Mata de Sao Joao', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8773', 'Medeiros Neto', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8774', 'Miguel Calmon', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8775', 'Milagres', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8776', 'Monte Santo', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8777', 'Morro de Chapeu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8778', 'Mucuri', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8779', 'Mundo Novo', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8780', 'Muritiba', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8781', 'Mutuipe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8782', 'Nazare', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8783', 'Nova Soure', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8784', 'Nova Vicosa', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8785', 'Olindina', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8786', 'Oliveira dos Brejinhos', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8787', 'Palmas de Monte Alto', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8788', 'Paramirim', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8789', 'Paratinga', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8790', 'Paripiranga', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8791', 'Pau Brasil', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8792', 'Paulo Afonso', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8793', 'Pilao Arcado', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8794', 'Pindobacu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8795', 'Piritiba', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8796', 'Planalto', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8797', 'Pocoes', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8798', 'Pojuca', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8799', 'Ponto Novo', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8800', 'Porto Seguro', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8801', 'Prado', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8802', 'Presidente Tancredo Neves', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8803', 'Queimadas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8804', 'Quijingue', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8805', 'Rafael Jambeiro', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8806', 'Remanso', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8807', 'Riachao das Neves', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8808', 'Riachao do Jacuipe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8809', 'Riacho de Santana', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8810', 'Ribeira do Pombal', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8811', 'Rio Real', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8812', 'Ruy Barbosa', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8813', 'Salvador', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8814', 'Santa Cruz Cabralia', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8815', 'Santa Ines', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8816', 'Santa Maria da Vitoria', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8817', 'Santa Rita de Cassia', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8818', 'Santaluz', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8819', 'Santana', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8820', 'Santo Amaro', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8821', 'Santo Antonio de Jesus', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8822', 'Santo Estevao', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8823', 'Sao Desiderio', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8824', 'Sao Felipe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8825', 'Sao Francisco do Conde', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8826', 'Sao Gabriel', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8827', 'Sao Goncalo dos Campos', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8828', 'Sao Sebastiao do Passe', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8829', 'Saubara', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8830', 'Seabra', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8831', 'Senhor do Bonfim', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8832', 'Sento Se', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8833', 'Serra Dourada', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8834', 'Serra do Ramalho', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8835', 'Serrinha', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8836', 'Simoes Filho', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8837', 'Sobradinho', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8838', 'Souto Soares', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8839', 'Tanhacu', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8840', 'Taperoa', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8841', 'Tapiramuta', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8842', 'Teixeira de Freitas', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8843', 'Teofilandia', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8844', 'Terra Nova', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8845', 'Tremedal', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8846', 'Tucano', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8847', 'Uaua', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8848', 'Ubaira', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8849', 'Ubaitaba', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8850', 'Ubata', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8851', 'Una', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8852', 'Urucuca', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8853', 'Utinga', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8854', 'Valenca', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8855', 'Valente', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8856', 'Vera Cruz', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8857', 'Vitoria da Conquista', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8858', 'Wenceslau Guimaraes', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8859', 'Xique-Xique', '516');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8860', 'Acarau', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8861', 'Acopiara', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8862', 'Amontada', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8863', 'Aquiraz', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8864', 'Aracati', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8865', 'Aracoiaba', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8866', 'Araripe', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8867', 'Assare', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8868', 'Aurora', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8869', 'Barbalha', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8870', 'Barro', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8871', 'Barroquinha', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8872', 'Baturite', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8873', 'Beberibe', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8874', 'Bela Cruz', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8875', 'Boa Viagem', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8876', 'Brejo Santo', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8877', 'Camocim', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8878', 'Campos Sales', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8879', 'Caninde', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8880', 'Carire', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8881', 'Caririacu', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8882', 'Cascavel', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8883', 'Caucaia', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8884', 'Cedro', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8885', 'Chorozinho', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8886', 'Coreau', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8887', 'Crateus', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8888', 'Crato', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8889', 'Cruz', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8890', 'Eusebio', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8891', 'Farias Brito', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8892', 'Forquilha', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8893', 'Fortaleza', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8894', 'Granja', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8895', 'Guaiuba', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8896', 'Guaraciaba do Norte', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8897', 'Hidrolandia', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8898', 'Horizonte', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8899', 'Ibiapina', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8900', 'Ico', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8901', 'Iguatu', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8902', 'Independencia', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8903', 'Ipu', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8904', 'Ipueiras', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8905', 'Iraucuba', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8906', 'Itaitinga', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8907', 'Itapage', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8908', 'Itapipoca', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8909', 'Itarema', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8910', 'Jaguaribe', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8911', 'Jaguaruana', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8912', 'Jardim', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8913', 'Juazeiro do Norte', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8914', 'Jucas', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8915', 'Lavras da Mangabeira', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8916', 'Limoeiro do Norte', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8917', 'Maracanau', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8918', 'Maranguape', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8919', 'Marco', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8920', 'Massape', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8921', 'Mauriti', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8922', 'Milagres', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8923', 'Missao Velha', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8924', 'Mombaca', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8925', 'Morada Nova', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8926', 'Nova Russas', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8927', 'Novo Oriente', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8928', 'Ocara', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8929', 'Oros', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8930', 'Pacajus', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8931', 'Pacatuba', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8932', 'Paracuru', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8933', 'Paraipaba', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8934', 'Parambu', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8935', 'Pedra Branca', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8936', 'Pentecoste', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8937', 'Quixada', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8938', 'Quixeramobim', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8939', 'Quixere', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8940', 'Redencao', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8941', 'Reriutaba', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8942', 'Russas', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8943', 'Santa Quiteria', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8944', 'Santana do Acarau', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8945', 'Sao Benedito', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8946', 'Sao Goncalo do Amarante', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8947', 'Senador Pompeu', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8948', 'Sobral', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8949', 'Tabuleiro do Norte', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8950', 'Tamboril', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8951', 'Taua', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8952', 'Tiangua', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8953', 'Trairi', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8954', 'Ubajara', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8955', 'Umirim', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8956', 'Uruburetama', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8957', 'Varjota', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8958', 'Varzea Alegre', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8959', 'Vicosa do Ceara', '517');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8960', 'Abadiania', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8961', 'Acreuna', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8962', 'Aguas Lindas de Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8963', 'Alexania', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8964', 'Anapolis', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8965', 'Anicuns', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8966', 'Aparecida de Goiania', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8967', 'Aragarcas', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8968', 'Bela Vista de Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8969', 'Bom Jesus de Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8970', 'Buriti Alegre', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8971', 'Cacu', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8972', 'Caiaponia', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8973', 'Caldas Novas', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8974', 'Campos Belos', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8975', 'Campos Verdes', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8976', 'Carmo do Rio Verde', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8977', 'Catalao', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8978', 'Cavalcante', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8979', 'Ceres', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8980', 'Cidade Ocidental', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8981', 'Cocalzinho de Coias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8982', 'Cristalina', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8983', 'Crixas', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8984', 'Doverlandia', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8985', 'Edeia', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8986', 'Firminopolis', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8987', 'Formosa', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8988', 'Goianapolis', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8989', 'Goianesia', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8990', 'Goiania', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8991', 'Goianira', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8992', 'Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8993', 'Goiatuba', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8994', 'Guapo', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8995', 'Hidrolandia', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8996', 'Iaciara', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8997', 'Indiara', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8998', 'Inhumas', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('8999', 'Ipameri', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9000', 'Ipora', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9001', 'Itaberai', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9002', 'Itapaci', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9003', 'Itapirapua', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9004', 'Itapuranga', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9005', 'Itumbiara', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9006', 'Jaragua', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9007', 'Jatai', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9008', 'Jussara', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9009', 'Luziania', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9010', 'Mara Rosa', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9011', 'Minacu', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9012', 'Mineiros', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9013', 'Morrinhos', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9014', 'Mozarlandia', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9015', 'Neropolis', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9016', 'Niquelandia', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9017', 'Nova Crixas', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9018', 'Novo Gama', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9019', 'Orizona', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9020', 'Padre Bernardo', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9021', 'Palmeiras de Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9022', 'Parauna', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9023', 'Petrolina de Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9024', 'Piracanjuba', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9025', 'Piranhas', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9026', 'Pirenopolis', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9027', 'Pires do Rio', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9028', 'Planaltina', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9029', 'Pontalina', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9030', 'Porangatu', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9031', 'Posse', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9032', 'Quirinopolis', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9033', 'Rialma', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9034', 'Rio Verde', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9035', 'Rubiataba', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9036', 'Santa Helena de Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9037', 'Santa Terezinha de Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9038', 'Santo Antonio do Descoberto', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9039', 'Sao Domingos', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9040', 'Sao Luis de Montes Belos', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9041', 'Sao Miguel do Araguaia', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9042', 'Sao Simao', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9043', 'Senador Canedo', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9044', 'Silvania', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9045', 'Trindade', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9046', 'Uruacu', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9047', 'Uruana', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9048', 'Valparaiso de Goias', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9049', 'Vianopolis', '521');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9050', 'Acailandia', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9051', 'Alcantara', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9052', 'Aldeias Altas', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9053', 'Alto Alegre do Pindare', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9054', 'Amarante do Maranhao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9055', 'Anajatuba', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9056', 'Araioses', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9057', 'Arame', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9058', 'Arari', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9059', 'Bacabal', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9060', 'Balsas', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9061', 'Barra do Corda', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9062', 'Barreirinhas', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9063', 'Bequimao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9064', 'Bom Jardim', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9065', 'Brejo', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9066', 'Buriti', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9067', 'Buriti Bravo', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9068', 'Buriticupu', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9069', 'Candido Mendes', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9070', 'Cantanhede', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9071', 'Carolina', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9072', 'Carutapera', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9073', 'Caxias', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9074', 'Chapadinha', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9075', 'Codo', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9076', 'Coelho Neto', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9077', 'Colinas', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9078', 'Coroata', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9079', 'Cururupu', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9080', 'Davinopolis', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9081', 'Dom Pedro', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9082', 'Esperantinopolis', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9083', 'Estreito', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9084', 'Fortuna', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9085', 'Godofredo Viana', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9086', 'Governador Eugenio Barros', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9087', 'Governador Nunes Freire', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9088', 'Grajau', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9089', 'Humberto de Campos', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9090', 'Icatu', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9091', 'Imperatriz', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9092', 'Itapecuru Mirim', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9093', 'Itinga do Maranhao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9094', 'Joao Lisboa', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9095', 'Lago da Pedra', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9096', 'Lago do Junco', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9097', 'Maracacume', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9098', 'Matinha', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9099', 'Matoes', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9100', 'Mirador', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9101', 'Miranda do Norte', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9102', 'Moncao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9103', 'Montes Altos', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9104', 'Morros', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9105', 'Nova Olinda do Maranhao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9106', 'Olho d\'Agua das Cunhas', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9107', 'Paco do Lumiar', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9108', 'Paraibano', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9109', 'Parnarama', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9110', 'Passagem Franca', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9111', 'Pastos Bons', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9112', 'Paulo Ramos', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9113', 'Pedreiras', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9114', 'Penalva', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9115', 'Pindare Mirim', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9116', 'Pinheiro', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9117', 'Pio XII', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9118', 'Pirapemas', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9119', 'Pocao de Pedras', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9120', 'Porto Franco', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9121', 'Presidente Dutra', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9122', 'Raposa', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9123', 'Riachao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9124', 'Rosario', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9125', 'Santa Helena', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9126', 'Santa Ines', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9127', 'Santa Luzia', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9128', 'Santa Luzia do Parua', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9129', 'Santa Quiteria do Maranhao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9130', 'Santa Rita', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9131', 'Sao Benedito do Rio Preto', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9132', 'Sao Bento', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9133', 'Sao Bernardo', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9134', 'Sao Domingos do Maranhao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9135', 'Sao Joao Batista', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9136', 'Sao Joao dos Patos', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9137', 'Sao Jose de Ribamar', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9138', 'Sao Luis', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9139', 'Sao Luis Gonzaga do Maranhao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9140', 'Sao Mateus do Maranhao', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9141', 'Sao Pedro da Agua Branca', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9142', 'Sao Raimundo das Mangabeiras', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9143', 'Timbiras', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9144', 'Timon', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9145', 'Trizidela do Vale', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9146', 'Tuntum', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9147', 'Turiacu', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9148', 'Tutoia', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9149', 'Urbano Santos', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9150', 'Vargem Grande', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9151', 'Viana', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9152', 'Vitoria do Mearim', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9153', 'Vitorino Freire', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9154', 'Ze Doca', '522');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9155', 'Abaetetuba', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9156', 'Acara', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9157', 'Afua', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9158', 'Agua Azul do Norte', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9159', 'Alenquer', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9160', 'Almeirim', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9161', 'Altamira', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9162', 'Ananindeua', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9163', 'Augusto Correa', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9164', 'Baiao', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9165', 'Barcarena', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9166', 'Belem', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9167', 'Benevides', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9168', 'Braganca', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9169', 'Breu Branco', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9170', 'Breves', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9171', 'Bujaru', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9172', 'Cameta', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9173', 'Capanema', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9174', 'Capitao Poco', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9175', 'Castanhal', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9176', 'Conceicao do Araguaia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9177', 'Concordia do Para', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9178', 'Curionopolis', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9179', 'Curuca', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9180', 'Dom Eliseu', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9181', 'Eldorado dos Carajas', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9182', 'Garrafao do Norte', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9183', 'Goianesia do Para', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9184', 'Gurupa', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9185', 'Igarape-Acu', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9186', 'Igarape-Miri', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9187', 'Irituia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9188', 'Itaituba', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9189', 'Itupiranga', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9190', 'Jacareacanga', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9191', 'Jacunda', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9192', 'Juruti', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9193', 'Limoeiro do Ajuru', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9194', 'Mae do Rio', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9195', 'Maraba', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9196', 'Maracana', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9197', 'Marapanim', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9198', 'Marituba', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9199', 'Medicilandia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9200', 'Mocajuba', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9201', 'Moju', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9202', 'Monte Alegre', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9203', 'Muana', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9204', 'Novo Progresso', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9205', 'Novo Repartimento', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9206', 'Obidos', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9207', 'Oeiras do Para', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9208', 'Oriximina', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9209', 'Ourem', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9210', 'Ourilandia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9211', 'Pacaja', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9212', 'Paragominas', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9213', 'Parauapebas', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9214', 'Portel', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9215', 'Porto de Moz', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9216', 'Prainha', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9217', 'Redencao', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9218', 'Rio Maria', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9219', 'Rondon do Para', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9220', 'Ruropolis', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9221', 'Salinopolis', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9222', 'Santa Isabel do Para', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9223', 'Santa Luzia do Para', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9224', 'Santa Maria do Para', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9225', 'Santana do Araguaia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9226', 'Santarem', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9227', 'Santo Antonio do Taua', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9228', 'Sao Caetano de Odivelas', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9229', 'Sao Domingos do Araguaia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9230', 'Sao Domingos do Capim', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9231', 'Sao Felix do Xingu', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9232', 'Sao Geraldo do Araguaia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9233', 'Sao Joao de Pirabas', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9234', 'Sao Miguel do Guama', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9235', 'Senador Jose Porfirio', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9236', 'Soure', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9237', 'Tailandia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9238', 'Terra Santa', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9239', 'Tome-Acu', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9240', 'Tucuma', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9241', 'Tucurui', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9242', 'Ulianopolis', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9243', 'Uruara', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9244', 'Vigia', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9245', 'Viseu', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9246', 'Xinguara', '526');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9247', 'Alagoa Grande', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9248', 'Alagoa Nova', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9249', 'Alagoinha', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9250', 'Alhandra', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9251', 'Aracagi', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9252', 'Arara', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9253', 'Araruna', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9254', 'Areia', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9255', 'Aroeiras', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9256', 'Bananeiras', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9257', 'Barra de Santa Rosa', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9258', 'Bayeux', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9259', 'Belem', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9260', 'Boqueirao', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9261', 'Brejo do Cruz', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9262', 'Caapora', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9263', 'Cabedelo', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9264', 'Cacimba de Dentro', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9265', 'Cajazeiras', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9266', 'Campina Grande', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9267', 'Catole do Rocha', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9268', 'Conceicao', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9269', 'Conde', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9270', 'Coremas', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9271', 'Cruz do Espirito Santo', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9272', 'Cuite', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9273', 'Desterro', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9274', 'Dona Ines', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9275', 'Esperanca', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9276', 'Fagundes', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9277', 'Guarabira', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9278', 'Gurinhem', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9279', 'Imaculada', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9280', 'Inga', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9281', 'Itabaiana', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9282', 'Itaporanga', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9283', 'Itapororoca', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9284', 'Itatuba', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9285', 'Jacarau', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9286', 'Joao Pessoa', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9287', 'Juazeirinho', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9288', 'Juripiranga', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9289', 'Juru', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9290', 'Lagoa Seca', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9291', 'Mamanguape', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9292', 'Manaira', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9293', 'Mari', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9294', 'Massaranduba', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9295', 'Mogeiro', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9296', 'Monteiro', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9297', 'Mulungu', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9298', 'Natuba', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9299', 'Nova Floresta', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9300', 'Patos', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9301', 'Paulista', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9302', 'Pedras de Fogo', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9303', 'Pianco', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9304', 'Picui', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9305', 'Pilar', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9306', 'Pirpirituba', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9307', 'Pitimbu', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9308', 'Pocinhos', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9309', 'Pombal', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9310', 'Princesa Isabel', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9311', 'Puxinana', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9312', 'Queimadas', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9313', 'Remigio', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9314', 'Rio Tinto', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9315', 'Salgado de Sao Felix', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9316', 'Santa Luzia', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9317', 'Santa Rita', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9318', 'Sao Bento', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9319', 'Sao Joao do Rio do Peixe', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9320', 'Sao Jose de Piranhas', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9321', 'Sao Sebastiao de Lagoa de Roca', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9322', 'Sape', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9323', 'Serra Branca', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9324', 'Solanea', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9325', 'Soledade', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9326', 'Sousa', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9327', 'Sume', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9328', 'Taperoa', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9329', 'Tavares', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9330', 'Teixeira', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9331', 'Triunfo', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9332', 'Uirauna', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9333', 'Umbuzeiro', '527');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9334', 'Almirante Tamandare', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9335', 'Alto Parana', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9336', 'Alto Piquiri', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9337', 'Altonia', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9338', 'Ampere', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9339', 'Andira', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9340', 'Antonina', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9341', 'Apucarana', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9342', 'Arapongas', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9343', 'Arapoti', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9344', 'Araucaria', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9345', 'Assai', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9346', 'Assis Chateaubriand', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9347', 'Astorga', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9348', 'Bandeirantes', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9349', 'Barbosa Ferraz', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9350', 'Bela Vista do Paraiso', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9351', 'Cambara', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9352', 'Cambe', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9353', 'Campina Grande do Sul', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9354', 'Campina da Lagoa', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9355', 'Campo Largo', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9356', 'Campo Murao', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9357', 'Candido de Abreu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9358', 'Capitao Leonidas Marques', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9359', 'Carambei', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9360', 'Cascavel', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9361', 'Castro', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9362', 'Centenario do Sul', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9363', 'Chopinzinho', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9364', 'Cianorte', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9365', 'Clevelandia', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9366', 'Colombo', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9367', 'Colorado', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9368', 'Contenda', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9369', 'Corbelia', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9370', 'Cornelio Procopio', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9371', 'Coronel Vivida', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9372', 'Cruzeiro do Oeste', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9373', 'Curitiba', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9374', 'Dois Vizinhos', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9375', 'Engenheiro Beltrao', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9376', 'Faxinal', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9377', 'Fazenda Rio Grande', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9378', 'Florestopolis', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9379', 'Foz do Iguacu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9380', 'Francisco Beltrao', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9381', 'Goioere', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9382', 'Guaira', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9383', 'Guaraniacu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9384', 'Guarapuava', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9385', 'Guaratuba', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9386', 'Ibaiti', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9387', 'Ibipora', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9388', 'Imbituva', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9389', 'Ipora', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9390', 'Irati', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9391', 'Itaperucu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9392', 'Ivaipora', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9393', 'Jacarezinho', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9394', 'Jaguariaiva', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9395', 'Jandaia do Sul', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9396', 'Jataizinho', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9397', 'Lapa', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9398', 'Laranjeiras do Sul', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9399', 'Loanda', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9400', 'Londrina', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9401', 'Mandaguacu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9402', 'Mandaguari', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9403', 'Marechal Candido Rondon', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9404', 'Marialva', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9405', 'Maringa', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9406', 'Matelandia', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9407', 'Matinhos', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9408', 'Medianeira', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9409', 'Moreira Sales', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9410', 'Nova Aurora', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9411', 'Nova Esperanca', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9412', 'Nova Londrina', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9413', 'Ortigueira', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9414', 'Paicandu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9415', 'Palmas', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9416', 'Palmeira', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9417', 'Palotina', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9418', 'Paranagua', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9419', 'Paranavai', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9420', 'Pato Branco', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9421', 'Peabiru', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9422', 'Pinhais', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9423', 'Pinhao', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9424', 'Pirai do Sul', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9425', 'Piraquara', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9426', 'Pitanga', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9427', 'Ponta Grossa', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9428', 'Pontal do Parana', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9429', 'Porecatu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9430', 'Primero de Maio', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9431', 'Prudentopolis', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9432', 'Quatro Barras', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9433', 'Quedas do Iguacu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9434', 'Realeza', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9435', 'Reserva', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9436', 'Ribeirao do Pinhal', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9437', 'Rio Branco do Sul', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9438', 'Rio Negro', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9439', 'Rolandia', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9440', 'Santa Helena', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9441', 'Santa Terezinha de Itaipu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9442', 'Santo Antonio da Platina', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9443', 'Santo Antonio do Sudoeste', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9444', 'Sao Joao do Ivai', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9445', 'Sao Jose dos Pinhais', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9446', 'Sao Mateus do Sul', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9447', 'Sao Miguel do Iguacu', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9448', 'Sarandi', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9449', 'Senges', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9450', 'Sertanopolis', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9451', 'Siquera Campos', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9452', 'Tapejara', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9453', 'Telemaco Borba', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9454', 'Terra Boa', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9455', 'Terra Rica', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9456', 'Terra Roxa', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9457', 'Tibagi', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9458', 'Toledo', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9459', 'Ubirata', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9460', 'Umuarama', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9461', 'Uniao da Victoria', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9462', 'Wenceslau Braz', '528');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9463', 'Abreu e Lima', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9464', 'Afogados da Ingazeira', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9465', 'Agrestina', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9466', 'Agua Preta', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9467', 'Aguas Belas', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9468', 'Alianca', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9469', 'Altinho', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9470', 'Amaraji', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9471', 'Aracoiaba', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9472', 'Araripina', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9473', 'Arcoverde', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9474', 'Barra de Guabiraba', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9475', 'Barreiros', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9476', 'Belem de Sao Francisco', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9477', 'Belo Jardim', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9478', 'Bezerros', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9479', 'Bodoco', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9480', 'Bom Conselho', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9481', 'Bom Jardim', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9482', 'Bonito', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9483', 'Brejo da Madre de Deus', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9484', 'Buique', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9485', 'Cabo de Santo Agostinho', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9486', 'Cabrobo', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9487', 'Cachoeirinha', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9488', 'Caetes', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9489', 'Camaragibe', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9490', 'Camocim de Sao Felix', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9491', 'Canhotinho', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9492', 'Capoeiras', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9493', 'Carnaiba', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9494', 'Carpina', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9495', 'Caruaru', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9496', 'Catende', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9497', 'Cha Grande', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9498', 'Condado', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9499', 'Cumaru', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9500', 'Cupira', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9501', 'Custodia', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9502', 'Escada', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9503', 'Exu', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9504', 'Feira Nova', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9505', 'Fernando de Noronha', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9506', 'Flores', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9507', 'Floresta', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9508', 'Gameleira', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9509', 'Garanhuns', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9510', 'Gloria do Goita', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9511', 'Goiana', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9512', 'Gravata', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9513', 'Ibimirim', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9514', 'Igarassu', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9515', 'Inaja', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9516', 'Ipojuca', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9517', 'Ipubi', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9518', 'Itaiba', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9519', 'Itamaraca', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9520', 'Itambe', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9521', 'Itapissuma', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9522', 'Itaquitinga', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9523', 'Jaboatao', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9524', 'Joao Alfredo', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9525', 'Joaquim Nabuco', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9526', 'Lagoa do Itaenga', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9527', 'Lajedo', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9528', 'Limoeiro', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9529', 'Macaparana', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9530', 'Maraial', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9531', 'Moreno', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9532', 'Nazare da Mata', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9533', 'Olinda', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9534', 'Orobo', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9535', 'Ouricuri', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9536', 'Palmares', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9537', 'Panelas', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9538', 'Parnamirim', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9539', 'Passira', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9540', 'Paudalho', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9541', 'Paulista', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9542', 'Pedra', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9543', 'Pesqueira', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9544', 'Petrolandia', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9545', 'Petrolina', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9546', 'Pombos', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9547', 'Quipapa', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9548', 'Recife', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9549', 'Ribeirao', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9550', 'Rio Formoso', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9551', 'Salgueiro', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9552', 'Santa Cruz do Capibaribe', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9553', 'Santa Maria da Boa Vista', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9554', 'Sao Bento do Una', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9555', 'Sao Caitano', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9556', 'Sao Joao', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9557', 'Sao Joaquim do Monte', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9558', 'Sao Jose da Coroa Grande', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9559', 'Sao Jose do Belmonte', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9560', 'Sao Jose do Egito', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9561', 'Sao Lourenco da Mata', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9562', 'Serra Talhada', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9563', 'Sertania', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9564', 'Sirinhaem', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9565', 'Surubim', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9566', 'Tabira', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9567', 'Tamandare', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9568', 'Taquaritinga do Norte', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9569', 'Timbauba', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9570', 'Toritama', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9571', 'Trindade', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9572', 'Triunfo', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9573', 'Tupanatinga', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9574', 'Vicencia', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9575', 'Vitoria de Santo Antao', '529');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9576', 'Agua Branca', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9577', 'Alto Longa', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9578', 'Altos', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9579', 'Amarante', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9580', 'Avelino Lopes', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9581', 'Barras', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9582', 'Batalha', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9583', 'Beneditinos', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9584', 'Bom Jesus', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9585', 'Buriti dos Lopes', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9586', 'Campo Maior', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9587', 'Canto do Buriti', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9588', 'Castelo do Piaui', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9589', 'Cocal', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9590', 'Corrente', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9591', 'Demerval Lobao', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9592', 'Elesbao Veloso', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9593', 'Esperantina', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9594', 'Floriano', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9595', 'Gilbues', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9596', 'Guadalupe', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9597', 'Inhuma', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9598', 'Itainopolis', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9599', 'Itaueira', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9600', 'Jaicos', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9601', 'Joaquim Pires', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9602', 'Jose de Freitas', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9603', 'Luis Correia', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9604', 'Luzilandia', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9605', 'Matias Olimpio', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9606', 'Miguel Alves', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9607', 'Monsenhor Gil', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9608', 'Oeiras', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9609', 'Palmeirais', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9610', 'Parnaiba', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9611', 'Pedro II', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9612', 'Picos', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9613', 'Pimenteiras', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9614', 'Pio IX', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9615', 'Piracuruca', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9616', 'Piripiri', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9617', 'Porto', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9618', 'Regeneracao', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9619', 'Sao Joao do Piaui', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9620', 'Sao Miguel do Tapuio', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9621', 'Sao Pedro do Piaui', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9622', 'Sao Raimundo Nonato', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9623', 'Simoes', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9624', 'Simplicio Mendes', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9625', 'Teresina', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9626', 'Uniao', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9627', 'Urucui', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9628', 'Valenca do Piaui', '530');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9629', 'Alta Floresta d\'Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9630', 'Alto Alegre do Parecis', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9631', 'Alto Paraiso', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9632', 'Alvorada d\'Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9633', 'Ariquemes', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9634', 'Buritis', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9635', 'Cacoal', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9636', 'Candeias do Jamari', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9637', 'Cerejeiras', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9638', 'Colorado do Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9639', 'Corumbiara', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9640', 'Espigao d\'Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9641', 'Governador Jorge Teixeira', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9642', 'Guajara-Mirim', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9643', 'Jaru', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9644', 'Ji-Parana', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9645', 'Machadinho d\'Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9646', 'Ministro Andreazza', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9647', 'Mirante da Serra', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9648', 'Nova Brasilandia d\'Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9649', 'Nova Mamore', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9650', 'Novo Horizonte do Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9651', 'Ouro Preto do Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9652', 'Pimenta Bueno', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9653', 'Porto Velho', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9654', 'Presidente Medici', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9655', 'Rolim de Moura', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9656', 'Santa Luzia d\'Oeste', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9657', 'Sao Miguel do Guapore', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9658', 'Urupa', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9659', 'Vale do Paraiso', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9660', 'Vilhena', '534');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9661', 'Alto Alegre', '535');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9662', 'Boa Vista', '535');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9663', 'Bonfim', '535');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9664', 'Caracarai', '535');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9665', 'Mucajai', '535');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9666', 'Normandia', '535');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9667', 'Sao Joao da Baliza', '535');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9668', 'Sao Luiz', '535');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9669', 'Aquidaba', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9670', 'Aracaju', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9671', 'Araua', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9672', 'Areia Branca', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9673', 'Barra dos Coqueiros', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9674', 'Boquim', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9675', 'Campo do Brito', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9676', 'Caninde de Sao Francisco', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9677', 'Capela', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9678', 'Carira', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9679', 'Cristinapolis', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9680', 'Estancia', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9681', 'Frei Paulo', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9682', 'Gararu', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9683', 'Indiaroba', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9684', 'Itabaiana', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9685', 'Itabaianinha', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9686', 'Itaporanga d\'Ajuda', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9687', 'Japaratuba', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9688', 'Japoata', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9689', 'Lagarto', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9690', 'Laranjeiras', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9691', 'Malhador', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9692', 'Maruim', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9693', 'Moita Bonita', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9694', 'Monte Alegre de Sergipe', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9695', 'Neopolis', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9696', 'Nossa Senhora da Gloria', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9697', 'Nossa Senhora das Dores', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9698', 'Nossa Senhora do Socorro', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9699', 'Pacatuba', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9700', 'Poco Verde', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9701', 'Porto da Folha', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9702', 'Propria', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9703', 'Riachao do Dantas', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9704', 'Ribeiropolis', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9705', 'Salgado', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9706', 'Santa Luzia do Itanhy', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9707', 'Santo Amaro das Brotas', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9708', 'Sao Cristovao', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9709', 'Simao Dias', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9710', 'Tobias Barreto', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9711', 'Tomar do Geru', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9712', 'Umbauba', '538');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9713', 'Alvorada', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9714', 'Ananas', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9715', 'Araguacu', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9716', 'Araguaina', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9717', 'Araguatins', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9718', 'Arraias', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9719', 'Augustinopolis', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9720', 'Axixa do Tocantins', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9721', 'Colinas do Tocantins', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9722', 'Dianopolis', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9723', 'Formoso do Araguaia', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9724', 'Goiatins', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9725', 'Guarai', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9726', 'Gurupi', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9727', 'Miracema do Tocantins', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9728', 'Miranorte', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9729', 'Palmas', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9730', 'Paraiso', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9731', 'Parana', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9732', 'Porto Nacional', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9733', 'Sitio Novo do Tocantins', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9734', 'Taguatinga', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9735', 'Tocantinopolis', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9736', 'Wanderlandia', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9737', 'Xambioa', '539');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9738', 'Kuala Belait', '541');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9739', 'Seria', '541');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9740', 'Bandar Seri Begawan', '542');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9741', 'Bangar', '543');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9742', 'Tutong', '544');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9743', 'Bansko', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9744', 'Belica', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9745', 'Blagoevgrad', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9746', 'Goce Delchev', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9747', 'Hadzhidimovo', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9748', 'Jakoruda', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9749', 'Kresna', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9750', 'Melnik', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9751', 'Petrich', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9752', 'Razlog', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9753', 'Sandanski', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9754', 'Simitli', '545');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9755', 'Ahtopol', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9756', 'Ajtos', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9757', 'Balgarovo', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9758', 'Bourgas', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9759', 'Burgas', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9760', 'Carevo', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9761', 'Kableshkovo', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9762', 'Kameno', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9763', 'Karnobat', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9764', 'Malko Tarnovo', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9765', 'Nesebar', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9766', 'Obzor', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9767', 'Pomorie', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9768', 'Primorsko', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9769', 'Sozopol', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9770', 'Sredec', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9771', 'Sungurlare', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9772', 'Tvardica', '546');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9773', 'Balchik', '547');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9774', 'Dobrich', '547');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9775', 'General-Toshevo', '547');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9776', 'Kavarna', '547');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9777', 'Loznica', '547');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9778', 'Shabla', '547');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9779', 'Tervel', '547');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9780', 'Drjanovo', '548');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9781', 'Gabrovo', '548');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9782', 'Plachkovci', '548');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9783', 'Sevlievo', '548');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9784', 'Trjavna', '548');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9785', 'Dimitrovgrad', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9786', 'Harmanli', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9787', 'Haskovo', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9788', 'Ivajlovgrad', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9789', 'Ljubimec', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9790', 'Madzharovo', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9791', 'Merichleri', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9792', 'Simeonovgrad', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9793', 'Svilengrad', '549');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9794', 'Boljarovo', '550');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9795', 'Elhovo', '550');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9796', 'Jambol', '550');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9797', 'Straldzha', '550');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9798', 'Topolovgrad', '550');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9799', 'Ardino', '551');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9800', 'Dzhebel', '551');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9801', 'Kardzhali', '551');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9802', 'Krumovgrad', '551');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9803', 'Momchilgrad', '551');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9804', 'Boboshevo', '552');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9805', 'Bobovdol', '552');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9806', 'Dupnica', '552');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9807', 'Kjustendil', '552');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9808', 'Kocherinovo', '552');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9809', 'Rila', '552');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9810', 'Sapareva Banja', '552');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9811', 'Zemen', '552');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9812', 'Aprilci', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9813', 'Jablanica', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9814', 'Letnica', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9815', 'Lovech', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9816', 'Lukovit', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9817', 'Sopot', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9818', 'Teteven', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9819', 'Trojan', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9820', 'Ugarchin', '553');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9821', 'Berkovica', '554');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9822', 'Bojchinovci', '554');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9823', 'Brusarci', '554');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9824', 'Chiprovci', '554');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9825', 'Lom', '554');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9826', 'Montana', '554');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9827', 'Valchedram', '554');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9828', 'Varshec', '554');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9829', 'Batak', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9830', 'Belovo', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9831', 'Bracigovo', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9832', 'Koprivshtica', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9833', 'Panagjurishte', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9834', 'Pazardzhik', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9835', 'Peshtera', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9836', 'Rakitovo', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9837', 'Septemvri', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9838', 'Strelcha', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9839', 'Velingrad', '556');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9840', 'Bankja', '557');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9841', 'Batanovci', '557');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9842', 'Breznik', '557');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9843', 'Pernik', '557');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9844', 'Radomir', '557');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9845', 'Tran', '557');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9846', 'Belene', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9847', 'Cherven Brjag', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9848', 'Dolna Mitropolija', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9849', 'Dolni Dabnik', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9850', 'Guljanci', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9851', 'Levski', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9852', 'Nikopol', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9853', 'Pleven', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9854', 'Pordim', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9855', 'Slavjanovo', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9856', 'Trashtenik', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9857', 'Varbica', '558');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9858', 'Asenovgrad', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9859', 'Brezovo', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9860', 'Car Kalojan', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9861', 'Hisarja', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9862', 'Kalofer', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9863', 'Karlovo', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9864', 'Klisura', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9865', 'Krichim', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9866', 'Parvomaj', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9867', 'Perushtica', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9868', 'Plovdiv', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9869', 'Rakovski', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9870', 'Sadovo', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9871', 'Saedinenie', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9872', 'Stambolijski', '559');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9873', 'Isperih', '560');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9874', 'Kubrat', '560');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9875', 'Razgrad', '560');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9876', 'Senovo', '560');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9877', 'Zavet', '560');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9878', 'Bjala', '561');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9879', 'Borovo', '561');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9880', 'Dve Mogili', '561');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9881', 'Ruse', '561');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9882', 'Russe', '561');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9883', 'Vetovo', '561');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9884', 'Kaolinovo', '562');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9885', 'Kaspichan', '562');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9886', 'Novi Pazar', '562');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9887', 'Pliska', '562');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9888', 'Shumen', '562');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9889', 'Smjadovo', '562');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9890', 'Veliki Preslav', '562');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9891', 'Alfatar', '563');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9892', 'Dulovo', '563');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9893', 'Glavinica', '563');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9894', 'Silistra', '563');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9895', 'Tutrakan', '563');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9896', 'Kermen', '564');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9897', 'Kotel', '564');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9898', 'Nova Zagora', '564');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9899', 'Shivachevo', '564');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9900', 'Sliven', '564');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9901', 'Chepelare', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9902', 'Devin', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9903', 'Dospat', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9904', 'Laki', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9905', 'Madan', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9906', 'Nedelino', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9907', 'Rudozem', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9908', 'Smoljan', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9909', 'Zlatograd', '565');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9910', 'Antonovo', '569');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9911', 'Omurtag', '569');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9912', 'Opaka', '569');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9913', 'Popovo', '569');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9914', 'Targovishte', '569');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9915', 'Beloslav', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9916', 'Bjala', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9917', 'Dalgopol', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9918', 'Devnja', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9919', 'Iskar', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9920', 'Provadija', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9921', 'Suvorovo', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9922', 'Valchi Dol', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9923', 'Varna', '570');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9924', 'Belogradchik', '572');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9925', 'Bregovo', '572');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9926', 'Dimovo', '572');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9927', 'Dolni Chiflik', '572');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9928', 'Dunavci', '572');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9929', 'Gramada', '572');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9930', 'Kula', '572');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9931', 'Vidin', '572');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9932', 'Bjala Slatina', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9933', 'Knezha', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9934', 'Kojnare', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9935', 'Kozloduj', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9936', 'Krivodol', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9937', 'Mezdra', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9938', 'Mizija', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9939', 'Orjahovo', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9940', 'Roman', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9941', 'Vraca', '573');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9942', 'Yablaniza', '574');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9943', 'Boromo', '575');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9944', 'Kongoussi', '576');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9945', 'Kombissiri', '577');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9946', 'Diebougou', '578');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9947', 'Pa', '578');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9948', 'Garango', '579');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9949', 'Tenkodogo', '579');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9950', 'Koudougou', '580');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9951', 'Banfora', '581');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9952', 'Zorgo', '582');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9953', 'Bogande', '583');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9954', 'Fada N\'gourma', '584');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9955', 'Bekuy', '585');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9956', 'Bobo Dioulasso', '585');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9957', 'Dano', '586');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9958', 'Ouagadougou', '587');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9959', 'Koalla', '588');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9960', 'Koloko', '588');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9961', 'Orodara', '588');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9962', 'Gayeri', '589');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9963', 'Pama', '590');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9964', 'Nouna', '591');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9965', 'Koupela', '592');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9966', 'Bousse', '593');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9967', 'Sindou', '594');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9968', 'Dedougou', '595');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9969', 'Po', '596');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9970', 'Boulsa', '597');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9971', 'Batie', '598');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9972', 'Ziniare', '599');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9973', 'Gorom-Gorom', '600');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9974', 'Yako', '601');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9975', 'Gaoua', '602');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9976', 'Kampti', '602');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9977', 'Loropeni', '602');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9978', 'Reo', '603');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9979', 'Kaya', '604');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9980', 'Dori', '605');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9981', 'Gao', '606');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9982', 'Leo', '606');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9983', 'Aribinda', '607');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9984', 'Djibo', '607');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9985', 'Louta', '608');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9986', 'Tougan', '608');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9987', 'Diapaga', '609');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9988', 'Kantchari', '609');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9989', 'Hounde', '610');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9990', 'Ouahigouya', '611');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9991', 'Gourcy', '612');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9992', 'Manga', '613');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9993', 'Bubanza', '614');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9994', 'Bujumbura', '615');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9995', 'Bururi', '616');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9996', 'Cankuzo', '617');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9997', 'Cibitoke', '618');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9998', 'Gitega', '619');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('9999', 'Karuzi', '620');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10000', 'Kayanza', '621');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10001', 'Kirundo', '622');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10002', 'Makamba', '623');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10003', 'Muramvya', '624');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10004', 'Muyinga', '625');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10005', 'Ngozi', '626');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10006', 'Rutana', '627');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10007', 'Ruyigi', '628');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10008', 'Kampot', '635');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10009', 'Ta Khmau', '636');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10010', 'Kracheh', '638');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10011', 'Pousat', '645');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10012', 'Phumi Takaev', '652');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10013', 'Banyo', '653');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10014', 'Meiganga', '653');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10015', 'Ngaoundere', '653');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10016', 'Tibati', '653');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10017', 'Tignere', '653');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10018', 'Akonolinga', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10019', 'Bafia', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10020', 'Eseka', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10021', 'Mbalmayo', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10022', 'Mfou', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10023', 'Monatele', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10024', 'Nanga Eboko', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10025', 'Obala', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10026', 'Ombesa', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10027', 'Saa', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10028', 'Yaounde', '654');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10029', 'Abong Mbang', '655');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10030', 'Batouri', '655');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10031', 'Bertoua', '655');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10032', 'Betare Oya', '655');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10033', 'Djoum', '655');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10034', 'Doume', '655');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10035', 'Lomie', '655');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10036', 'Yokadouma', '655');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10037', 'Bonaberi', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10038', 'Dibombari', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10039', 'Douala', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10040', 'Edea', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10041', 'Loum', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10042', 'Manjo', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10043', 'Mbanga', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10044', 'Nkongsamba', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10045', 'Yabassi', '656');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10046', 'Figuif', '657');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10047', 'Garoua', '657');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10048', 'Guider', '657');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10049', 'Lagdo', '657');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10050', 'Poli', '657');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10051', 'Rey Bouba', '657');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10052', 'Tchollire', '657');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10053', 'Figuif', '658');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10054', 'Garoua', '658');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10055', 'Guider', '658');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10056', 'Lagdo', '658');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10057', 'Poli', '658');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10058', 'Rey Bouba', '658');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10059', 'Tchollire', '658');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10060', 'Bamenda', '659');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10061', 'Kumbo', '659');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10062', 'Mbengwi', '659');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10063', 'Mme', '659');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10064', 'Njinikom', '659');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10065', 'Nkambe', '659');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10066', 'Wum', '659');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10067', 'Bafang', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10068', 'Bafoussam', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10069', 'Bafut', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10070', 'Bali', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10071', 'Bana', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10072', 'Bangangte', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10073', 'Djang', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10074', 'Fontem', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10075', 'Foumban', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10076', 'Foumbot', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10077', 'Mbouda', '660');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10078', 'Akom', '661');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10079', 'Ambam', '661');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10080', 'Ebolowa', '661');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10081', 'Kribi', '661');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10082', 'Lolodorf', '661');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10083', 'Moloundou', '661');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10084', 'Mvangue', '661');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10085', 'Sangmelima', '661');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10086', 'Buea', '662');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10087', 'Idenao', '662');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10088', 'Kumba', '662');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10089', 'Limbe', '662');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10090', 'Mamfe', '662');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10091', 'Muyuka', '662');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10092', 'Tiko', '662');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10093', 'Airdrie', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10094', 'Athabasca', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10095', 'Banff', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10096', 'Barrhead', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10097', 'Bassano', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10098', 'Beaumont', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10099', 'Beaverlodge', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10100', 'Black Diamond', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10101', 'Blackfalds', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10102', 'Blairmore', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10103', 'Bon Accord', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10104', 'Bonnyville', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10105', 'Bow Island', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10106', 'Brooks', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10107', 'Calgary', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10108', 'Calmar', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10109', 'Camrose', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10110', 'Canmore', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10111', 'Cardston', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10112', 'Carstairs', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10113', 'Chateau Lake Louise', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10114', 'Chestermere', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10115', 'Clairmont', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10116', 'Claresholm', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10117', 'Coaldale', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10118', 'Coalhurst', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10119', 'Cochrane', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10120', 'Crossfield', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10121', 'Devon', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10122', 'Didsbury', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10123', 'Drayton Valley', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10124', 'Drumheller', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10125', 'Edmonton', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10126', 'Edson', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10127', 'Elk Point', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10128', 'Fairview', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10129', 'Falher', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10130', 'Fort MacLeod', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10131', 'Fox Creek', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10132', 'Gibbons', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10133', 'Grand Centre', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10134', 'Grande Cache', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10135', 'Grande Prairie', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10136', 'Grimshaw', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10137', 'Hanna', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10138', 'High Level', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10139', 'High Prairie', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10140', 'High River', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10141', 'Hinton', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10142', 'Irricana', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10143', 'Jasper', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10144', 'Killam', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10145', 'La Crete', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10146', 'Lac la Biche', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10147', 'Lacombe', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10148', 'Lamont', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10149', 'Leduc', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10150', 'Lethbridge', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10151', 'Lloydminster', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10152', 'Magrath', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10153', 'Manning', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10154', 'Mayerthorpe', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10155', 'McMurray', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10156', 'Medicine Hat', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10157', 'Millet', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10158', 'Morinville', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10159', 'Nanton', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10160', 'Okotoks', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10161', 'Olds', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10162', 'Peace River', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10163', 'Penhold', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10164', 'Picture Butte', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10165', 'Pincher Creek', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10166', 'Ponoka', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10167', 'Provost', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10168', 'Raymond', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10169', 'Red Deer', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10170', 'Redwater', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10171', 'Rimbey', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10172', 'Rocky Mountain House', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10173', 'Rocky View', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10174', 'Saint Paul', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10175', 'Sexsmith', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10176', 'Sherwood Park', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10177', 'Slave Lake', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10178', 'Smoky Lake', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10179', 'Spirit River', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10180', 'Spruce Grove', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10181', 'Stettler', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10182', 'Stony Plain', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10183', 'Strathmore', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10184', 'Sundre', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10185', 'Swan Hills', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10186', 'Sylvan Lake', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10187', 'Taber', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10188', 'Three Hills', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10189', 'Tofield', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10190', 'Two Hills', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10191', 'Valleyview', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10192', 'Vegreville', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10193', 'Vermilion', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10194', 'Viking', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10195', 'Vulcan', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10196', 'Wainwright', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10197', 'Wembley', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10198', 'Westlock', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10199', 'Wetaskiwin', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10200', 'Whitecourt', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10201', 'Wood Buffalo', '663');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10202', 'Altona', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10203', 'Beausejour', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10204', 'Boissevain', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10205', 'Brandon', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10206', 'Carberry', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10207', 'Carman', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10208', 'Dauphin', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10209', 'Deloraine', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10210', 'Dugald', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10211', 'Flin Flon', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10212', 'Gimli', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10213', 'Hamiota', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10214', 'Killarney', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10215', 'Lac du Bonnet', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10216', 'Leaf Rapids', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10217', 'Lorette', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10218', 'Melita', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10219', 'Minnedosa', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10220', 'Morden', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10221', 'Morris', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10222', 'Neepawa', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10223', 'Niverville', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10224', 'Pinawa', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10225', 'Portage la Prairie', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10226', 'Ritchot', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10227', 'Rivers', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10228', 'Roblin', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10229', 'Saint Adolphe', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10230', 'Sainte Anne', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10231', 'Sainte Rose du Lac', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10232', 'Selkirk', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10233', 'Shilo', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10234', 'Snow Lake', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10235', 'Souris', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10236', 'Springfield', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10237', 'Steinbach', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10238', 'Stonewall', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10239', 'Stony Mountain', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10240', 'Swan River', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10241', 'The Pas', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10242', 'Thompson', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10243', 'Virden', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10244', 'Winkler', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10245', 'Winnipeg', '665');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10246', 'Clyde River', '670');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10247', 'Iqaluit', '670');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10248', 'Kangerdlinerk', '670');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10249', 'Oqsuqtooq', '670');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10250', 'Pangnirtung', '670');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10251', 'Tununirusiq', '670');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10252', 'Acton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10253', 'Ajax', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10254', 'Alexandria', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10255', 'Alfred', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10256', 'Alliston', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10257', 'Almonte', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10258', 'Amherstburg', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10259', 'Amigo Beach', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10260', 'Angus-Borden', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10261', 'Arnprior', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10262', 'Arthur', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10263', 'Athens', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10264', 'Atikokan', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10265', 'Attawapiskat', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10266', 'Aurora', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10267', 'Aylmer', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10268', 'Ayr', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10269', 'Barrie', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10270', 'Barry\'s Bay', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10271', 'Beamsville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10272', 'Beaverton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10273', 'Beeton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10274', 'Belleville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10275', 'Belmont', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10276', 'Blenheim', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10277', 'Blind River', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10278', 'Bobcaygeon', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10279', 'Bolton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10280', 'Bourget', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10281', 'Bowmanville-Newcastle', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10282', 'Bracebridge', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10283', 'Bradford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10284', 'Brampton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10285', 'Brantford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10286', 'Bridgenorth-Chemong Park Area', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10287', 'Brighton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10288', 'Brockville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10289', 'Brooklin', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10290', 'Brussels', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10291', 'Burford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10292', 'Burlington', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10293', 'Caledon', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10294', 'Caledon East', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10295', 'Caledonia', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10296', 'Cambridge', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10297', 'Campbellford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10298', 'Campbellville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10299', 'Cannington', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10300', 'Capreol', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10301', 'Cardinal', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10302', 'Carleton Place', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10303', 'Carlisle', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10304', 'Casselman', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10305', 'Cayuga', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10306', 'Chalk River', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10307', 'Chapleau', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10308', 'Chatham', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10309', 'Chesley', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10310', 'Chesterville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10311', 'Clinton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10312', 'Cobourg', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10313', 'Cochrane', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10314', 'Colborne', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10315', 'Colchester', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10316', 'Collingwood', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10317', 'Concord', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10318', 'Constance Bay', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10319', 'Cookstown', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10320', 'Cornwall', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10321', 'Creemore', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10322', 'Crystal Beach', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10323', 'Deep River', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10324', 'Delhi', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10325', 'Deseronto', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10326', 'Downsview', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10327', 'Drayton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10328', 'Dresden', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10329', 'Dryden', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10330', 'Dundalk', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10331', 'Dunnville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10332', 'Durham', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10333', 'Dutton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10334', 'Eganville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10335', 'Elliot Lake', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10336', 'Elmira', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10337', 'Elmvale', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10338', 'Embrun', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10339', 'Englehart', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10340', 'Erin', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10341', 'Espanola', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10342', 'Essex', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10343', 'Etobicoke', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10344', 'Everett', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10345', 'Exeter', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10346', 'Fenelon Falls', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10347', 'Fergus', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10348', 'Forest', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10349', 'Fort Erie', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10350', 'Fort Frances', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10351', 'Frankford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10352', 'Gananoque', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10353', 'Georgetown', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10354', 'Georgina', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10355', 'Geraldton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10356', 'Glencoe', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10357', 'Goderich', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10358', 'Golden', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10359', 'Gormley', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10360', 'Grand Bend', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10361', 'Grand Valley', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10362', 'Gravenhurst', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10363', 'Guelph', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10364', 'Hagersville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10365', 'Haileybury', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10366', 'Hamilton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10367', 'Hanover', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10368', 'Harriston', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10369', 'Harrow', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10370', 'Hastings', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10371', 'Havelock', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10372', 'Hawkesbury', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10373', 'Hearst', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10374', 'Hensall', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10375', 'Hillsburgh', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10376', 'Hornepayne', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10377', 'Huntsville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10378', 'Ingersoll', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10379', 'Innisfil', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10380', 'Iroquois', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10381', 'Iroquois Falls', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10382', 'Jarvis', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10383', 'Kanata', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10384', 'Kapuskasing', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10385', 'Kars', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10386', 'Kemptville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10387', 'Kenora', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10388', 'Kincardine', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10389', 'Kingston', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10390', 'Kirkland Lake', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10391', 'Kitchener', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10392', 'L\'Original', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10393', 'Lakefield', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10394', 'Lanark', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10395', 'Leamington', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10396', 'Lindsay', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10397', 'Listowel', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10398', 'Little Current', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10399', 'Lively', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10400', 'London', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10401', 'Longlac', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10402', 'Lucan', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10403', 'Lucknow', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10404', 'Madoc', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10405', 'Manitouwadge', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10406', 'Maple', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10407', 'Marathon', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10408', 'Markdale', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10409', 'Markham', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10410', 'Marmora', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10411', 'Mattawa', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10412', 'Meaford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10413', 'Metcalfe', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10414', 'Midland', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10415', 'Mildmay', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10416', 'Millbrook', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10417', 'Milton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10418', 'Milverton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10419', 'Mississauga', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10420', 'Mississauga Beach', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10421', 'Mitchell', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10422', 'Moose Factory', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10423', 'Morrisburg', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10424', 'Mount Albert', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10425', 'Mount Brydges', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10426', 'Mount Forest', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10427', 'Munster', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10428', 'Nanticoke', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10429', 'Napanee', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10430', 'Nepean', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10431', 'New Hamburg', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10432', 'Newmarket', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10433', 'Newtonville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10434', 'Nobleton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10435', 'North Bay', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10436', 'North Gower', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10437', 'North York', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10438', 'Norwich', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10439', 'Norwood', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10440', 'Oakville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10441', 'Omemee', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10442', 'Onaping-Levack', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10443', 'Ontario', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10444', 'Orangeville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10445', 'Orillia', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10446', 'Orono', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10447', 'Osgoode', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10448', 'Oshawa', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10449', 'Ottawa', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10450', 'Owen Sound', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10451', 'Paisley', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10452', 'Palmerston', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10453', 'Paris', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10454', 'Parkhill', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10455', 'Parry Sound', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10456', 'Pembroke', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10457', 'Perth', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10458', 'Petawawa', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10459', 'Peterborough', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10460', 'Petrolia', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10461', 'Pickering', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10462', 'Picton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10463', 'Porcupine', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10464', 'Port Credit', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10465', 'Port Dover', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10466', 'Port Elgin', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10467', 'Port Hope', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10468', 'Port Perry', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10469', 'Port Stanley', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10470', 'Powassan', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10471', 'Prescott', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10472', 'Queensville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10473', 'Renfrew', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10474', 'Richmond', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10475', 'Richmond Hill', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10476', 'Ridgetown', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10477', 'Rockland', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10478', 'Rockwood', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10479', 'Rodney', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10480', 'Saint Catharines', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10481', 'Saint Catharines-Niagara', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10482', 'Saint George', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10483', 'Saint Jacobs', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10484', 'Saint Marys', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10485', 'Saint Thomas', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10486', 'Sarnia', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10487', 'Sault Sainte Marie', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10488', 'Scarborough', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10489', 'Schomberg', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10490', 'Seaforth', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10491', 'Shelburne', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10492', 'Simcoe', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10493', 'Sioux Lookout', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10494', 'Smiths Falls', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10495', 'Smithville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10496', 'South River', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10497', 'Southampton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10498', 'Stayner', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10499', 'Stirling', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10500', 'Stoney Creek', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10501', 'Stoney Point', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10502', 'Stouffville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10503', 'Stratford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10504', 'Strathroy', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10505', 'Sturgeon Falls', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10506', 'Sudbury', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10507', 'Sutton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10508', 'Tavistock', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10509', 'Teeswater', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10510', 'Terrace Bay', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10511', 'Thamesford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10512', 'Thessalon', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10513', 'Thornbury', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10514', 'Thornhill', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10515', 'Thunder Bay', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10516', 'Tilbury', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10517', 'Tilsonburg', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10518', 'Timmins', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10519', 'Toronto', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10520', 'Tory Hill', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10521', 'Tottenham', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10522', 'Tweed', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10523', 'Uxbridge', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10524', 'Valley East', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10525', 'Vankleek Hill', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10526', 'Vaughan', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10527', 'Vineland', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10528', 'Walkerton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10529', 'Wallaceburg', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10530', 'Wasaga Beach', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10531', 'Waterdown', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10532', 'Waterford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10533', 'Waterloo', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10534', 'Watford', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10535', 'Wawa', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10536', 'Welland', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10537', 'Wellesley', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10538', 'Wellington', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10539', 'West Lorne', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10540', 'Wheatley', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10541', 'Whitby', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10542', 'Whitchurch-Stouffville', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10543', 'Wiarton', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10544', 'Wikwemikong', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10545', 'Willowdale', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10546', 'Winchester', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10547', 'Windsor', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10548', 'Wingham', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10549', 'Woodbridge', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10550', 'Woodstock', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10551', 'Wyoming', '671');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10552', 'Acton Vale', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10553', 'Albanel', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10554', 'Alencon', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10555', 'Alma', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10556', 'Amos', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10557', 'Amqui', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10558', 'Anjou', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10559', 'Asbestos', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10560', 'Bagotville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10561', 'Baie-Comeau', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10562', 'Baie-Saint-Paul', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10563', 'Barraute', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10564', 'Beauceville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10565', 'Beaupre', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10566', 'Bedford', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10567', 'Beloeil', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10568', 'Bernierville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10569', 'Berthierville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10570', 'Betsiamites', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10571', 'Boisbriand', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10572', 'Bonaventure', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10573', 'Boucherville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10574', 'Bromont', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10575', 'Brossard', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10576', 'Brownsburg', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10577', 'Buckingham', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10578', 'Cabano', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10579', 'Candiac', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10580', 'Cap-Chat', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10581', 'Cap-aux-Meules', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10582', 'Carleton', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10583', 'Causapscal', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10584', 'Chandler', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10585', 'Chapais', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10586', 'Charlesbourg', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10587', 'Chateau-Richer', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10588', 'Chibougamou', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10589', 'Chicoutimi-Jonquiere', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10590', 'Chisasibi', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10591', 'Chute-aux-Outardes', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10592', 'Clermont', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10593', 'Coaticook', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10594', 'Coleraine', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10595', 'Contrecoeur', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10596', 'Cookshire', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10597', 'Cowansville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10598', 'Crabtree', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10599', 'Danville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10600', 'Daveluyville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10601', 'Degelis', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10602', 'Desbiens', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10603', 'Disraeli', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10604', 'Dolbeau', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10605', 'Donnacona', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10606', 'Dorval', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10607', 'Drummondville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10608', 'East Angus', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10609', 'East Broughton', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10610', 'Farnham', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10611', 'Ferme-Neuve', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10612', 'Fermont', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10613', 'Filion', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10614', 'Forestville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10615', 'Fort-Coulonge', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10616', 'Gaspe', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10617', 'Gentilly', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10618', 'Granby', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10619', 'Grande-Riviere', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10620', 'Grenville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10621', 'Ham Nord', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10622', 'Hampstead', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10623', 'Hauterive', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10624', 'Havre-Saint-Pierre', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10625', 'Hebertville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10626', 'Huntingdon', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10627', 'Joliette', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10628', 'Kingsey Falls', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10629', 'L\'Annonciation', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10630', 'L\'Ascension-de-Notre-Seigneur', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10631', 'L\'Epiphanie', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10632', 'La Malbaie', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10633', 'La Pocatiere', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10634', 'La Sarre', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10635', 'La Tuque', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10636', 'Labelle', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10637', 'Lac-Etchemin', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10638', 'Lac-Lapierre', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10639', 'Lac-Megantic', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10640', 'Lac-au-Saumon', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10641', 'Lachine', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10642', 'Lachute', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10643', 'Lacolle', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10644', 'Lasalle', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10645', 'Laurentides', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10646', 'Laurier-Station', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10647', 'Laval', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10648', 'Lavaltrie', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10649', 'Le Bic', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10650', 'Lebel-sur-Quevillon', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10651', 'Les Cedres', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10652', 'Les Coteaux', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10653', 'Les Escoumins', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10654', 'Liniere', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10655', 'Longueuil', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10656', 'Louiseville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10657', 'Luceville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10658', 'Macamic', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10659', 'Magog', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10660', 'Malartic', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10661', 'Maniwaki', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10662', 'Marieville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10663', 'Maskinonge', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10664', 'Matagami', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10665', 'Matane', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10666', 'Metabetchouan', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10667', 'Mirabel', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10668', 'Mistissini', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10669', 'Mont-Joli', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10670', 'Mont-Laurier', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10671', 'Montmagny', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10672', 'Montreal', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10673', 'Murdochville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10674', 'Napierville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10675', 'New Richmond', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10676', 'Nicolet', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10677', 'Normandin', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10678', 'Notre-Dame-du-Bon-Conseil', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10679', 'Notre-Dame-du-Lac', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10680', 'Notre-Dame-du-Mont-Carmel', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10681', 'Oka-Kanesatake', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10682', 'Ormstown', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10683', 'Papineauville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10684', 'Pierreville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10685', 'Plessisville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10686', 'Pointe-Claire', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10687', 'Pont-Rouge', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10688', 'Port-Alfred-Bagotville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10689', 'Port-Cartier', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10690', 'Portneuf', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10691', 'Price', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10692', 'Princeville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10693', 'Quebec', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10694', 'Rawdon', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10695', 'Repentigny', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10696', 'Richmond', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10697', 'Rigaud', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10698', 'Rimouski', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10699', 'Riviere-au-Renard', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10700', 'Riviere-du-Loup', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10701', 'Roberval', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10702', 'Rougemont', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10703', 'Rouyn-Noranda', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10704', 'Saint-Agapit', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10705', 'Saint-Alexandre', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10706', 'Saint-Alexis-des-Monts', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10707', 'Saint-Ambroise', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10708', 'Saint-Andre-Avellin', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10709', 'Saint-Anselme', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10710', 'Saint-Apollinaire', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10711', 'Saint-Augustin', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10712', 'Saint-Basile-Sud', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10713', 'Saint-Bruno', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10714', 'Saint-Canut', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10715', 'Saint-Cesaire', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10716', 'Saint-Cyrill-de-Wendover', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10717', 'Saint-Damase', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10718', 'Saint-Damien-de-Buckland', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10719', 'Saint-Denis', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10720', 'Saint-Donat-de-Montcalm', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10721', 'Saint-Ephrem-de-Tring', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10722', 'Saint-Fabien', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10723', 'Saint-Felicien', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10724', 'Saint-Felix-de-Valois', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10725', 'Saint-Gabriel', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10726', 'Saint-Gedeon', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10727', 'Saint-Georges', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10728', 'Saint-Germain-de-Grantham', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10729', 'Saint-Gregoire', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10730', 'Saint-Henri-de-Levis', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10731', 'Saint-Honore', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10732', 'Saint-Hyacinthe', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10733', 'Saint-Jacques', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10734', 'Saint-Jean-Port-Joli', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10735', 'Saint-Jean-de-Dieu', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10736', 'Saint-Jean-sur-Richelieu', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10737', 'Saint-Jerome', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10738', 'Saint-Josephe-de-Beauce', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10739', 'Saint-Josephe-de-Lanoraie', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10740', 'Saint-Josephe-de-la-Riviere-Bl', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10741', 'Saint-Jovite', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10742', 'Saint-Laurent', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10743', 'Saint-Liboire', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10744', 'Saint-Marc-des-Carrieres', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10745', 'Saint-Martin', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10746', 'Saint-Michel-des-Saints', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10747', 'Saint-Pacome', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10748', 'Saint-Pascal', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10749', 'Saint-Pie', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10750', 'Saint-Prosper', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10751', 'Saint-Raphael', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10752', 'Saint-Raymond', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10753', 'Saint-Remi', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10754', 'Saint-Roch-de-l\'Achigan', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10755', 'Saint-Sauveur-des-Monts', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10756', 'Saint-Tite', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10757', 'Sainte-Adele', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10758', 'Sainte-Agathe-des-Monts', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10759', 'Sainte-Anne-des-Monts', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10760', 'Sainte-Anne-des-Plaines', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10761', 'Sainte-Catherine', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10762', 'Sainte-Claire', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10763', 'Sainte-Julienne', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10764', 'Sainte-Justine', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10765', 'Sainte-Madeleine', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10766', 'Sainte-Marie', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10767', 'Sainte-Martine', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10768', 'Sainte-Sophie', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10769', 'Sainte-Thecle', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10770', 'Sainte-Therese', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10771', 'Salaberry-de-Valleyfield', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10772', 'Sayabec', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10773', 'Senneterre', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10774', 'Sept-Iles', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10775', 'Shawinigan', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10776', 'Shawville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10777', 'Sherbrooke', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10778', 'Sorel', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10779', 'St Faustin', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10780', 'St. Hubert', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10781', 'St. Jean Chrysostome', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10782', 'Temiscaming', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10783', 'Terrebonne', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10784', 'Thetford Mines', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10785', 'Thurso', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10786', 'Trois-Pistoles', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10787', 'Trois-Rivieres', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10788', 'Val-David', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10789', 'Val-d\'Or', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10790', 'Valcourt', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10791', 'Vallee-Jonction', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10792', 'Vaudreuil', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10793', 'Vercheres', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10794', 'Victoriaville', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10795', 'Ville-Marie', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10796', 'Warwick', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10797', 'Waterloo', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10798', 'Weedon Centre', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10799', 'Westmount', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10800', 'Wickham', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10801', 'Windsor', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10802', 'Yamachiche', '673');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10803', 'Assiniboia', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10804', 'Biggar', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10805', 'Canora', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10806', 'Carlyle', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10807', 'Carnduff', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10808', 'Caronport', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10809', 'Carrot', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10810', 'Dalmeny', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10811', 'Davidson', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10812', 'Esterhazy', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10813', 'Estevan', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10814', 'Eston', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10815', 'Foam Lake', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10816', 'Fort Qu\'Appelle', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10817', 'Gravelbourg', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10818', 'Grenfell', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10819', 'Gull Lake', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10820', 'Hudson Bay', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10821', 'Humboldt', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10822', 'Indian Head', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10823', 'Kamsack', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10824', 'Kelvington', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10825', 'Kerrobert', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10826', 'Kindersley', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10827', 'Kipling', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10828', 'La Ronge', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10829', 'Langenburg', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10830', 'Langham', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10831', 'Lanigan', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10832', 'Lloydminster', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10833', 'Lumsden', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10834', 'Macklin', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10835', 'Maple Creek', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10836', 'Martensville', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10837', 'Meadow Lake', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10838', 'Melfort', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10839', 'Melville', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10840', 'Moose Jaw', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10841', 'Moosomin', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10842', 'Nipawin', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10843', 'North Battleford', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10844', 'Outlook', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10845', 'Oxbow', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10846', 'Pilot Butte', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10847', 'Preeceville', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10848', 'Prince Albert', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10849', 'Regina', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10850', 'Rosetown', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10851', 'Rosthem', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10852', 'Saskatoon', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10853', 'Shaunavon', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10854', 'Shellbrook', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10855', 'Swift Current', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10856', 'Tisdale', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10857', 'Unity', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10858', 'Wadena', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10859', 'Warman', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10860', 'Watrous', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10861', 'Weyburn', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10862', 'White City', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10863', 'Wilkie', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10864', 'Wynyard', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10865', 'Yorkton', '674');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10866', 'Haines Junction', '675');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10867', 'Mayo', '675');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10868', 'Whitehorse', '675');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10869', 'Sal Rei', '676');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10870', 'Nova Sintra', '677');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10871', 'Mosteiros', '678');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10872', 'Sao Filipe', '678');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10873', 'Vila do Maio', '679');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10874', 'Santa Maria', '680');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10875', 'Ndele', '686');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10876', 'Bangui', '687');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10877', 'Alindao', '688');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10878', 'Kembe', '688');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10879', 'Mobaye', '688');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10880', 'Obo', '689');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10881', 'Zemio', '689');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10882', 'Bria', '690');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10883', 'Ouadda', '690');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10884', 'Dekoa', '691');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10885', 'Sibut', '691');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10886', 'Boda', '692');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10887', 'Mbaiki', '692');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10888', 'Mongoumba', '692');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10889', 'Berberati', '693');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10890', 'Carnot', '693');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10891', 'Gamboula', '693');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10892', 'Bangassou', '694');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10893', 'Gambo', '694');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10894', 'Ouango', '694');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10895', 'Rafai', '694');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10896', 'Kaga-Bandoro', '695');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10897', 'Baboua', '696');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10898', 'Baoro', '696');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10899', 'Bouar', '696');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10900', 'Bambari', '698');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10901', 'Grimari', '698');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10902', 'Ippy', '698');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10903', 'Kouango', '698');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10904', 'Batangafo', '699');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10905', 'Bossangoa', '699');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10906', 'Bouca', '699');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10907', 'Kabo', '699');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10908', 'Bocaranga', '700');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10909', 'Bozoum', '700');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10910', 'Paoua', '700');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10911', 'Nola', '701');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10912', 'Birao', '702');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10913', 'Ati', '703');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10914', 'Oum Hadjer', '703');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10915', 'Biltine', '704');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10916', 'Aouzou', '705');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10917', 'Bardai', '705');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10918', 'Fada', '705');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10919', 'Faya', '705');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10920', 'Bokoro', '706');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10921', 'Bousso', '706');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10922', 'Dourbali', '706');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10923', 'Massaguet', '706');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10924', 'Massakory', '706');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10925', 'Massenya', '706');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10926', 'N\'Djamena', '706');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10927', 'Ngama', '706');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10928', 'Bitkine', '707');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10929', 'Melfi', '707');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10930', 'Mongo', '707');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10931', 'Mao', '708');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10932', 'Moussoro', '708');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10933', 'Rig-Rig', '708');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10934', 'Bol', '709');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10935', 'Bongor', '712');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10936', 'Fianga', '712');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10937', 'Gounou Gaya', '712');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10938', 'Guelengdeng', '712');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10939', 'Lere', '712');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10940', 'Pala', '712');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10941', 'Goundi', '713');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10942', 'Koumra', '713');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10943', 'Kyabe', '713');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10944', 'Moissala', '713');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10945', 'Sarh', '713');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10946', 'Abeche', '714');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10947', 'Adre', '714');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10948', 'Am Dam', '714');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10949', 'Abou Deia', '715');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10950', 'Am Timan', '715');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10951', 'Mangueigne', '715');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10952', 'Benoy', '716');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10953', 'Bere', '716');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10954', 'Kelo', '716');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10955', 'Lai', '716');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10956', 'Aisen', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10957', 'Chile Chico', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10958', 'Cisnes', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10959', 'Cochrane', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10960', 'Coihaique', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10961', 'Guaitecas', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10962', 'Lago Verde', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10963', 'O\'Higgins', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10964', 'Rio Ibanez', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10965', 'Tortel', '717');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10966', 'Antofagasta', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10967', 'Calama', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10968', 'Maria Elena', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10969', 'Mejilones', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10970', 'Ollague', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10971', 'San Pedro de Atacama', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10972', 'Sierra Gorda', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10973', 'Taltal', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10974', 'Tocopilla', '718');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10975', 'Angol', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10976', 'Carahue', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10977', 'Collipulli', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10978', 'Cunco', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10979', 'Curacautin', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10980', 'Curarrehue', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10981', 'Ercilla', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10982', 'Freire', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10983', 'Galvarino', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10984', 'Gorbea', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10985', 'Lautaro', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10986', 'Loncoche', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10987', 'Lonquimay', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10988', 'Los Sauces', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10989', 'Lumaco', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10990', 'Melipeuco', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10991', 'Nueva Imperial', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10992', 'Padre las Casas', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10993', 'Perquenco', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10994', 'Pitrufquen', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10995', 'Pucon', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10996', 'Puren', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10997', 'Renaico', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10998', 'Saavedra', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('10999', 'Temuco', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11000', 'Teodoro Schmidt', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11001', 'Tolten', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11002', 'Traiguen', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11003', 'Victoria', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11004', 'Vilcun', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11005', 'Villarica', '719');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11006', 'Alto del Carmen', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11007', 'Caldera', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11008', 'Chanaral', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11009', 'Copiapo', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11010', 'Diego de Almagro', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11011', 'Freirina', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11012', 'Huasco', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11013', 'Tierra Amarilla', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11014', 'Vallenar', '720');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11015', 'Andacollo', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11016', 'Canela', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11017', 'Combarbala', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11018', 'Coquimbo', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11019', 'Illapel', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11020', 'La Higuera', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11021', 'La Serena', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11022', 'Los Vilos', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11023', 'Monte Patria', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11024', 'Ovalle', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11025', 'Paiguano', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11026', 'Punitaci', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11027', 'Rio Hurtado', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11028', 'Salamanca', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11029', 'Vicuna', '722');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11030', 'Cabo de Horno', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11031', 'Laguna Blanca', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11032', 'Natales', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11033', 'Porvenir', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11034', 'Primavera', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11035', 'Punta Arenas', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11036', 'Rio Verde', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11037', 'San Gregorio', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11038', 'Timaukel', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11039', 'Torres del Paine', '725');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11040', 'Cauquenes', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11041', 'Chanco', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11042', 'Colbun', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11043', 'Constitucion', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11044', 'Curepto', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11045', 'Curico', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11046', 'Empedrado', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11047', 'Hualane', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11048', 'Licanten', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11049', 'Linares', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11050', 'Longavi', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11051', 'Maule', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11052', 'Molina', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11053', 'Parral', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11054', 'Pelarco', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11055', 'Pelluhue', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11056', 'Pencahue', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11057', 'Rauco', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11058', 'Retiro', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11059', 'Rio Claro', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11060', 'Romeral', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11061', 'Sagrada Familia', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11062', 'San Clemente', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11063', 'San Javier', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11064', 'San Rafael', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11065', 'Talca', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11066', 'Teno', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11067', 'Vichuquen', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11068', 'Villa Alegre', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11069', 'Yerbas Buenas', '726');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11070', 'Alhue', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11071', 'Buin', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11072', 'Calera de Tango', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11073', 'Colina', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11074', 'Curacavi', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11075', 'El Monte', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11076', 'Isla de Maipo', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11077', 'Lampa', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11078', 'Maria Pinto', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11079', 'Melipilla', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11080', 'Padre Hurtado', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11081', 'Paine', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11082', 'Penaflor', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11083', 'Pirque', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11084', 'Puente Alto', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11085', 'Quilicura', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11086', 'San Bernardo', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11087', 'San Jose de Maipo', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11088', 'San Pedro', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11089', 'Santiago', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11090', 'Talagante', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11091', 'Tiltil', '727');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11092', 'Alhue', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11093', 'Buin', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11094', 'Calera de Tango', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11095', 'Colina', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11096', 'Curacavi', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11097', 'El Monte', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11098', 'Isla de Maipo', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11099', 'Lampa', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11100', 'Maria Pinto', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11101', 'Melipilla', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11102', 'Padre Hurtado', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11103', 'Paine', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11104', 'Penaflor', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11105', 'Pirque', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11106', 'Puente Alto', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11107', 'Quilicura', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11108', 'San Bernardo', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11109', 'San Jose de Maipo', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11110', 'San Pedro', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11111', 'Santiago', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11112', 'Talagante', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11113', 'Tiltil', '728');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11114', 'Arica', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11115', 'Camarones', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11116', 'Camina', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11117', 'Colchane', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11118', 'General Lagos', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11119', 'Huara', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11120', 'Iquique', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11121', 'Pica', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11122', 'Pozo Almonte', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11123', 'Putre', '729');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11124', 'Algarrobo', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11125', 'Cabildo', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11126', 'Calera', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11127', 'Calle Larga', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11128', 'Cartagena', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11129', 'Casablanca', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11130', 'Catemu', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11131', 'Concon', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11132', 'El Quisco', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11133', 'El Tabo', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11134', 'Hijuelas', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11135', 'La Cruz', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11136', 'La Ligua', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11137', 'Limache', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11138', 'Llaillay', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11139', 'Los Andes', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11140', 'Nogales', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11141', 'Olmue', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11142', 'Panquehue', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11143', 'Papudo', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11144', 'Petorca', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11145', 'Puchuncavi', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11146', 'Putaendeo', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11147', 'Quillota', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11148', 'Quilpue', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11149', 'Quintero', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11150', 'Rinconada', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11151', 'San Antonio', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11152', 'San Esteban', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11153', 'San Felipe', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11154', 'Santa Maria', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11155', 'Santo Domingo', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11156', 'Valparaiso', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11157', 'Villa Alemana', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11158', 'Vina del Mar', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11159', 'Zapallar', '730');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11160', 'Fengyang', '731');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11161', 'Guangde', '731');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11162', 'Liuan', '731');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11163', 'Ningguo', '731');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11164', 'Shucheng', '731');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11165', 'Xinchang', '731');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11166', 'Xuancheng', '731');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11167', 'Fengyang', '732');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11168', 'Guangde', '732');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11169', 'Liuan', '732');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11170', 'Ningguo', '732');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11171', 'Shucheng', '732');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11172', 'Xinchang', '732');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11173', 'Xuancheng', '732');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11174', 'Fengyang', '733');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11175', 'Guangde', '733');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11176', 'Liuan', '733');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11177', 'Ningguo', '733');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11178', 'Shucheng', '733');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11179', 'Xinchang', '733');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11180', 'Xuancheng', '733');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11181', 'Aomen', '734');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11182', 'Beijing', '735');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11183', 'Changping', '735');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11184', 'Fangshan', '735');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11185', 'Huangcun', '735');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11186', 'Liangxiang', '735');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11187', 'Mentougou', '735');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11188', 'Shunyi', '735');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11189', 'Tongzhou', '735');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11190', 'Beijing', '736');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11191', 'Changping', '736');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11192', 'Fangshan', '736');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11193', 'Huangcun', '736');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11194', 'Liangxiang', '736');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11195', 'Mentougou', '736');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11196', 'Shunyi', '736');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11197', 'Tongzhou', '736');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11198', 'Beibei', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11199', 'Chongqing', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11200', 'Fuling', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11201', 'Longhua', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11202', 'Nantongkuang', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11203', 'Wanxian', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11204', 'Xiuma', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11205', 'Yubei', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11206', 'Yudong', '737');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11207', 'Bantou', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11208', 'Dongshan', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11209', 'Fuan', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11210', 'Fujian', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11211', 'Fuqing', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11212', 'Fuzhou', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11213', 'Gantou', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11214', 'Hanyang', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11215', 'Jiangkou', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11216', 'Jiaocheng', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11217', 'Jinjiang', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11218', 'Jinshang', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11219', 'Longhai', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11220', 'Longyan', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11221', 'Luoyang', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11222', 'Nanan', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11223', 'Nanping', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11224', 'Nanpu', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11225', 'Putian', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11226', 'Qingyang', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11227', 'Quanzhou', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11228', 'Rongcheng', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11229', 'Sanming', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11230', 'Shaowu', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11231', 'Shima', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11232', 'Shishi', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11233', 'Tantou', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11234', 'Tongshan', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11235', 'Xiamen', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11236', 'Xiapu', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11237', 'Xiapu Ningde', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11238', 'Ximei', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11239', 'Yongan', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11240', 'Zhangzhou', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11241', 'Zhicheng', '738');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11242', 'Bantou', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11243', 'Dongshan', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11244', 'Fuan', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11245', 'Fujian', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11246', 'Fuqing', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11247', 'Fuzhou', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11248', 'Gantou', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11249', 'Hanyang', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11250', 'Jiangkou', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11251', 'Jiaocheng', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11252', 'Jinjiang', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11253', 'Jinshang', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11254', 'Longhai', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11255', 'Longyan', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11256', 'Luoyang', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11257', 'Nanan', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11258', 'Nanping', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11259', 'Nanpu', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11260', 'Putian', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11261', 'Qingyang', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11262', 'Quanzhou', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11263', 'Rongcheng', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11264', 'Sanming', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11265', 'Shaowu', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11266', 'Shima', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11267', 'Shishi', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11268', 'Tantou', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11269', 'Tongshan', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11270', 'Xiamen', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11271', 'Xiapu', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11272', 'Xiapu Ningde', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11273', 'Ximei', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11274', 'Yongan', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11275', 'Zhangzhou', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11276', 'Zhicheng', '739');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11277', 'Baiyin', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11278', 'Baoji', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11279', 'Beidao', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11280', 'Jiayuguan', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11281', 'Jinchang', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11282', 'Jiuquan', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11283', 'Lanzhou', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11284', 'Linxia', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11285', 'Pingliang', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11286', 'Qincheng', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11287', 'Wuwei', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11288', 'Yaojie', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11289', 'Yumen', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11290', 'Zhangye', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11291', 'Zhuanglang', '740');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11292', 'Anbu', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11293', 'Chaozhou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11294', 'Chenghai', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11295', 'Chuncheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11296', 'Daliang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11297', 'Danshui', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11298', 'Dongguan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11299', 'Donghai', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11300', 'Dongli', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11301', 'Dongzhen', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11302', 'Ducheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11303', 'Encheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11304', 'Foahn', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11305', 'Foshan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11306', 'Gaozhou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11307', 'Guangdong', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11308', 'Guangzhou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11309', 'Guanjiao', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11310', 'Haicheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11311', 'Haimen', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11312', 'Hepo', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11313', 'Houpu', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11314', 'Huaicheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11315', 'Huanggang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11316', 'Huangpu', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11317', 'Huazhou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11318', 'Huicheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11319', 'Huizhou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11320', 'Humen', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11321', 'Jiangmen', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11322', 'Jiazi', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11323', 'Jieshi', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11324', 'Jieyang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11325', 'Lecheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11326', 'Leicheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11327', 'Liancheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11328', 'Lianzhou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11329', 'Licheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11330', 'Liusha', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11331', 'Longgang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11332', 'Lubu', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11333', 'Luocheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11334', 'Luohu', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11335', 'Luoyang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11336', 'Maba', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11337', 'Maoming', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11338', 'Mata', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11339', 'Meilu', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11340', 'Meizhou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11341', 'Mianchang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11342', 'Nanfeng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11343', 'Nanhai', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11344', 'Pingshan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11345', 'Qingtang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11346', 'Qingyuan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11347', 'Rongcheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11348', 'Sanbu', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11349', 'Shantou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11350', 'Shanwei', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11351', 'Shaoguan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11352', 'Shaping', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11353', 'Shenzhen', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11354', 'Shilong', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11355', 'Shiqiao', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11356', 'Shiwan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11357', 'Shuizhai', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11358', 'Shunde', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11359', 'Suicheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11360', 'Taicheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11361', 'Tangping', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11362', 'Xiaolan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11363', 'Xinan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11364', 'Xingcheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11365', 'Xiongzhou', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11366', 'Xucheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11367', 'Yangjiang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11368', 'Yingcheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11369', 'Yuancheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11370', 'Yuncheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11371', 'Yunfu', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11372', 'Zengcheng', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11373', 'Zhanjiang', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11374', 'Zhaoqing', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11375', 'Zhilong', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11376', 'Zhongshan', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11377', 'Zhuhai', '741');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11378', 'Anbu', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11379', 'Chaozhou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11380', 'Chenghai', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11381', 'Chuncheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11382', 'Daliang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11383', 'Danshui', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11384', 'Dongguan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11385', 'Donghai', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11386', 'Dongli', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11387', 'Dongzhen', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11388', 'Ducheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11389', 'Encheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11390', 'Foahn', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11391', 'Foshan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11392', 'Gaozhou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11393', 'Guangdong', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11394', 'Guangzhou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11395', 'Guanjiao', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11396', 'Haicheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11397', 'Haimen', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11398', 'Hepo', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11399', 'Houpu', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11400', 'Huaicheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11401', 'Huanggang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11402', 'Huangpu', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11403', 'Huazhou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11404', 'Huicheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11405', 'Huizhou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11406', 'Humen', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11407', 'Jiangmen', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11408', 'Jiazi', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11409', 'Jieshi', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11410', 'Jieyang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11411', 'Lecheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11412', 'Leicheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11413', 'Liancheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11414', 'Lianzhou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11415', 'Licheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11416', 'Liusha', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11417', 'Longgang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11418', 'Lubu', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11419', 'Luocheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11420', 'Luohu', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11421', 'Luoyang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11422', 'Maba', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11423', 'Maoming', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11424', 'Mata', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11425', 'Meilu', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11426', 'Meizhou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11427', 'Mianchang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11428', 'Nanfeng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11429', 'Nanhai', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11430', 'Pingshan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11431', 'Qingtang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11432', 'Qingyuan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11433', 'Rongcheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11434', 'Sanbu', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11435', 'Shantou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11436', 'Shanwei', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11437', 'Shaoguan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11438', 'Shaping', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11439', 'Shenzhen', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11440', 'Shilong', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11441', 'Shiqiao', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11442', 'Shiwan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11443', 'Shuizhai', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11444', 'Shunde', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11445', 'Suicheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11446', 'Taicheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11447', 'Tangping', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11448', 'Xiaolan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11449', 'Xinan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11450', 'Xingcheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11451', 'Xiongzhou', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11452', 'Xucheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11453', 'Yangjiang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11454', 'Yingcheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11455', 'Yuancheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11456', 'Yuncheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11457', 'Yunfu', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11458', 'Zengcheng', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11459', 'Zhanjiang', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11460', 'Zhaoqing', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11461', 'Zhilong', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11462', 'Zhongshan', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11463', 'Zhuhai', '742');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11464', 'Babu', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11465', 'Baihe', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11466', 'Baise', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11467', 'Beihai', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11468', 'Binzhou', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11469', 'Bose', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11470', 'Fangchenggang', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11471', 'Guicheng', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11472', 'Guilin', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11473', 'Guiping', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11474', 'Jinchengjiang', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11475', 'Jinji', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11476', 'Laibin', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11477', 'Lianzhou', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11478', 'Liuzhou', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11479', 'Luorong', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11480', 'Matong', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11481', 'Nandu', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11482', 'Nanning', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11483', 'Pingnan', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11484', 'Pumiao', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11485', 'Qinzhou', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11486', 'Songhua', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11487', 'Wuzhou', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11488', 'Yashan', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11489', 'Yulin', '743');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11490', 'Anshun', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11491', 'Bijie', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11492', 'Caohai', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11493', 'Duyun', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11494', 'Guiyang', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11495', 'Kaili', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11496', 'Liupanshui', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11497', 'Luoyang', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11498', 'Pingzhai', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11499', 'Tongren', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11500', 'Tongzi', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11501', 'Xiaoweizhai', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11502', 'Xingyi', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11503', 'Zunyi', '744');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11504', 'Chengmai', '745');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11505', 'Dingan', '745');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11506', 'Haikou', '745');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11507', 'Lingao', '745');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11508', 'Qiongshan', '745');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11509', 'Sansha ', '745');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11510', 'Sanya', '745');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11511', 'Wanning', '745');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11512', 'Anping', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11513', 'Baoding', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11514', 'Botou', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11515', 'Cangzhou', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11516', 'Changli', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11517', 'Chengde', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11518', 'Dingzhou', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11519', 'Fengfeng', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11520', 'Fengrun', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11521', 'Guye', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11522', 'Handan', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11523', 'Hebei', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11524', 'Hecun', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11525', 'Hejian', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11526', 'Hengshui', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11527', 'Huanghua', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11528', 'Jingxingkuang', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11529', 'Jinzhou', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11530', 'Langfang', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11531', 'Lianzhou', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11532', 'Linshui', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11533', 'Linxi', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11534', 'Longyao County', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11535', 'Nangong', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11536', 'Pengcheng', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11537', 'Qinhuangdao', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11538', 'Renqiu', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11539', 'Shahe', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11540', 'Shijiazhuang', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11541', 'Tangjiazhuang', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11542', 'Tangshan', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11543', 'Wuan', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11544', 'Xian County', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11545', 'Xingtai', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11546', 'Xinji', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11547', 'Xinle', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11548', 'Xuanhua', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11549', 'Zhangjiakou', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11550', 'Zhaogezhuang', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11551', 'Zhuozhou', '746');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11552', 'Acheng', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11553', 'Anda', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11554', 'Angangxi', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11555', 'Baiquan', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11556', 'Bamiantong', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11557', 'Baoqing', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11558', 'Baoshan', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11559', 'Bayan', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11560', 'Beian', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11561', 'Binzhou', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11562', 'Boli', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11563', 'Chaihe', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11564', 'Chengzihe', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11565', 'Cuiluan', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11566', 'Daqing', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11567', 'Didao', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11568', 'Dongning', '747');
INSERT INTO `cities` (`id`, `name`, `state_id`) VALUES ('11569', 'Fujin', '747');
INSERT INTO `cities` (`id`, `na